<?php
/*
Copyright (©) 2003-2013 Teus Benschop.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/


error_reporting (E_ALL);
ini_set('display_errors', '1');


require_once ("../database/sqlite.php");
require_once ("../database/sqliteinjection.php");
require_once ("../database/notes.php");


$database_notes = Database_Notes::getInstance ();
$database_notes->create ();


// This upgrade routine is intended for upgrading version 1.4 to version 1.5.
ignore_user_abort (true);
set_time_limit (0);
$notesFolder = $database_notes->mainFolder ();
$files = scandir ($notesFolder);
if (count ($files) == 3) {
  $query = "SELECT * FROM notes;";
  $result = Database_SQLite::query ($database_notes->db, $query);
  foreach ($result as $row) {
    for ($i = 0; $i <= 11; $i++) unset ($row[$i]);
    $identifier = $row['identifier'];
    $modified = $row['modified'];
    $assigned = $row['assigned'];
    $subscriptions = $row['subscriptions'];
    $bible = $row['bible'];
    $passage = $row['passage'];
    $status = $row['status'];
    $severity = $row['severity'];
    $summary = $row['summary'];
    $contents = $row['contents'];
    mkdir ($database_notes->noteFolder ($identifier), 0777, true);
    file_put_contents ($database_notes->modifiedFile ($identifier), $modified);
    file_put_contents ($database_notes->assignedFile ($identifier), $assigned);
    file_put_contents ($database_notes->subscriptionsFile ($identifier), $subscriptions);
    file_put_contents ($database_notes->bibleFile ($identifier), $bible);
    file_put_contents ($database_notes->passageFile ($identifier), $passage);
    file_put_contents ($database_notes->statusFile ($identifier), $status);
    file_put_contents ($database_notes->severityFile ($identifier), $severity);
    file_put_contents ($database_notes->summaryFile ($identifier), $summary);
    file_put_contents ($database_notes->contentsFile ($identifier), $contents);
  }
}


?>
