<?php
/*
Copyright (©) 2003-2014 Teus Benschop.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/


class Database_Logs
{
  /**
  * Singleton logic.
  */
  private static $instance;
  private function __construct () {
  }
  public static function getInstance()
  {
    if (empty (self::$instance)) {
      self::$instance = new Database_Logs();
    }
    return self::$instance;
  }


  public function rotate ()
  {
    $timestamp = strtotime ("-5 days");
    chdir ($this->folder ());
    @unlink ("5.log");
    @rename ("4.log", "5.log");
    @rename ("3.log", "4.log");
    @rename ("2.log", "3.log");
    @rename ("1.log", "2.log");
    @rename ("0.log", "1.log");
    $files = glob ($this->folder () . "/*");
    foreach ($files as $file) {
      $basename = basename ($file);
      if ($basename = "5.log") continue;
      if ($basename = "4.log") continue;
      if ($basename = "3.log") continue;
      if ($basename = "2.log") continue;
      if ($basename = "1.log") continue;
      unlink ($file);
    }
  }
  
  
  private function folder ()
  {
    $folder = realpath (__DIR__ . "/../logbook");
    return $folder;
  }


  // Logs entry.
  public function log ($description, $level = 5)
  {
    // No new lines.
    $description = str_replace ("\n", " ", $description);
    $time = time ();
    $file = $this->folder () . "/0.log";
    file_put_contents ($file, "$level $time $description\n", FILE_APPEND);
  }


  // Get the logbook entries for $day.
  // Day 0 is today, day 1 is yesterday, and so on.
  public function get ($day)
  {
    $day = (int) $day;
    $file = $this->folder () . "/$day.log";
    $size = 0;
    $entries = array ();
    if (file_exists ($file)) {
      $size = filesize ($file);
      $entries = file ($file);
    }
    return array ($size, $entries);
  }


  // Gets logbook entries beyond filesize $size.
  public function getNext ($size)
  {
    $file = $this->folder () . "/0.log";
    $filesize = 0;
    if (file_exists ($file)) {
      $filesize = filesize ($file);
    }
    if ($filesize <= $size) return NULL;
    $lines = array ();
    $fp = fopen ($file, 'r');
    fseek ($fp, $size + 1);
    while (($buffer = fgets ($fp)) !== false) {
      $lines [] = $buffer;
    }
    fclose ($fp);
    return array ($filesize, $lines);
  }


}


?>
