<?php
/*
Copyright (©) 2003-2014 Teus Benschop.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/


if (php_sapi_name () != "cli") die;


require_once ("../bootstrap/bootstrap.php");


ignore_user_abort (true);
set_time_limit (0);


$bible = $argv [1];


$database_logs = Database_Logs::getInstance ();
$database_config_general = Database_Config_General::getInstance ();
$database_bibles = Database_Bibles::getInstance ();
$database_books = Database_Books::getInstance ();
$database_config_bible = Database_Config_Bible::getInstance ();


$stylesheet = $database_config_bible->getExportStylesheet ($bible);


$database_logs->log ($bible . ": " . gettext ("Start export to a SWORD module"), Filter_Roles::TRANSLATOR_LEVEL);


// Save the full USFM to file.
$fullUsfmFile = tempnam (sys_get_temp_dir (), "");
$usfmdata = "";
$books = $database_bibles->getBooks ($bible);
foreach ($books as $book) {
  $chapters = $database_bibles->getChapters ($bible, $book);
  foreach ($chapters as $chapter) {
    $usfm = $database_bibles->getChapter ($bible, $book, $chapter);
    $usfm = trim ($usfm);
    $usfmdata .= $usfm;
    $usfmdata .= "\n";
  }
}
file_put_contents ($fullUsfmFile, $usfmdata);


// Start generating the basic USFM.
$usfmdata = "";

$books = $database_bibles->getBooks ($bible);
foreach ($books as $book) {

  $usfmdata .= "\\id " . $database_books->getUsfmFromId ($book) . "\n";

  $chapters = $database_bibles->getChapters ($bible, $book);
  foreach ($chapters as $chapter) {

    // The text filter for this chapter.
    $filter_text = new Filter_Text ($bible);

    // Basic USFM for this chapter.
    $filter_text->initializeHeadingsAndTextPerVerse ();

    // Get the USFM code for the current chapter.
    $usfm = $database_bibles->getChapter ($bible, $book, $chapter);
    $usfm = trim ($usfm);

    // Add the chapter's USFM code to the Text_* filter.
    $filter_text->addUsfmCode ($usfm);
    
    // Convert the chapter
    $filter_text->run ($stylesheet);

    // Generate basic USFM.
    if ($chapter > 0) {
      $verses_text = $filter_text->getVersesText ();
      $usfmdata .= "\\c $chapter\n";
      $usfmdata .= "\\p\n";
      foreach ($verses_text as $verse => $text) {
        $usfmdata .= "\\v $verse $text\n";
      }
    }
  }
}

// Save basic USFM to file.
$basicUsfmFile = tempnam (sys_get_temp_dir (), "");
file_put_contents ($basicUsfmFile, $usfmdata);


// Folders for the exports to OSIS.
$directory = Export_Logic::osisDirectory ($bible);
if (!file_exists ($directory)) mkdir ($directory, 0777, true);
$directoryBasicPython = $directory . Export_Logic::osisSwordVariantDirectory ('py', 1);
if (!file_exists ($directoryBasicPython)) mkdir ($directoryBasicPython, 0777, true);
$directoryFullPython = $directory . Export_Logic::osisSwordVariantDirectory ('py', 2);
if (!file_exists ($directoryFullPython)) mkdir ($directoryFullPython, 0777, true);
$directoryBasicPerl = $directory . Export_Logic::osisSwordVariantDirectory ('pl', 1);
if (!file_exists ($directoryBasicPerl)) mkdir ($directoryBasicPerl, 0777, true);
$directoryFullPerl = $directory . Export_Logic::osisSwordVariantDirectory ('pl', 2);
if (!file_exists ($directoryFullPerl)) mkdir ($directoryFullPerl, 0777, true);


// Copy info for OSIS.
copy ("../osis/osis.html", "$directory/readme.html");


// Generate OSIS in four variants.
$database_logs->log (gettext ("Convert Bible from full USFM to OSIS through Python") . " $bible", Filter_Roles::TRANSLATOR_LEVEL);
$osis_text = new Osis_Text ($fullUsfmFile, $directoryFullPython, $bible);
$osis_text->run ('py');
$database_logs->log (gettext ("Convert Bible from basic USFM to OSIS through Python") . " $bible", Filter_Roles::TRANSLATOR_LEVEL);
$osis_text = new Osis_Text ($basicUsfmFile, $directoryBasicPython, $bible);
$osis_text->run ('py');
$database_logs->log (gettext ("Convert Bible from full USFM to OSIS through Perl") . " $bible", Filter_Roles::TRANSLATOR_LEVEL);
$osis_text = new Osis_Text ($fullUsfmFile, $directoryFullPerl, $bible);
$osis_text->run ('pl');
$database_logs->log (gettext ("Convert Bible from basic USFM to OSIS through Perl") . " $bible", Filter_Roles::TRANSLATOR_LEVEL);
$osis_text = new Osis_Text ($basicUsfmFile, $directoryBasicPerl, $bible);
$osis_text->run ('pl');


// Folders for the exports.
$directory = Export_Logic::bibleDirectory ($bible) . "/sword";
if (!file_exists ($directory)) mkdir ($directory, 0777, true);
$directoryBasicPython = $directory . Export_Logic::osisSwordVariantDirectory ('py', 1);
if (!file_exists ($directoryBasicPython)) mkdir ($directoryBasicPython, 0777, true);
$directoryFullPython = $directory . Export_Logic::osisSwordVariantDirectory ('py', 2);
if (!file_exists ($directoryFullPython)) mkdir ($directoryFullPython, 0777, true);
$directoryBasicPerl = $directory . Export_Logic::osisSwordVariantDirectory ('pl', 1);
if (!file_exists ($directoryBasicPerl)) mkdir ($directoryBasicPerl, 0777, true);
$directoryFullPerl = $directory . Export_Logic::osisSwordVariantDirectory ('pl', 2);
if (!file_exists ($directoryFullPerl)) mkdir ($directoryFullPerl, 0777, true);


// Copy info for SWORD
$contents = file_get_contents ("../sword/sword.html");
$host = $database_config_general->getSiteURL ();
$host = parse_url ($host, PHP_URL_HOST);
$contents = str_replace ("_host_", "$host", $contents);
$contents = str_replace ("_bible_", $bible, $contents);
file_put_contents ("$directory/readme.html", $contents);


$osisDirectory = Export_Logic::bibleDirectory ($bible) . "/osis";


$sword_text = new Sword_Text ($osisDirectory . Export_Logic::osisSwordVariantDirectory ('py', 1), $directoryBasicPython, $bible);
$sword_text->run ("Bible.xml");
$sword_text = new Sword_Text ($osisDirectory . Export_Logic::osisSwordVariantDirectory ('py', 2), $directoryFullPython, $bible);
$sword_text->run ("Bible.xml");
$sword_text = new Sword_Text ($osisDirectory . Export_Logic::osisSwordVariantDirectory ('pl', 1), $directoryBasicPerl, $bible);
$sword_text->run ("Bible.xml");
$sword_text = new Sword_Text ($osisDirectory . Export_Logic::osisSwordVariantDirectory ('pl', 2), $directoryFullPerl, $bible);
$sword_text->run ("Bible.xml");
// Make the Sword folder readable for the FTP server for the module repository.
system ("cd ". escapeshellarg ($directory) . " ; chmod -R +r *");


$database_logs->log ($bible . ": " . gettext ("SWORD export ready"), Filter_Roles::TRANSLATOR_LEVEL);


?>
