<?php
/*
Copyright (©) 2003-2014 Teus Benschop.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/


// Security: The script runs from the cli SAPI only.
if (php_sapi_name () != "cli") die;

echo "Creating SQLite database from XML data\n";

$db = new PDO ("sqlite:kjv.sqlite");

$db->exec ("PRAGMA temp_store = MEMORY;");
$db->exec ("PRAGMA synchronous = OFF;");
$db->exec ("PRAGMA journal_mode = OFF;");

$db->exec ("DROP TABLE IF EXISTS kjv;");

$sql = <<<'EOD'
CREATE TABLE IF NOT EXISTS kjv (
  book integer,
  chapter integer,
  verse integer,
  strong text,
  english text
);
EOD;
$db->exec ($sql);

$book = 0;
$chapter = 0;
$verse = 0;
$lemma = "";
$english = "";

$xml = new XMLReader();

$xml->open ("kjvfull.xml");

while ($xml->read ()) {

  $nodeType = $xml->nodeType;

  $name = $xml->name;

  if ($nodeType == XMLReader::ELEMENT) {

    if ($name == "div") {
      $type = $xml->getAttribute ("type");
      if ($type == "book") {
        $book++;
        $chapter = 0;
        $verse = 0;
        echo "Book $book\n";
      }
    }

    if ($name == "chapter") {
      $chapter++;
      $verse = 0;
    }

    if ($name == "verse") {
      $sID = $xml->getAttribute ("sID");
      if ($sID) {
        $verse++;
      }
    }

    if ($name == "w") {
      $lemma = $xml->getAttribute ("lemma");
      $lemma = trim ($lemma);
    }

  }

  if ($nodeType == XMLReader::TEXT) {
    $value = $xml->value;
    $english = trim ($value);
  }

  if ($nodeType == XMLReader::END_ELEMENT) {
    if ($name == "w") {
      $lemma = explode (" ", $lemma);
      foreach ($lemma as $strong) {
        if (strpos ($strong, "strong") === false) continue;
        $strong = str_replace ("strong:", "", $strong);
        $strong = str_replace ("'", "''", $strong);
        $english = str_replace ("'", "''", $english);
        $sql = "INSERT INTO kjv (book, chapter, verse, strong, english) VALUES ($book, $chapter, $verse, '$strong', '$english');";
        $db->exec ($sql);
      }
      $lemma = "";
      $english = "";
    }
  }

}

$xml->close ();

echo "Ready\n";

?>
