<?php
/*
Copyright (©) 2003-2014 Teus Benschop.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/


chdir (__DIR__);


require_once ("../bootstrap/bootstrap.php");


// The script runs through the cli Server API only.
if (php_sapi_name () != "cli") {
  die;
}


ignore_user_abort (true);
set_time_limit (0);


$config_general = Database_Config_General::getInstance ();
$database_logs = Database_Logs::getInstance ();


// CPU-intensive actions run at night.
// This keeps the site more responsive during the day.
$hour = date ('G');
$minute = date ('i');


// At midnight, for five minutes, do nothing to allow time for external backup
// without corrupting the SQLite databases due to simultaneous access by
// bibledit-web and by the backup program.
if ($hour == 0) {
  if ($minute <= 5) {
    die;
  }
}



// At the sixth minute after midnight, after the backup silence, rotate the logbook.
if (($hour == 0) && ($minute == 6)) {
  $directory = dirname (__DIR__) . "/journal";
  $command = "cd $directory; php rotate.php";
  Tasks_Logic::queue ($command);
}


// Every minute send out queued email.
$command = "cd " . __DIR__ . "; php mailer.php";
Tasks_Logic::queue ($command);


// Check for new mail every five minutes.
// Do not check more often with gmail else the account may be shut down.
if (($minute % 5) == 0) {
  $command = "cd " . __DIR__ . "; php receiver.php";
  Tasks_Logic::queue ($command);
}


// The order for running the following nightly scripts is important.
// Any of those scripts may influence the subsequent ones.
// The order is such that all information generated is as recent as possible.
// More important tasks are done first, and the less important ones at the end.
// This leads to an order as visible in the code below.


// Sending and receiving Bibles to and from the git repository.
// On a production website running on an inexpensive virtual private server
// with 512 Mbyte of memory and a fast network connection,
// sending and receiving two Bibles takes more than 15 minutes when there are many changes.
$sendreceive = (($hour == 0) && ($minute == 6));
$repeat = (($minute % 5) == 0);
if ($sendreceive || $repeat) {
  SendReceive_Logic::queueAll ($sendreceive);
}


// Deal with the changes in the Bible made per user.
// Deal with notifications for the daily changes in the Bibles.
// This takes a few minutes on a production machine with two Bibles and changes in several chapters.
if (($hour == 0) && ($minute == 20)) {
  Changes_Logic::startAll ();
}


// Comb through the git log and add the changes to the history.
if (($hour == 0) && ($minute == 30)) {
  $directory = dirname (dirname (__FILE__)) . "/changes";
  $command = "cd $directory; php git.php";
  Tasks_Logic::queue ($command);
  unset ($directory);
}


// Run the checks on the Bibles.
// This takes 15 minutes on a production machine with two Bibles.
if (($hour == 0) && ($minute == 30)) {
  Checks_Logic::startAll ();
}


// Database maintenance and trimming.
// It takes a few minutes on a production machine.
if (($hour == 0) && ($minute == 50)) {
  $command = "cd " . __DIR__ . "; php database.php";
  Tasks_Logic::queue ($command);
}


// Sprint burndown.
// It runs at midnight, but also in the morning and afternoon.
// The script itself determines what to do at various times of the day,
// or days of the week or month.
$burndown = false;
if (($hour == 1) && ($minute == 5)) $burndown = true;
if (($hour == 10) && ($minute == 0)) $burndown = true;
if (($hour == 14) && ($minute == 0)) $burndown = true;
if ($burndown) {
  Sprint_Logic::burndown ("", false);
}
unset ($burndown);


// A flag is set upon installation, so it (re-)generates the stylesheets once.
$create_css_flag = "../dyncss/create_css.txt";
if (file_exists ($create_css_flag)) {
  unlink ($create_css_flag);
  Styles_Sheets::create_all ();
}


// Export the Bibles to the various output formats.
// This may take an hour on a production machine.
if (($hour == 1) && ($minute == 10)) {
  Export_Logic::scheduleAll ();
}


// Re-index Bible and notes.
if (($hour == 2) && ($minute == 0)) {
  $directory = dirname (__DIR__) . "/search";
  $command = "cd $directory; php rebibles.php";
  Tasks_Logic::queue ($command);
  $directory = dirname (__DIR__) . "/search";
  $command = "cd $directory; php renotes.php";
  Tasks_Logic::queue ($command);
}


// Delete temporal files older than a few days.
if (($hour == 2) && ($minute == 0)) {
  $command = "cd " . __DIR__ . "; php temp.php";
  Tasks_Logic::queue ($command);
}


// Email statistics to the users.
if (($hour == 3) && ($minute == 0)) {
  $command = "cd " . __DIR__ . "; php statistics.php";
  Tasks_Logic::queue ($command);
}


?>
