<?php
/*
Copyright (©) 2003-2014 Teus Benschop.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/


require_once ("../bootstrap/bootstrap.php");
page_access_level (Filter_Roles::CONSULTANT_LEVEL);


$database_config_general = Database_Config_General::getInstance ();
$session_logic = Session_Logic::getInstance ();
$database_users = Database_Users::getInstance ();


Assets_Page::header (Locale_Translate::_("Client mode"));
$view = new Assets_View (__FILE__);


if (isset($_GET['client'])) {
  $database_config_general->setClientMode (!Filter_Client::enabled ());
}
$view->view->client = Filter_Client::enabled ();


@$url = $_POST ['url'];
if (isset ($url)) {
  $database_config_general->setServerAddress ($url);
}
$address = $database_config_general->getServerAddress ();
$view->view->url = $address;


if (isset ($_GET ['test'])) {
  $username = $session_logic->currentUser ();
  $user_encoded = bin2hex ($username);
  $password = $database_users->getmd5 ($username);
  $level = $database_users->getUserLevel ($username);
  $url = "$address/sync/setup.php?user=$user_encoded&pass=$password&level=$level";
  @$response = file_get_contents ($url);
  if ($response === false) {
    $view->view->error = Locale_Translate::_("Could not connect to the server.");
  } else if ($response == 1) {
    $view->view->success = Locale_Translate::_("Connection is okay.");
  } else {
    $view->view->error = Locale_Translate::_("Check that your username exists on the server, and that your password here is the same on the server, and that your role here is the same as your role on the server.");
  }
}


$view->render ("client.php");


Assets_Page::footer ();


?>
