/**CHeaderFile*************************************************************
  PackageName [Bdd Scout]
  Synopsis    [Bdd Scout]

  FileName    [bddscout.h]
  Revision    [$Revision: 21 $]
  Date        [$Date: 2011-12-27 12:07:49 +0100 (tor, 27 dec 2011) $]
  Authors     [Robert Meolic (meolic@uni-mb.si)]
  Description [The file bddscout.h contains some declarations.]
  SeeAlso     []

  Copyright   [This file is part of Bdd Scout package.
               Copyright (C) 2008, 2012 UM-FERI
               UM-FERI, Smetanova ulica 17, SI-2000 Maribor, Slovenia

               Bdd Scout is free software; you can redistribute it and/or modify
               it under the terms of the GNU General Public License as
               published by the Free Software Foundation; either version 2
               of the License, or (at your option) any later version.

               Bdd Scout is distributed in the hope that it will be useful,
               but WITHOUT ANY WARRANTY; without even the implied warranty of
               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
               GNU General Public License for more details.

               You should have received a copy of the GNU General Public
               License along with this program; if not, write to the Free
               Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
               Boston, MA 02110-1301 USA.]
  ************************************************************************/

#ifndef _BDDSCOUT
#define _BDDSCOUT

#include <biddy.h>
#include <tcl.h>

#if TCL_MAJOR_VERSION < 8
#  error "We need Tcl 8.1 or greater to build this"
#elif defined(USE_TCL_STUBS) && TCL_MAJOR_VERSION == 8 && \
   (TCL_MINOR_VERSION == 0 || \
   (TCL_MINOR_VERSION == 1 && TCL_RELEASE_LEVEL != TCL_FINAL_RELEASE))
#   error "Stubs interface doesn't work in 8.0 and alpha/beta 8.1"
#endif

/* ON WIN32 THERE HAS TO BE DEFINED WIN32 */
/* ON UNIX THERE HAS TO BE DEFINED UNIX */
/* ON MACOSX THERE HAS TO BE DEFINED MACOSX */

#ifdef UNIX
#  ifndef EXTERN
#    define EXTERN extern
#  endif
#endif

#ifdef WIN32
#ifndef TCL
#    ifdef BUILD_BDDSCOUT
#      define EXTERN __declspec (dllexport)
#    else
#      ifdef USE_BDDSCOUT
#        define EXTERN __declspec (dllimport)
#      else
#        define EXTERN extern
#      endif
#    endif
#else
#    ifdef BUILD_BDDSCOUT
#      undef TCL_STORAGE_CLASS
#      define TCL_STORAGE_CLASS DLLEXPORT
#    else
#      ifdef USE_BDDSCOUT
#        undef TCL_STORAGE_CLASS
#        define TCL_STORAGE_CLASS DLLIMPORT
#      else
#        undef EXTERN
#        define EXTERN extern
#      endif
#    endif
#endif
#endif

#ifdef MACOSX
#  ifndef EXTERN
#    define EXTERN extern
#  endif
#endif

/*-----------------------------------------------------------------------*/
/* Constant definitions                                                  */
/*-----------------------------------------------------------------------*/

/*-----------------------------------------------------------------------*/
/* Macro definitions                                                     */
/*-----------------------------------------------------------------------*/

/*-----------------------------------------------------------------------*/
/* Type declarations                                                     */
/*-----------------------------------------------------------------------*/

/*-----------------------------------------------------------------------*/
/* Structure declarations                                                */
/*-----------------------------------------------------------------------*/

/*-----------------------------------------------------------------------*/
/* Variable declarations                                                 */
/*-----------------------------------------------------------------------*/

/**AutomaticStart*********************************************************/

/*-----------------------------------------------------------------------*/
/* Function prototypes                                                   */
/*-----------------------------------------------------------------------*/

/**AutomaticEnd***********************************************************/

extern CONST char *Bddscout_InitStubs (Tcl_Interp *interp, char *version, int exact);

#include "bddscoutDecls.h"

#endif  /* _BDDSCOUT */
