@echo off

REM  Author: Robert Meolic (meolic@uni-mb.si)
REM  $Revision: 51 $
REM  $Date: 2013-04-03 17:57:12 +0200 (sre, 03 apr 2013) $
REM
REM  This file is part of Biddy.
REM  Copyright (C) 2006, 2013 UM-FERI
REM  UM-FERI, Smetanova ulica 17, SI-2000 Maribor, Slovenia
REM
REM  Biddy is free software; you can redistribute it and/or modify
REM  it under the terms of the GNU General Public License as
REM  published by the Free Software Foundation; either version 2
REM  of the License, or (at your option) any later version.
REM
REM  Biddy is distributed in the hope that it will be useful,
REM  but WITHOUT ANY WARRANTY; without even the implied warranty of
REM  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
REM  GNU General Public License for more details.
REM
REM  You should have received a copy of the GNU General Public
REM  License along with this program; if not, write to the Free
REM  Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
REM  Boston, MA 02110-1301 USA.]

SET NAME=biddy
FOR /F "USEBACKQ" %%T IN (`TYPE VERSION`) DO SET VVERSION=%%T
SET VERSION=%VVERSION:.=-%
SET MYZIP="C:\Program Files\7-Zip\7z.exe" a
SET SFX="C:\Program Files\7-Zip\7zsd.sfx"

rm -f %NAME%-bin-%VERSION%-Win.7z
rm -f %NAME%-bin-%VERSION%-Win.exe
rm -f %NAME%-%VERSION%-Win.7z
rm -f %NAME%-%VERSION%-Win.exe

rm -fr .\%NAME%-%VERSION%

make "BINDIR = ../biddy/%NAME%-%VERSION%"
make clean "BINDIR = ../biddy/%NAME%-%VERSION%"

cp COPYING ./%NAME%-%VERSION%/
cp CHANGES ./%NAME%-%VERSION%/CHANGES
cp biddy.h ./%NAME%-%VERSION%/

%MYZIP% %NAME%-bin-%VERSION%-Win.7z .\%NAME%-%VERSION%\* -x!.\%NAME%-%VERSION%\*.h -x!.\%NAME%-%VERSION%\*.a
%MYZIP% %NAME%-%VERSION%-Win.7z .\%NAME%-%VERSION%\*

echo "Creating %NAME%-bin-%VERSION%-Win.exe ..."

echo ;!@Install@!UTF-8! > cfg.cfg
echo Title="Biddy (binary version)" >> cfg.cfg
echo BeginPrompt="Biddy\nVersion %VVERSION%\n\nBiddy is a multi-platform academic Binary Decision Diagrams package.\n\nThis is free software. See GNU GPL (version 2).\n\nNOTE: No registry entry will be changed and no file will be\n            created outside the target folder. You can uninstall\n            this software by simply deleting the target folder.\n\nRobert Meolic (meolic@uni-mb.si)" >> cfg.cfg
echo ExtractPathText="Please, enter the target folder:" >> cfg.cfg
echo ExtractDialogText="Please, wait..." >> cfg.cfg
echo ExtractTitle="Extracting..." >> cfg.cfg
echo GUIFlags="8+32+64+256+4096" >> cfg.cfg
echo GUIMode="1" >> cfg.cfg
echo InstallPath="%ProgramFiles%\\biddy" >> cfg.cfg
echo ;!@InstallEnd@! >> cfg.cfg

copy /b /y %SFX% + cfg.cfg + "%NAME%-bin-%VERSION%-Win.7z" "%NAME%-bin-%VERSION%-Win.exe"

echo "Creating %NAME%-%VERSION%-Win.exe ..."

echo ;!@Install@!UTF-8! > cfg.cfg
echo Title="Biddy (development version)" >> cfg.cfg
echo BeginPrompt="Biddy\nVersion %VVERSION%\n\nBiddy is a multi-platform academic Binary Decision Diagrams package.\n\nThis is free software. See GNU GPL (version 2).\n\nNOTE: No registry entry will be changed and no file will be\n            created outside the target folder. You can uninstall\n            this software by simply deleting the target folder.\n\nRobert Meolic (meolic@uni-mb.si)" >> cfg.cfg
echo ExtractPathText="Please, enter the target folder:" >> cfg.cfg
echo ExtractDialogText="Please, wait..." >> cfg.cfg
echo ExtractTitle="Extracting..." >> cfg.cfg
echo GUIFlags="8+32+64+256+4096" >> cfg.cfg
echo GUIMode="1" >> cfg.cfg
echo InstallPath="%ProgramFiles%\\biddy" >> cfg.cfg
echo ;!@InstallEnd@! >> cfg.cfg

copy /b /y %SFX% + cfg.cfg + "%NAME%-%VERSION%-Win.7z" "%NAME%-%VERSION%-Win.exe"

rm -f cfg.cfg
rm -fr %NAME%-%VERSION%
rm -f %NAME%-bin-%VERSION%-Win.7z
rm -f %NAME%-%VERSION%-Win.7z

echo *******************
echo PACKAGES COMPLETED!
echo *******************
