#!/usr/bin/perl
#
# Decode raw zlib compressed data stream (as generated by agents in local mode
# and used in HTTP POST payload) from STDIN and dump result to STDOUT.
#
# $Id: decode-ocsfiles.pl 392 2013-01-02 15:11:31Z hschletz $
#
# Copyright (C) 2011-2013 Holger Schletz <holger.schletz@web.de>
#
# This program is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the Free
# Software Foundation; either version 2 of the License, or (at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
# FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
# more details.
#
# You should have received a copy of the GNU General Public License along with
# this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#
# @package Tools

use strict;
use warnings;

use Compress::Zlib;

binmode(STDIN);

my $zlib;
my $input;
my $output;
my $status;

$zlib = inflateInit();
if (!$zlib) {
    die("Zlib initialization failed!\n");
}

while (read(STDIN, $input, 4096))
{
    ($output, $status) = $zlib->inflate(\$input);
    if ($status == Z_OK or $status == Z_STREAM_END) {
        print $output;
    }
    if ($status != Z_OK) {
        last;
    }
}

if ($status != Z_OK and $status != Z_STREAM_END) {
    die("Error while decompressing input. Is it really a raw zlib compressed data stream?\n");
}
