#ifndef MYONLINETIMER_H
#define MYONLINETIMER_H

#include <QtCore>
#include <QLabel>
#include <QDoubleSpinBox>

#include <opencv2/opencv.hpp>
#include <ctime>

#include "processa.h"


class MyOnlineTimer : public QObject
{
    Q_OBJECT
public:
    MyOnlineTimer();
    QTimer *timer;
    cv::VideoCapture *CAP;
    int ID;
    QLabel *LABEL_FPS;
    QLabel *LABEL_MAX;
    QLabel *LABEL_MAX_COLORMAP;
    double old_time;
    double current_time;
    Processa Work;
    int Type;
    double minval;
    double maxval;
    bool *ENABLE_SCALE;
    bool *ENABLE_BLUR;

    QSpinBox *SPINBOX_BLUR_SIZE;

    QDoubleSpinBox *ROI_LIN0;
    QDoubleSpinBox *ROI_COL0;
    QDoubleSpinBox *ROI_HEIGHT;
    QDoubleSpinBox *ROI_WIDTH;

    void start_online(  QDoubleSpinBox *lin0,
                        QDoubleSpinBox *col0,
                        QDoubleSpinBox *height,
                        QDoubleSpinBox *width,
                        QSpinBox *spinBox_blur_size,
                        QLabel *label_max_colormap,
                        QLabel *label_fps,     // Label onde mostrarei os FPS
                        QLabel *label_max,     // Label onde mostrarei maximo valor
                        cv::VideoCapture *cap, // Controlador de video
                        int camid,             // O ID da camera que vou abrir
                        int ms,                // O tempo de amostragem =1/Fs
                        int type,              // Tipo de processamento
                        int nbloks,            // Numero de blocos de buffer
                        bool *blur_enable,// Habilita um filtro
                        bool *scale_enable,    // Habilita escalar el colormap
                        bool *reset);
    void stop_online(void);

public slots:
    void MySlot();
};

#endif // MYONLINETIMER_H
