/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.compiler;

import com.izforge.izpack.CustomData;
import com.izforge.izpack.ExecutableFile;
import com.izforge.izpack.GUIPrefs;
import com.izforge.izpack.Info;
import com.izforge.izpack.Panel;
import com.izforge.izpack.ParsableFile;
import com.izforge.izpack.UpdateCheck;
import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.adaptator.impl.XMLParser;
import com.izforge.izpack.adaptator.impl.XMLWriter;
import com.izforge.izpack.compiler.Compiler;
import com.izforge.izpack.compiler.CompilerException;
import com.izforge.izpack.compiler.DynamicVariable;
import com.izforge.izpack.compiler.IPackager;
import com.izforge.izpack.compiler.PackInfo;
import com.izforge.izpack.compiler.PackagerHelper;
import com.izforge.izpack.compiler.PackagerListener;
import com.izforge.izpack.compiler.Property;
import com.izforge.izpack.event.CompilerListener;
import com.izforge.izpack.installer.InstallerRequirement;
import com.izforge.izpack.installer.PanelAction;
import com.izforge.izpack.installer.PanelActionConfiguration;
import com.izforge.izpack.rules.Condition;
import com.izforge.izpack.rules.RulesEngine;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.OsConstraint;
import com.izforge.izpack.util.VariableSubstitutor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.tools.ant.DirectoryScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompilerConfig
extends Thread {
    public static final String VERSION = "1.0";
    public static final String STANDARD = "standard";
    public static final String WEB = "web";
    private static boolean YES = true;
    private static boolean NO = false;
    private static final String IZ_TEST_FILE = "ShellLink.dll";
    private static final String IZ_TEST_SUBDIR = "bin" + File.separator + "native" + File.separator + "izpack";
    private String filename;
    private String installText;
    protected String basedir;
    private Compiler compiler;
    protected List<CompilerListener> compilerListeners = new ArrayList<CompilerListener>();
    private HashMap<String, List<URL>> packsLangUrlMap = new HashMap();

    public static void setIzpackHome(String string) {
        Compiler.setIzpackHome(string);
    }

    public CompilerConfig(String string, String string2, String string3, String string4) throws CompilerException {
        this(string, string2, string3, string4, null);
    }

    public CompilerConfig(String string, String string2, String string3, String string4, PackagerListener packagerListener) throws CompilerException {
        this(string, string2, string3, string4, "default", packagerListener);
    }

    public CompilerConfig(String string, String string2, String string3, String string4, String string5, PackagerListener packagerListener) throws CompilerException {
        this(string, string2, string3, string4, string5, packagerListener, null);
    }

    public CompilerConfig(String string, String string2, String string3, PackagerListener packagerListener, String string4) throws CompilerException {
        this(null, string, string2, string3, "default", packagerListener, string4);
    }

    public CompilerConfig(String string, String string2, String string3, String string4, String string5, PackagerListener packagerListener, String string6) throws CompilerException {
        this(string, string2, string3, string4, string5, -1, packagerListener, string6);
    }

    public CompilerConfig(String string, String string2, String string3, String string4, String string5, int n, PackagerListener packagerListener, String string6) throws CompilerException {
        this.filename = string;
        this.installText = string6;
        this.basedir = string2;
        this.compiler = new Compiler(string2, string3, string4, string5, n);
        this.compiler.setPackagerListener(packagerListener);
    }

    public boolean addProperty(String string, String string2) {
        return this.compiler.addProperty(string, string2);
    }

    public Compiler getCompiler() {
        return this.compiler;
    }

    public PackagerListener getPackagerListener() {
        return this.compiler.getPackagerListener();
    }

    public void compile() {
        this.start();
    }

    @Override
    public void run() {
        try {
            this.executeCompiler();
        }
        catch (CompilerException compilerException) {
            System.out.println(compilerException.getMessage() + "\n");
        }
        catch (Exception exception) {
            if (Debug.stackTracing()) {
                exception.printStackTrace();
            }
            System.out.println("ERROR: " + exception.getMessage());
        }
    }

    public void executeCompiler() throws Exception {
        File file = new File(this.basedir).getAbsoluteFile();
        if (!file.canRead() || !file.isDirectory()) {
            throw new CompilerException("Invalid base directory: " + file);
        }
        this.compiler.setProperty("basedir", file.toString());
        IXMLElement iXMLElement = this.getXMLTree();
        this.loadPackagingInformation(iXMLElement);
        this.addCustomListeners(iXMLElement);
        this.substituteProperties(iXMLElement);
        this.addVariables(iXMLElement);
        this.addDynamicVariables(iXMLElement);
        this.addConditions(iXMLElement);
        this.addInfo(iXMLElement);
        this.addGUIPrefs(iXMLElement);
        this.addLangpacks(iXMLElement);
        this.addResources(iXMLElement);
        this.addNativeLibraries(iXMLElement);
        this.addJars(iXMLElement);
        this.addPanels(iXMLElement);
        this.addPacks(iXMLElement);
        this.addInstallerRequirement(iXMLElement);
        this.mergePacksLangFiles();
        this.compiler.createInstaller();
    }

    private void addInstallerRequirement(IXMLElement iXMLElement) throws CompilerException {
        this.notifyCompilerListener("addInstallerRequirement", 1, iXMLElement);
        IXMLElement iXMLElement2 = iXMLElement.getFirstChildNamed("installerrequirements");
        ArrayList<InstallerRequirement> arrayList = new ArrayList<InstallerRequirement>();
        if (iXMLElement2 != null) {
            Vector<IXMLElement> vector = iXMLElement2.getChildrenNamed("installerrequirement");
            for (IXMLElement iXMLElement3 : vector) {
                InstallerRequirement installerRequirement = new InstallerRequirement();
                String string = iXMLElement3.getAttribute("condition");
                installerRequirement.setCondition(string);
                String string2 = iXMLElement3.getAttribute("message");
                installerRequirement.setMessage(string2);
                arrayList.add(installerRequirement);
            }
        }
        this.compiler.addInstallerRequirement(arrayList);
        this.notifyCompilerListener("addInstallerRequirement", 2, iXMLElement);
    }

    private void loadPackagingInformation(IXMLElement iXMLElement) throws CompilerException {
        IXMLElement iXMLElement2;
        this.notifyCompilerListener("loadPackager", 1, iXMLElement);
        IXMLElement iXMLElement3 = iXMLElement.getFirstChildNamed("packaging");
        String string = "com.izforge.izpack.compiler.Packager";
        String string2 = "com.izforge.izpack.installer.Unpacker";
        IXMLElement iXMLElement4 = null;
        if (iXMLElement3 != null) {
            iXMLElement4 = iXMLElement3.getFirstChildNamed("packager");
            if (iXMLElement4 != null) {
                string = this.requireAttribute(iXMLElement4, "class");
            }
            if ((iXMLElement2 = iXMLElement3.getFirstChildNamed("unpacker")) != null) {
                string2 = this.requireAttribute(iXMLElement2, "class");
            }
        }
        this.compiler.initPackager(string);
        if (iXMLElement4 != null && (iXMLElement2 = iXMLElement4.getFirstChildNamed("options")) != null) {
            this.compiler.getPackager().addConfigurationInformation(iXMLElement2);
        }
        this.compiler.addProperty("UNPACKER_CLASS", string2);
        this.notifyCompilerListener("loadPackager", 2, iXMLElement);
    }

    public boolean wasSuccessful() {
        return this.compiler.wasSuccessful();
    }

    protected void addGUIPrefs(IXMLElement iXMLElement) throws CompilerException {
        this.notifyCompilerListener("addGUIPrefs", 1, iXMLElement);
        IXMLElement iXMLElement2 = iXMLElement.getFirstChildNamed("guiprefs");
        GUIPrefs gUIPrefs = new GUIPrefs();
        if (iXMLElement2 != null) {
            Object object;
            Object object2;
            Object object3;
            gUIPrefs.resizable = this.requireYesNoAttribute(iXMLElement2, "resizable");
            gUIPrefs.width = this.requireIntAttribute(iXMLElement2, "width");
            gUIPrefs.height = this.requireIntAttribute(iXMLElement2, "height");
            for (IXMLElement serializable2 : iXMLElement2.getChildrenNamed("laf")) {
                object3 = this.requireAttribute(serializable2, "name");
                this.requireChildNamed(serializable2, "os");
                for (IXMLElement iXMLElement3 : serializable2.getChildrenNamed("os")) {
                    object2 = this.requireAttribute(iXMLElement3, "family");
                    gUIPrefs.lookAndFeelMapping.put((String)object2, (String)object3);
                }
                Iterator<IXMLElement> iterator = serializable2.getChildrenNamed("param").iterator();
                object2 = new TreeMap();
                while (iterator.hasNext()) {
                    IXMLElement iXMLElement4 = iterator.next();
                    String string = this.requireAttribute(iXMLElement4, "name");
                    String string2 = this.requireAttribute(iXMLElement4, "value");
                    object2.put(string, string2);
                }
                gUIPrefs.lookAndFeelParams.put((String)object3, (Map<String, String>)object2);
            }
            for (IXMLElement iXMLElement5 : iXMLElement2.getChildrenNamed("modifier")) {
                object3 = this.requireAttribute(iXMLElement5, "key");
                object = this.requireAttribute(iXMLElement5, "value");
                gUIPrefs.modifier.put((String)object3, (String)object);
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("liquid", "liquidlnf.jar");
            hashMap.put("kunststoff", "kunststoff.jar");
            hashMap.put("metouia", "metouia.jar");
            hashMap.put("looks", "looks.jar");
            hashMap.put("substance", "substance.jar");
            hashMap.put("nimbus", "nimbus.jar");
            object3 = gUIPrefs.lookAndFeelMapping.keySet().iterator();
            while (object3.hasNext()) {
                object = gUIPrefs.lookAndFeelMapping.get(object3.next());
                String string = (String)hashMap.get(object);
                if (string == null) {
                    this.parseError(iXMLElement2, "Unrecognized Look and Feel: " + (String)object);
                }
                object2 = this.findIzPackResource("lib/" + string, "Look and Feel Jar file", iXMLElement2);
                this.compiler.addJarContent((URL)object2);
            }
        }
        this.compiler.setGUIPrefs(gUIPrefs);
        this.notifyCompilerListener("addGUIPrefs", 2, iXMLElement);
    }

    protected void addJars(IXMLElement iXMLElement) throws Exception {
        this.notifyCompilerListener("addJars", 1, iXMLElement);
        for (IXMLElement iXMLElement2 : iXMLElement.getChildrenNamed("jar")) {
            String string = this.requireAttribute(iXMLElement2, "src");
            URL uRL = this.findProjectResource(string, "Jar file", iXMLElement2);
            this.compiler.addJarContent(uRL);
            String string2 = iXMLElement2.getAttribute("stage");
            if (string2 == null || !"both".equalsIgnoreCase(string2) && !"uninstall".equalsIgnoreCase(string2)) continue;
            CustomData customData = new CustomData(null, this.getContainedFilePaths(uRL), null, 3);
            this.compiler.addCustomJar(customData, uRL);
        }
        this.notifyCompilerListener("addJars", 2, iXMLElement);
    }

    protected void addNativeLibraries(IXMLElement iXMLElement) throws Exception {
        Object object;
        Object object2;
        IXMLElement iXMLElement22;
        boolean bl = false;
        this.notifyCompilerListener("addNativeLibraries", 1, iXMLElement);
        for (IXMLElement iXMLElement22 : iXMLElement.getChildrenNamed("native")) {
            object2 = this.requireAttribute(iXMLElement22, "type");
            object = this.requireAttribute(iXMLElement22, "name");
            String string = iXMLElement22.getAttribute("src");
            if (string == null) {
                string = "bin/native/" + (String)object2 + "/" + (String)object;
            }
            URL uRL = this.findIzPackResource(string, "Native Library", iXMLElement22);
            this.compiler.addNativeLibrary((String)object, uRL);
            String string2 = iXMLElement22.getAttribute("stage");
            List<OsConstraint> list = OsConstraint.getOsList(iXMLElement22);
            if (string2 == null || !"both".equalsIgnoreCase(string2) && !"uninstall".equalsIgnoreCase(string2)) continue;
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add((String)object);
            CustomData customData = new CustomData(null, arrayList, list, 2);
            this.compiler.addNativeUninstallerLibrary(customData);
            bl = true;
        }
        if (bl && this.validateYesNoAttribute((IXMLElement)(object2 = (iXMLElement22 = this.requireChildNamed(iXMLElement, "info")).getFirstChildNamed("uninstaller")), "write", YES)) {
            object = this.findIzPackResource("lib/uninstaller-ext.jar", "Uninstaller extensions", iXMLElement22);
            this.compiler.addResource("IzPack.uninstaller-ext", (URL)object);
        }
        this.notifyCompilerListener("addNativeLibraries", 2, iXMLElement);
    }

    protected void addPacks(IXMLElement iXMLElement) throws CompilerException {
        this.notifyCompilerListener("addPacks", 1, iXMLElement);
        this.addPacksSingle(iXMLElement);
        this.compiler.checkDependencies();
        this.compiler.checkExcludes();
        this.notifyCompilerListener("addPacks", 2, iXMLElement);
    }

    private void addPacksSingle(IXMLElement iXMLElement) throws CompilerException {
        Object object;
        String[] stringArray;
        Object object2;
        Object object3;
        boolean bl;
        String string;
        this.notifyCompilerListener("addPacksSingle", 1, iXMLElement);
        IXMLElement iXMLElement2 = this.requireChildNamed(iXMLElement, "packs");
        Vector<IXMLElement> vector = iXMLElement2.getChildrenNamed("pack");
        Vector<IXMLElement> vector2 = iXMLElement2.getChildrenNamed("refpack");
        Vector<IXMLElement> vector3 = iXMLElement2.getChildrenNamed("refpackset");
        if (vector.isEmpty() && vector2.isEmpty() && vector3.isEmpty()) {
            this.parseError(iXMLElement2, "<packs> requires a <pack>, <refpack> or <refpackset>");
        }
        File file = new File(this.basedir);
        for (IXMLElement object5 : vector) {
            Object object4;
            Object object6;
            Object object7;
            List<OsConstraint> list;
            Object object8;
            Object object9;
            String string2 = this.requireAttribute(object5, "name");
            String string3 = object5.getAttribute("id");
            string = object5.getAttribute("packImgId");
            bl = "true".equalsIgnoreCase(object5.getAttribute("loose", "false"));
            object3 = this.requireChildNamed(object5, "description").getContent();
            boolean bl2 = this.requireYesNoAttribute(object5, "required");
            object2 = object5.getAttribute("group");
            stringArray = object5.getAttribute("installGroups");
            String string4 = object5.getAttribute("excludeGroup");
            boolean bl3 = "yes".equalsIgnoreCase(object5.getAttribute("uninstall", "yes"));
            object = object5.getAttribute("parent");
            boolean bl4 = "true".equalsIgnoreCase(object5.getAttribute("hidden", "false"));
            String string5 = object5.getAttribute("condition");
            if (bl2 && string4 != null) {
                this.parseError(object5, "Pack, which has excludeGroup can not be required.", new Exception("Pack, which has excludeGroup can not be required."));
            }
            PackInfo packInfo = new PackInfo(string2, string3, (String)object3, bl2, bl, string4, bl3);
            packInfo.setOsConstraints(OsConstraint.getOsList(object5));
            packInfo.setParent((String)object);
            packInfo.setCondition(string5);
            packInfo.setHidden(bl4);
            VariableSubstitutor variableSubstitutor = new VariableSubstitutor(this.compiler.getVariables());
            if (string4 == null) {
                packInfo.setPreselected(this.validateYesNoAttribute(object5, "preselected", YES));
            } else {
                packInfo.setPreselected(this.validateYesNoAttribute(object5, "preselected", NO));
            }
            if (object2 != null) {
                packInfo.setGroup((String)object2);
            }
            if (stringArray != null) {
                Iterator<IXMLElement> iterator = new StringTokenizer((String)stringArray, ",");
                while (((StringTokenizer)((Object)iterator)).hasMoreTokens()) {
                    String string6 = ((StringTokenizer)((Object)iterator)).nextToken();
                    packInfo.addInstallGroup(string6);
                }
            }
            if (string != null) {
                packInfo.setPackImgId(string);
            }
            for (IXMLElement iXMLElement3 : object5.getChildrenNamed("parsable")) {
                object9 = this.requireAttribute(iXMLElement3, "targetfile");
                object8 = iXMLElement3.getAttribute("type", "plain");
                list = iXMLElement3.getAttribute("encoding", null);
                object7 = OsConstraint.getOsList(iXMLElement3);
                String string7 = iXMLElement3.getAttribute("condition");
                ParsableFile parsableFile = new ParsableFile((String)object9, (String)object8, (String)((Object)list), (List<OsConstraint>)object7);
                parsableFile.setCondition(string7);
                packInfo.addParsable(parsableFile);
            }
            for (IXMLElement iXMLElement4 : object5.getChildrenNamed("executable")) {
                object9 = new ExecutableFile();
                list = iXMLElement4.getAttribute("condition");
                ((ExecutableFile)object9).setCondition((String)((Object)list));
                ((ExecutableFile)object9).path = this.requireAttribute(iXMLElement4, "targetfile");
                object8 = iXMLElement4.getAttribute("stage", "never");
                if ("postinstall".equalsIgnoreCase((String)object8)) {
                    ((ExecutableFile)object9).executionStage = 0;
                } else if ("uninstall".equalsIgnoreCase((String)object8)) {
                    ((ExecutableFile)object9).executionStage = 2;
                }
                object8 = iXMLElement4.getAttribute("type", "bin");
                if ("jar".equalsIgnoreCase((String)object8)) {
                    ((ExecutableFile)object9).type = 1;
                    ((ExecutableFile)object9).mainClass = iXMLElement4.getAttribute("class");
                }
                if ("abort".equalsIgnoreCase((String)(object8 = iXMLElement4.getAttribute("failure", "ask")))) {
                    ((ExecutableFile)object9).onFailure = 0;
                } else if ("warn".equalsIgnoreCase((String)object8)) {
                    ((ExecutableFile)object9).onFailure = 1;
                } else if ("ignore".equalsIgnoreCase((String)object8)) {
                    ((ExecutableFile)object9).onFailure = 3;
                }
                object8 = iXMLElement4.getAttribute("keep");
                ((ExecutableFile)object9).keepFile = "true".equalsIgnoreCase((String)object8);
                object7 = iXMLElement4.getFirstChildNamed("args");
                if (null != object7) {
                    for (IXMLElement iXMLElement5 : object7.getChildrenNamed("arg")) {
                        ((ExecutableFile)object9).argList.add(this.requireAttribute(iXMLElement5, "value"));
                    }
                }
                ((ExecutableFile)object9).osList = OsConstraint.getOsList(iXMLElement4);
                packInfo.addExecutable((ExecutableFile)object9);
            }
            for (IXMLElement iXMLElement6 : object5.getChildrenNamed("file")) {
                object9 = this.requireAttribute(iXMLElement6, "src");
                object8 = this.requireAttribute(iXMLElement6, "targetdir");
                list = OsConstraint.getOsList(iXMLElement6);
                int n = this.getOverrideValue(iXMLElement6);
                Map map = this.getAdditionals(iXMLElement6);
                boolean bl5 = "true".equalsIgnoreCase(iXMLElement6.getAttribute("unpack"));
                object6 = iXMLElement6.getAttribute("condition");
                object4 = new File((String)object9);
                if (!((File)object4).isAbsolute()) {
                    object4 = new File(this.basedir, (String)object9);
                }
                if (!((File)object4).exists()) {
                    object4 = new File(variableSubstitutor.substitute(((File)object4).getAbsolutePath(), null));
                }
                try {
                    if (bl5) {
                        this.addArchiveContent(file, (File)object4, (String)object8, list, n, packInfo, map, (String)object6);
                        continue;
                    }
                    this.addRecursively(file, (File)object4, (String)object8, list, n, packInfo, map, (String)object6);
                }
                catch (Exception exception) {
                    this.parseError(iXMLElement6, exception.getMessage(), exception);
                }
            }
            for (IXMLElement iXMLElement7 : object5.getChildrenNamed("singlefile")) {
                object9 = this.requireAttribute(iXMLElement7, "src");
                object8 = this.requireAttribute(iXMLElement7, "target");
                list = OsConstraint.getOsList(iXMLElement7);
                int n = this.getOverrideValue(iXMLElement7);
                Map map = this.getAdditionals(iXMLElement7);
                String string8 = iXMLElement7.getAttribute("condition");
                object6 = new File((String)object9);
                if (!((File)object6).isAbsolute()) {
                    object6 = new File(this.basedir, (String)object9);
                }
                if (!((File)object6).exists()) {
                    object6 = new File(variableSubstitutor.substitute(((File)object6).getAbsolutePath(), null));
                }
                try {
                    packInfo.addFile(file, (File)object6, (String)object8, list, n, map, string8);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.parseError(iXMLElement7, fileNotFoundException.getMessage(), fileNotFoundException);
                }
            }
            for (IXMLElement iXMLElement8 : object5.getChildrenNamed("fileset")) {
                String string9;
                int n;
                String[] stringArray2;
                String[] stringArray3;
                String[][] stringArrayArray;
                String[] stringArray4;
                object9 = this.requireAttribute(iXMLElement8, "dir");
                object8 = new File((String)object9);
                if (!((File)object8).isAbsolute()) {
                    object8 = new File(this.basedir, (String)object9);
                }
                if (!((File)object8).isDirectory()) {
                    this.parseError(iXMLElement8, "Invalid directory 'dir': " + (String)object9);
                }
                boolean bl6 = this.validateYesNoAttribute(iXMLElement8, "casesensitive", YES);
                boolean bl7 = this.validateYesNoAttribute(iXMLElement8, "defaultexcludes", YES);
                String string10 = this.requireAttribute(iXMLElement8, "targetdir");
                List<OsConstraint> list2 = OsConstraint.getOsList(iXMLElement8);
                int n2 = this.getOverrideValue(iXMLElement8);
                object4 = this.getAdditionals(iXMLElement8);
                String string11 = iXMLElement8.getAttribute("condition");
                Vector<IXMLElement> vector4 = null;
                String[] stringArray5 = null;
                vector4 = iXMLElement8.getChildrenNamed("include");
                if (!vector4.isEmpty()) {
                    stringArray5 = new String[vector4.size()];
                    for (int i = 0; i < vector4.size(); ++i) {
                        stringArray4 = vector4.get(i);
                        stringArray5[i] = this.requireAttribute((IXMLElement)stringArray4, "name");
                    }
                }
                String[] stringArray6 = null;
                vector4 = iXMLElement8.getChildrenNamed("exclude");
                if (!vector4.isEmpty()) {
                    stringArray6 = new String[vector4.size()];
                    for (int i = 0; i < vector4.size(); ++i) {
                        stringArrayArray = vector4.get(i);
                        stringArray6[i] = this.requireAttribute((IXMLElement)stringArrayArray, "name");
                    }
                }
                stringArray4 = new String[]{"includes", "excludes"};
                stringArrayArray = new String[][]{stringArray5, stringArray6};
                for (int i = 0; i < stringArray4.length; ++i) {
                    stringArray3 = iXMLElement8.getAttribute(stringArray4[i]);
                    if (stringArray3 == null || stringArray3.length() <= 0) continue;
                    stringArray2 = new StringTokenizer((String)stringArray3, ", ", false);
                    int n3 = stringArray2.countTokens();
                    String[] stringArray7 = null;
                    if (stringArrayArray[i] != null && stringArrayArray[i].length > 0) {
                        stringArray7 = new String[n3 += stringArrayArray[i].length];
                        for (n = 0; n < stringArrayArray[i].length; ++n) {
                            stringArray7[n] = stringArrayArray[i][n];
                        }
                    }
                    if (stringArray7 == null) {
                        stringArray7 = new String[n3];
                    }
                    while (n < n3) {
                        stringArray7[n] = stringArray2.nextToken();
                        ++n;
                    }
                    stringArrayArray[i] = stringArray7;
                }
                stringArray5 = stringArrayArray[0];
                stringArray6 = stringArrayArray[1];
                DirectoryScanner directoryScanner = new DirectoryScanner();
                directoryScanner.setIncludes(stringArray5);
                directoryScanner.setExcludes(stringArray6);
                if (bl7) {
                    directoryScanner.addDefaultExcludes();
                }
                directoryScanner.setBasedir((File)object8);
                directoryScanner.setCaseSensitive(bl6);
                directoryScanner.scan();
                stringArray3 = directoryScanner.getIncludedFiles();
                stringArray2 = directoryScanner.getIncludedDirectories();
                for (String string12 : stringArray3) {
                    try {
                        string9 = new File(string10, string12).getPath();
                        packInfo.addFile(file, new File((File)object8, string12), string9, list2, n2, (Map)object4, string11);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        this.parseError(iXMLElement8, fileNotFoundException.getMessage(), fileNotFoundException);
                    }
                }
                String[] stringArray8 = stringArray2;
                n = stringArray8.length;
                for (int i = 0; i < n; ++i) {
                    String string12;
                    string12 = stringArray8[i];
                    try {
                        string9 = new File(string10, string12).getPath();
                        packInfo.addFile(file, new File((File)object8, string12), string9, list2, n2, (Map)object4, string11);
                        continue;
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        this.parseError(iXMLElement8, fileNotFoundException.getMessage(), fileNotFoundException);
                    }
                }
            }
            for (IXMLElement iXMLElement9 : object5.getChildrenNamed("updatecheck")) {
                object9 = iXMLElement9.getAttribute("casesensitive");
                object8 = new ArrayList();
                ArrayList<String> arrayList = new ArrayList<String>();
                for (IXMLElement iXMLElement10 : iXMLElement9.getChildrenNamed("include")) {
                    ((ArrayList)object8).add(this.requireAttribute(iXMLElement10, "name"));
                }
                for (IXMLElement iXMLElement11 : iXMLElement9.getChildrenNamed("exclude")) {
                    arrayList.add(this.requireAttribute(iXMLElement11, "name"));
                }
                packInfo.addUpdateCheck(new UpdateCheck((ArrayList<String>)object8, arrayList, (String)object9));
            }
            for (IXMLElement iXMLElement12 : object5.getChildrenNamed("depends")) {
                object9 = this.requireAttribute(iXMLElement12, "packname");
                packInfo.addDependency((String)object9);
            }
            for (IXMLElement iXMLElement13 : object5.getChildrenNamed("validator")) {
                packInfo.addValidator(this.requireContent(iXMLElement13));
            }
            this.compiler.addPack(packInfo);
        }
        for (IXMLElement iXMLElement14 : vector2) {
            String string13 = this.requireAttribute(iXMLElement14, "file");
            string = iXMLElement14.getAttribute("selfcontained");
            bl = Boolean.valueOf(string);
            object3 = this.readRefPackData(string13, bl);
            Debug.log("Reading refpack from " + string13);
            this.addPacksSingle((IXMLElement)object3);
        }
        for (IXMLElement iXMLElement15 : vector3) {
            string = this.requireAttribute(iXMLElement15, "dir");
            File file2 = new File(string);
            if (!file2.isAbsolute()) {
                file2 = new File(this.basedir, string);
            }
            if (!file2.isDirectory()) {
                this.parseError(iXMLElement15, "Invalid refpackset directory 'dir': " + string);
            }
            object3 = this.requireAttribute(iXMLElement15, "includes");
            String[] stringArray9 = ((String)object3).split(", ");
            object2 = new DirectoryScanner();
            ((DirectoryScanner)object2).setIncludes(stringArray9);
            ((DirectoryScanner)object2).setBasedir(file2);
            ((DirectoryScanner)object2).setCaseSensitive(true);
            ((DirectoryScanner)object2).scan();
            stringArray = ((DirectoryScanner)object2).getIncludedFiles();
            for (int i = 0; i < stringArray.length; ++i) {
                String string14 = new File(file2, stringArray[i]).toString();
                object = this.readRefPackData(string14, false);
                this.addPacksSingle((IXMLElement)object);
            }
        }
        this.notifyCompilerListener("addPacksSingle", 2, iXMLElement);
    }

    private IXMLElement readRefPackData(String string, boolean bl) throws CompilerException {
        Object object;
        Object object2;
        File file = new File(string);
        if (!file.isAbsolute()) {
            file = new File(this.basedir, string);
        }
        if (!file.canRead()) {
            throw new CompilerException("Invalid file: " + file);
        }
        InputStream inputStream = null;
        if (bl) {
            if (!file.getAbsolutePath().endsWith(".zip")) {
                throw new CompilerException("Invalid file: " + file + ". Selfcontained files can only be of type zip.");
            }
            try {
                object2 = new ZipFile(file, 1);
                object = ((ZipFile)object2).getEntry("META-INF/izpack.xml");
                inputStream = ((ZipFile)object2).getInputStream((ZipEntry)object);
            }
            catch (IOException iOException) {
                throw new CompilerException("Error reading META-INF/izpack.xml in " + file);
            }
        }
        try {
            inputStream = new FileInputStream(file.getAbsolutePath());
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new CompilerException("FileNotFoundException exception while reading refXMLFile");
        }
        object2 = new XMLParser();
        object = object2.parse(inputStream, file.getAbsolutePath());
        if (!"installation".equalsIgnoreCase(object.getName())) {
            this.parseError((IXMLElement)object, "this is not an IzPack XML installation file");
        }
        if (!VERSION.equalsIgnoreCase(this.requireAttribute((IXMLElement)object, "version"))) {
            this.parseError((IXMLElement)object, "the file version is different from the compiler version");
        }
        this.substituteProperties((IXMLElement)object);
        this.addResources((IXMLElement)object);
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return object;
    }

    public void checkDependencies(List<PackInfo> list) throws CompilerException {
        HashMap<String, PackInfo> hashMap = new HashMap<String, PackInfo>();
        for (PackInfo packInfo : list) {
            hashMap.put(packInfo.getPack().name, packInfo);
        }
        int n = this.dfs(list, hashMap);
        if (n == -2) {
            this.parseError("Circular dependency detected");
        } else if (n == -1) {
            this.parseError("A dependency doesn't exist");
        }
    }

    private int dfs(List<PackInfo> list, Map<String, PackInfo> map) {
        HashMap<Edge, Integer> hashMap = new HashMap<Edge, Integer>();
        for (PackInfo packInfo : list) {
            if (packInfo.colour != 0 || this.dfsVisit(packInfo, map, hashMap) == 0) continue;
            return -1;
        }
        return this.checkBackEdges(hashMap);
    }

    private int checkBackEdges(Map<Edge, Integer> map) {
        Set<Edge> set = map.keySet();
        for (Edge edge : set) {
            int n = map.get(edge);
            if (n != 1) continue;
            return -2;
        }
        return 0;
    }

    private int dfsVisit(PackInfo packInfo, Map<String, PackInfo> map, Map<Edge, Integer> map2) {
        packInfo.colour = 1;
        List<String> list = packInfo.getDependencies();
        if (list != null) {
            for (String string : list) {
                int n;
                PackInfo packInfo2 = map.get(string);
                if (packInfo2 == null) {
                    System.out.println("Failed to find dependency: " + string);
                    return -1;
                }
                Edge edge = new Edge(packInfo, packInfo2);
                if (map2.get(edge) == null) {
                    map2.put(edge, packInfo2.colour);
                }
                if (packInfo2.colour != 0 || (n = this.dfsVisit(packInfo2, map, map2)) == 0) continue;
                return n;
            }
        }
        packInfo.colour = 2;
        return 0;
    }

    protected void addArchiveContent(File file, File file2, String string, List<OsConstraint> list, int n, PackInfo packInfo, Map map, String string2) throws IOException {
        ZipEntry zipEntry;
        FileInputStream fileInputStream = new FileInputStream(file2);
        ZipInputStream zipInputStream = new ZipInputStream(fileInputStream);
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            if (zipEntry.isDirectory()) continue;
            try {
                File file3 = File.createTempFile("izpack", null);
                file3.deleteOnExit();
                FileOutputStream fileOutputStream = new FileOutputStream(file3);
                PackagerHelper.copyStream(zipInputStream, fileOutputStream);
                fileOutputStream.close();
                packInfo.addFile(file, file3, string + "/" + zipEntry.getName(), list, n, map, string2);
            }
            catch (IOException iOException) {
                throw new IOException("Couldn't create temporary file for " + zipEntry.getName() + " in archive " + file2 + " (" + iOException.getMessage() + ")");
            }
        }
        fileInputStream.close();
    }

    protected void addRecursively(File file, File file2, String string, List<OsConstraint> list, int n, PackInfo packInfo, Map map, String string2) throws IOException {
        String string3 = string + "/" + file2.getName();
        if (!file2.isDirectory()) {
            packInfo.addFile(file, file2, string3, list, n, map, string2);
        } else {
            File[] fileArray = file2.listFiles();
            if (fileArray.length == 0) {
                packInfo.addFile(file, file2, string3, list, n, map, string2);
            } else {
                for (File file3 : fileArray) {
                    this.addRecursively(file, file3, string3, list, n, packInfo, map, string2);
                }
            }
        }
    }

    protected void addPanels(IXMLElement iXMLElement) throws CompilerException {
        this.notifyCompilerListener("addPanels", 1, iXMLElement);
        IXMLElement iXMLElement2 = this.requireChildNamed(iXMLElement, "panels");
        Vector<IXMLElement> vector = iXMLElement2.getChildrenNamed("panel");
        if (vector.isEmpty()) {
            this.parseError(iXMLElement2, "<panels> requires a <panel>");
        }
        Iterator<IXMLElement> iterator = vector.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Object object;
            IXMLElement iXMLElement3;
            Iterator iterator2;
            Serializable serializable;
            IXMLElement iXMLElement4 = iterator.next();
            ++n;
            Panel panel = new Panel();
            panel.osConstraints = OsConstraint.getOsList(iXMLElement4);
            String string = iXMLElement4.getAttribute("classname");
            String string2 = iXMLElement4.getAttribute("id");
            panel.setPanelid(string2);
            String string3 = iXMLElement4.getAttribute("condition");
            panel.setCondition(string3);
            String string4 = iXMLElement4.getAttribute("jar");
            if (string4 == null) {
                string4 = "bin/panels/" + string + ".jar";
            }
            URL uRL = null;
            if (!string4.equals("")) {
                uRL = this.findIzPackResource(string4, "Panel jar file", iXMLElement4, true);
            }
            String string5 = null;
            if (uRL == null) {
                string5 = string;
            } else {
                try {
                    string5 = this.getFullClassName(uRL, string);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            panel.className = string5 != null ? string5 : string;
            IXMLElement iXMLElement5 = iXMLElement4.getFirstChildNamed("configuration");
            if (iXMLElement5 != null) {
                Debug.trace("found a configuration for this panel.");
                serializable = iXMLElement5.getChildrenNamed("param");
                if (serializable != null) {
                    iterator2 = ((Vector)serializable).iterator();
                    while (iterator2.hasNext()) {
                        IXMLElement iXMLElement6 = (IXMLElement)iterator2.next();
                        iXMLElement3 = iXMLElement6.getFirstChildNamed("key");
                        object = iXMLElement6.getFirstChildNamed("value");
                        if (iXMLElement3 == null || object == null) continue;
                        panel.addConfiguration(iXMLElement3.getContent(), object.getContent());
                    }
                }
            }
            if ((serializable = iXMLElement4.getFirstChildNamed("validator")) != null && !"".equals(iterator2 = serializable.getAttribute("classname"))) {
                panel.setValidator((String)((Object)iterator2));
            }
            if ((iterator2 = iXMLElement4.getChildrenNamed("help")) != null) {
                for (int i = 0; i < ((Vector)((Object)iterator2)).size(); ++i) {
                    URL uRL2;
                    iXMLElement3 = (IXMLElement)((Vector)((Object)iterator2)).get(i);
                    object = iXMLElement3.getAttribute("iso3");
                    String string6 = string2 == null ? string + "_" + n + "_help_" + (String)object + ".html" : string2 + "_" + n + "_help_" + (String)object + ".html";
                    panel.addHelp((String)object, string6);
                    URL uRL3 = uRL2 = this.findProjectResource(iXMLElement3.getAttribute("src"), "Help", iXMLElement3);
                    this.compiler.addResource(string6, uRL3);
                }
            }
            this.addPanelActions(iXMLElement4, panel);
            this.compiler.addPanelJar(panel, uRL);
        }
        this.notifyCompilerListener("addPanels", 2, iXMLElement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addResources(IXMLElement iXMLElement) throws CompilerException {
        this.notifyCompilerListener("addResources", 1, iXMLElement);
        IXMLElement iXMLElement2 = iXMLElement.getFirstChildNamed("resources");
        if (iXMLElement2 == null) {
            return;
        }
        for (IXMLElement iXMLElement3 : iXMLElement2.getChildrenNamed("res")) {
            List<Object> list;
            URL uRL;
            String string = this.requireAttribute(iXMLElement3, "id");
            String string2 = this.requireAttribute(iXMLElement3, "src");
            boolean bl = this.validateYesNoAttribute(iXMLElement3, "parse", NO);
            boolean bl2 = this.validateYesNoAttribute(iXMLElement3, "parsexml", NO);
            String string3 = iXMLElement3.getAttribute("encoding");
            if (string3 == null) {
                string3 = "";
            }
            URL uRL2 = uRL = this.findProjectResource(string2, "Resource", iXMLElement3);
            InputStream inputStream = null;
            OutputStream outputStream = null;
            try {
                Object object;
                Object object2;
                Object object3;
                if (!"".equals(string3)) {
                    list = File.createTempFile("izenc", null);
                    ((File)((Object)list)).deleteOnExit();
                    object3 = new InputStreamReader(uRL.openStream(), string3);
                    object2 = new OutputStreamWriter((OutputStream)new FileOutputStream((File)((Object)list)), "UTF-8");
                    object = new char[1024];
                    int n = 0;
                    while ((n = ((Reader)object3).read((char[])object)) != -1) {
                        ((OutputStreamWriter)object2).write((char[])object, 0, n);
                    }
                    ((InputStreamReader)object3).close();
                    ((OutputStreamWriter)object2).close();
                    uRL = ((File)((Object)list)).toURL();
                }
                if (bl2 || !"".equals(string3) || bl && !this.compiler.getVariables().isEmpty()) {
                    list = File.createTempFile("izpp", null);
                    ((File)((Object)list)).deleteOnExit();
                    object3 = new FileOutputStream((File)((Object)list));
                    outputStream = new BufferedOutputStream((OutputStream)object3);
                    uRL2 = ((File)((Object)list)).toURL();
                }
                if (bl2) {
                    list = new XMLParser();
                    object3 = list.parse(uRL);
                    object2 = new XMLWriter();
                    if (bl && !this.compiler.getVariables().isEmpty()) {
                        object = new ByteArrayOutputStream();
                        object2.setOutput((OutputStream)object);
                        inputStream = new ByteArrayInputStream(((ByteArrayOutputStream)object).toByteArray());
                    } else {
                        object2.setOutput(outputStream);
                    }
                    object2.write((IXMLElement)object3);
                }
                if (bl) {
                    if (this.compiler.getVariables().isEmpty()) {
                        uRL2 = uRL;
                        this.parseWarn(iXMLElement3, "No variables defined. " + uRL2.getPath() + " not parsed.");
                    } else {
                        list = iXMLElement3.getAttribute("type");
                        if (null == inputStream) {
                            inputStream = new BufferedInputStream(uRL.openStream());
                        }
                        object3 = new VariableSubstitutor(this.compiler.getVariables());
                        ((VariableSubstitutor)object3).substitute(inputStream, outputStream, (String)((Object)list), "UTF-8");
                    }
                }
            }
            catch (Exception exception) {
                this.parseError(iXMLElement3, exception.getMessage(), exception);
            }
            finally {
                if (null != outputStream) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (null != inputStream) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            this.compiler.addResource(string, uRL2);
            if (!string.startsWith("packsLang.xml")) continue;
            list = null;
            if (this.packsLangUrlMap.containsKey(string)) {
                list = this.packsLangUrlMap.get(string);
            } else {
                list = new ArrayList();
                this.packsLangUrlMap.put(string, list);
            }
            list.add(uRL2);
        }
        this.notifyCompilerListener("addResources", 2, iXMLElement);
    }

    protected void addLangpacks(IXMLElement iXMLElement) throws CompilerException {
        this.notifyCompilerListener("addLangpacks", 1, iXMLElement);
        IXMLElement iXMLElement2 = this.requireChildNamed(iXMLElement, "locale");
        Vector<IXMLElement> vector = iXMLElement2.getChildrenNamed("langpack");
        if (vector.isEmpty()) {
            this.parseError(iXMLElement2, "<locale> requires a <langpack>");
        }
        for (IXMLElement iXMLElement3 : vector) {
            String string = this.requireAttribute(iXMLElement3, "iso3");
            String string2 = "bin/langpacks/installer/" + string + ".xml";
            URL uRL = this.findIzPackResource(string2, "ISO3 file", iXMLElement3);
            string2 = "bin/langpacks/flags/" + string + ".gif";
            URL uRL2 = this.findIzPackResource(string2, "ISO3 flag image", iXMLElement3);
            this.compiler.addLangPack(string, uRL, uRL2);
        }
        this.notifyCompilerListener("addLangpacks", 2, iXMLElement);
    }

    protected void addInfo(IXMLElement iXMLElement) throws Exception {
        String string;
        Object object;
        Serializable serializable;
        IXMLElement iXMLElement2;
        IXMLElement iXMLElement3;
        String string2;
        Object object2;
        IXMLElement iXMLElement4;
        Object object3;
        Serializable serializable2;
        IXMLElement iXMLElement5;
        this.notifyCompilerListener("addInfo", 1, iXMLElement);
        IXMLElement iXMLElement6 = this.requireChildNamed(iXMLElement, "info");
        Info info = new Info();
        info.setAppName(this.requireContent(this.requireChildNamed(iXMLElement6, "appname")));
        info.setAppVersion(this.requireContent(this.requireChildNamed(iXMLElement6, "appversion")));
        IXMLElement iXMLElement7 = iXMLElement6.getFirstChildNamed("appsubpath");
        if (iXMLElement7 != null) {
            info.setInstallationSubPath(this.requireContent(iXMLElement7));
        }
        if ((iXMLElement5 = iXMLElement6.getFirstChildNamed("url")) != null) {
            serializable2 = this.requireURLContent(iXMLElement5);
            info.setAppURL(((URL)serializable2).toString());
        }
        if ((serializable2 = iXMLElement6.getFirstChildNamed("authors")) != null) {
            object3 = serializable2.getChildrenNamed("author").iterator();
            while (object3.hasNext()) {
                iXMLElement4 = (IXMLElement)object3.next();
                object2 = this.requireAttribute(iXMLElement4, "name");
                string2 = this.requireAttribute(iXMLElement4, "email");
                info.addAuthor(new Info.Author((String)object2, string2));
            }
        }
        if ((object3 = iXMLElement6.getFirstChildNamed("javaversion")) != null) {
            info.setJavaVersion(this.requireContent((IXMLElement)object3));
        }
        if ((iXMLElement4 = iXMLElement6.getFirstChildNamed("requiresjdk")) != null) {
            info.setJdkRequired("yes".equals(iXMLElement4.getContent()));
        }
        if ((object2 = iXMLElement6.getFirstChildNamed("webdir")) != null) {
            info.setWebDirURL(this.requireURLContent((IXMLElement)object2).toString());
        }
        if ((string2 = this.compiler.getKind()) != null) {
            if (string2.equalsIgnoreCase(WEB) && object2 == null) {
                this.parseError(iXMLElement6, "<webdir> required when \"WEB\" installer requested");
            } else if (string2.equalsIgnoreCase(STANDARD) && object2 != null) {
                info.setWebDirURL(null);
            }
        }
        info.setPack200Compression((iXMLElement3 = iXMLElement6.getFirstChildNamed("pack200")) != null);
        IXMLElement iXMLElement8 = iXMLElement6.getFirstChildNamed("run-privileged");
        info.setRequirePrivilegedExecution(iXMLElement8 != null);
        if (iXMLElement8 != null && iXMLElement8.hasAttribute("condition")) {
            info.setPrivilegedExecutionConditionID(iXMLElement8.getAttribute("condition"));
        }
        if (this.validateYesNoAttribute(iXMLElement2 = iXMLElement6.getFirstChildNamed("uninstaller"), "write", YES)) {
            serializable = this.findIzPackResource("lib/uninstaller.jar", "Uninstaller", iXMLElement6);
            this.compiler.addResource("IzPack.uninstaller", (URL)serializable);
            if (iXMLElement8 != null) {
                info.setRequirePrivilegedExecutionUninstaller(this.validateYesNoAttribute(iXMLElement8, "uninstaller", YES));
            }
            if (iXMLElement2 != null) {
                object = iXMLElement2.getAttribute("name");
                if (object != null && ((String)object).length() > ".jar".length()) {
                    info.setUninstallerName((String)object);
                }
                if ((string = iXMLElement2.getAttribute("path")) != null) {
                    info.setUninstallerPath(string);
                }
                if (iXMLElement2.hasAttribute("condition")) {
                    String string3 = iXMLElement2.getAttribute("condition");
                    info.setUninstallerCondition(string3);
                }
            }
        }
        if ((serializable = iXMLElement6.getFirstChildNamed("summarylogfilepath")) != null) {
            info.setSummaryLogFilePath(this.requireContent((IXMLElement)serializable));
        }
        if ((object = iXMLElement6.getFirstChildNamed("writeinstallationinformation")) != null) {
            string = this.requireContent((IXMLElement)object);
            info.setWriteInstallationInformation(this.validateYesNo(string));
        }
        string = this.compiler.getProperty("UNPACKER_CLASS");
        info.setUnpackerClassName(string);
        this.compiler.setInfo(info);
        this.notifyCompilerListener("addInfo", 2, iXMLElement);
    }

    protected void addVariables(IXMLElement iXMLElement) throws CompilerException {
        this.notifyCompilerListener("addVariables", 1, iXMLElement);
        IXMLElement iXMLElement2 = iXMLElement.getFirstChildNamed("variables");
        if (iXMLElement2 == null) {
            return;
        }
        Properties properties = this.compiler.getVariables();
        for (IXMLElement iXMLElement3 : iXMLElement2.getChildrenNamed("variable")) {
            String string = this.requireAttribute(iXMLElement3, "name");
            String string2 = this.requireAttribute(iXMLElement3, "value");
            if (properties.contains(string)) {
                this.parseWarn(iXMLElement3, "Variable '" + string + "' being overwritten");
            }
            properties.setProperty(string, string2);
        }
        this.notifyCompilerListener("addVariables", 2, iXMLElement);
    }

    protected void addDynamicVariables(IXMLElement iXMLElement) throws CompilerException {
        this.notifyCompilerListener("addDynamicVariables", 1, iXMLElement);
        IXMLElement iXMLElement2 = iXMLElement.getFirstChildNamed("dynamicvariables");
        if (iXMLElement2 == null) {
            return;
        }
        Map<String, List<DynamicVariable>> map = this.compiler.getDynamicVariables();
        for (IXMLElement iXMLElement3 : iXMLElement2.getChildrenNamed("variable")) {
            Object object;
            String string = this.requireAttribute(iXMLElement3, "name");
            String string2 = iXMLElement3.getAttribute("value");
            if (string2 == null) {
                object = iXMLElement3.getFirstChildNamed("value");
                if (object != null) {
                    string2 = object.getContent();
                    if (string2 == null) {
                        this.parseError("A dynamic variable needs either a value attribute or a value element.");
                    }
                } else {
                    this.parseError("A dynamic variable needs either a value attribute or a value element. Variable name: " + string);
                }
            }
            object = iXMLElement3.getAttribute("condition");
            List<Object> list = new ArrayList();
            if (map.containsKey(string)) {
                list = map.get(string);
            } else {
                map.put(string, list);
            }
            DynamicVariable dynamicVariable = new DynamicVariable();
            dynamicVariable.setName(string);
            dynamicVariable.setValue(string2);
            dynamicVariable.setConditionid((String)object);
            if (list.remove(dynamicVariable)) {
                this.parseWarn(iXMLElement3, "Dynamic Variable '" + string + "' will be overwritten");
            }
            list.add(dynamicVariable);
        }
        this.notifyCompilerListener("addDynamicVariables", 2, iXMLElement);
    }

    protected void addConditions(IXMLElement iXMLElement) throws CompilerException {
        this.notifyCompilerListener("addConditions", 1, iXMLElement);
        IXMLElement iXMLElement2 = iXMLElement.getFirstChildNamed("conditions");
        Map<String, Condition> map = this.compiler.getConditions();
        if (iXMLElement2 != null) {
            for (IXMLElement iXMLElement3 : iXMLElement2.getChildrenNamed("condition")) {
                Condition condition = RulesEngine.analyzeCondition(iXMLElement3);
                if (condition != null) {
                    String string = condition.getId();
                    if (map.containsKey(string)) {
                        this.parseWarn(iXMLElement3, "Condition with id '" + string + "' will be overwritten");
                    }
                    map.put(string, condition);
                    continue;
                }
                this.parseWarn(iXMLElement3, "Condition couldn't be instantiated.");
            }
        }
        this.notifyCompilerListener("addConditions", 2, iXMLElement);
    }

    protected void substituteProperties(IXMLElement iXMLElement) throws CompilerException {
        this.notifyCompilerListener("substituteProperties", 1, iXMLElement);
        IXMLElement iXMLElement2 = iXMLElement.getFirstChildNamed("properties");
        if (iXMLElement2 != null) {
            for (IXMLElement iXMLElement3 : iXMLElement2.getChildrenNamed("property")) {
                Property property = new Property(iXMLElement3, this);
                property.execute();
            }
        }
        if (iXMLElement2 != null) {
            iXMLElement.removeChild(iXMLElement2);
        }
        this.substituteAllProperties(iXMLElement);
        if (iXMLElement2 != null) {
            iXMLElement.addChild(iXMLElement2);
        }
        this.notifyCompilerListener("substituteProperties", 2, iXMLElement);
    }

    protected void substituteAllProperties(IXMLElement iXMLElement) throws CompilerException {
        String string;
        Enumeration enumeration = iXMLElement.enumerateAttributeNames();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            String string2 = this.compiler.replaceProperties(iXMLElement.getAttribute(string));
            iXMLElement.setAttribute(string, string2);
        }
        string = iXMLElement.getContent();
        if (string != null) {
            iXMLElement.setContent(this.compiler.replaceProperties(string));
        }
        for (int i = 0; i < iXMLElement.getChildren().size(); ++i) {
            IXMLElement iXMLElement2 = iXMLElement.getChildren().elementAt(i);
            this.substituteAllProperties(iXMLElement2);
        }
    }

    private void assertIsNormalReadableFile(File file, String string) throws CompilerException {
        if (file != null) {
            if (!file.exists()) {
                throw new CompilerException(string + " does not exist: " + file);
            }
            if (!file.isFile()) {
                throw new CompilerException(string + " is not a regular file: " + file);
            }
            if (!file.canRead()) {
                throw new CompilerException(string + " is not readable by application: " + file);
            }
        }
    }

    protected IXMLElement getXMLTree() throws CompilerException, IOException {
        XMLParser xMLParser = new XMLParser();
        IXMLElement iXMLElement = null;
        if (this.filename != null) {
            File file = new File(this.filename).getAbsoluteFile();
            this.assertIsNormalReadableFile(file, "Configuration file");
            iXMLElement = xMLParser.parse(new FileInputStream(this.filename), file.getAbsolutePath());
            this.compiler.setProperty("izpack.file", file.toString());
        } else if (this.installText != null) {
            iXMLElement = xMLParser.parse(this.installText);
        } else {
            throw new CompilerException("Neither install file nor text specified");
        }
        if (!"installation".equalsIgnoreCase(iXMLElement.getName())) {
            this.parseError(iXMLElement, "this is not an IzPack XML installation file");
        }
        if (!VERSION.equalsIgnoreCase(this.requireAttribute(iXMLElement, "version"))) {
            this.parseError(iXMLElement, "the file version is different from the compiler version");
        }
        return iXMLElement;
    }

    protected int getOverrideValue(IXMLElement iXMLElement) throws CompilerException {
        int n = 4;
        String string = iXMLElement.getAttribute("override");
        if (string != null) {
            if ("true".equalsIgnoreCase(string)) {
                n = 1;
            } else if ("false".equalsIgnoreCase(string)) {
                n = 0;
            } else if ("asktrue".equalsIgnoreCase(string)) {
                n = 3;
            } else if ("askfalse".equalsIgnoreCase(string)) {
                n = 2;
            } else if ("update".equalsIgnoreCase(string)) {
                n = 4;
            } else {
                this.parseError(iXMLElement, "invalid value for attribute \"override\"");
            }
        }
        return n;
    }

    private URL findProjectResource(String string, String string2, IXMLElement iXMLElement) throws CompilerException {
        URL uRL = null;
        File file = new File(string);
        if (!file.isAbsolute()) {
            file = new File(this.basedir, string);
        }
        if (!file.exists()) {
            this.parseError(iXMLElement, string2 + " not found: " + file);
        }
        try {
            uRL = file.toURL();
        }
        catch (MalformedURLException malformedURLException) {
            this.parseError(iXMLElement, string2 + "(" + file + ")", malformedURLException);
        }
        return uRL;
    }

    private URL findIzPackResource(String string, String string2, IXMLElement iXMLElement) throws CompilerException {
        return this.findIzPackResource(string, string2, iXMLElement, false);
    }

    private URL findIzPackResource(String string, String string2, IXMLElement iXMLElement, boolean bl) throws CompilerException {
        URL uRL = this.getClass().getResource("/" + string);
        if (uRL == null) {
            File file = new File(string);
            if (!file.isAbsolute()) {
                file = new File(Compiler.IZPACK_HOME, string);
            }
            if (file.exists()) {
                try {
                    uRL = file.toURL();
                }
                catch (MalformedURLException malformedURLException) {
                    this.parseError(iXMLElement, string2 + "(" + file + ")", malformedURLException);
                }
            } else if (bl) {
                this.parseWarn(iXMLElement, string2 + " not found: " + file);
            } else {
                this.parseError(iXMLElement, string2 + " not found: " + file);
            }
        }
        return uRL;
    }

    protected void parseError(String string) throws CompilerException {
        throw new CompilerException(this.filename + ":" + string);
    }

    protected void parseError(IXMLElement iXMLElement, String string) throws CompilerException {
        throw new CompilerException(this.filename + ":" + iXMLElement.getLineNr() + ": " + string);
    }

    protected void parseError(IXMLElement iXMLElement, String string, Throwable throwable) throws CompilerException {
        throw new CompilerException(this.filename + ":" + iXMLElement.getLineNr() + ": " + string, throwable);
    }

    protected void parseWarn(IXMLElement iXMLElement, String string) {
        System.out.println("Warning: " + this.filename + ":" + iXMLElement.getLineNr() + ": " + string);
    }

    protected IXMLElement requireChildNamed(IXMLElement iXMLElement, String string) throws CompilerException {
        IXMLElement iXMLElement2 = iXMLElement.getFirstChildNamed(string);
        if (iXMLElement2 == null) {
            this.parseError(iXMLElement, "<" + iXMLElement.getName() + "> requires child <" + string + ">");
        }
        return iXMLElement2;
    }

    protected URL requireURLContent(IXMLElement iXMLElement) throws CompilerException {
        URL uRL = null;
        try {
            uRL = new URL(this.requireContent(iXMLElement));
        }
        catch (MalformedURLException malformedURLException) {
            this.parseError(iXMLElement, "<" + iXMLElement.getName() + "> requires valid URL", malformedURLException);
        }
        return uRL;
    }

    protected String requireContent(IXMLElement iXMLElement) throws CompilerException {
        String string = iXMLElement.getContent();
        if (string == null || string.length() == 0) {
            this.parseError(iXMLElement, "<" + iXMLElement.getName() + "> requires content");
        }
        return string;
    }

    protected boolean validateYesNo(String string) {
        boolean bl = false;
        if ("yes".equalsIgnoreCase(string)) {
            bl = true;
        } else if ("no".equalsIgnoreCase(string)) {
            bl = false;
        } else {
            Debug.trace("yes/no not found. trying true/false");
            bl = Boolean.valueOf(string);
        }
        return bl;
    }

    protected String requireAttribute(IXMLElement iXMLElement, String string) throws CompilerException {
        String string2 = iXMLElement.getAttribute(string);
        if (string2 == null) {
            this.parseError(iXMLElement, "<" + iXMLElement.getName() + "> requires attribute '" + string + "'");
        }
        return string2;
    }

    protected int requireIntAttribute(IXMLElement iXMLElement, String string) throws CompilerException {
        String string2 = iXMLElement.getAttribute(string);
        if (string2 == null || string2.length() == 0) {
            this.parseError(iXMLElement, "<" + iXMLElement.getName() + "> requires attribute '" + string + "'");
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            this.parseError(iXMLElement, "'" + string + "' must be an integer");
            return 0;
        }
    }

    protected boolean requireYesNoAttribute(IXMLElement iXMLElement, String string) throws CompilerException {
        String string2 = this.requireAttribute(iXMLElement, string);
        if ("yes".equalsIgnoreCase(string2)) {
            return true;
        }
        if ("no".equalsIgnoreCase(string2)) {
            return false;
        }
        this.parseError(iXMLElement, "<" + iXMLElement.getName() + "> invalid attribute '" + string + "': Expected (yes|no)");
        return false;
    }

    protected boolean validateYesNoAttribute(IXMLElement iXMLElement, String string, boolean bl) {
        if (iXMLElement == null) {
            return bl;
        }
        String string2 = iXMLElement.getAttribute(string, bl ? "yes" : "no");
        if ("yes".equalsIgnoreCase(string2)) {
            return true;
        }
        if ("no".equalsIgnoreCase(string2)) {
            return false;
        }
        this.parseWarn(iXMLElement, "<" + iXMLElement.getName() + "> invalid attribute '" + string + "': Expected (yes|no) if present");
        return bl;
    }

    public static void main(String[] stringArray) {
        System.out.println("");
        System.out.println(".::  IzPack - Version 4.3.3 ::.");
        System.out.println("");
        System.out.println("< compiler specifications version: 1.0 >");
        System.out.println("");
        System.out.println("- Copyright (c) 2001-2008 Julien Ponge");
        System.out.println("- Visit http://izpack.org/ for the latest releases");
        System.out.println("- Released under the terms of the Apache Software License version 2.0.");
        System.out.println("");
        int n = 1;
        String string = ".";
        String string2 = System.getProperty("izpack.home");
        if (string2 != null) {
            string = string2;
        } else {
            string2 = System.getenv("IZPACK_HOME");
            if (string2 != null) {
                string = string2;
            }
        }
        try {
            String string3 = ".";
            String string4 = STANDARD;
            String string5 = "default";
            int n2 = -1;
            int n3 = stringArray.length;
            if (n3 < 1) {
                throw new Exception("no arguments given");
            }
            if ("-?".equalsIgnoreCase(stringArray[0])) {
                System.out.println("-> Command line parameters are : (xml file) [args]");
                System.out.println("   (xml file): the xml file describing the installation");
                System.out.println("   -h (IzPack home) : the root path of IzPack. This will be needed");
                System.out.println("               if the compiler is not called in the root directory  of IzPack.");
                System.out.println("               Do not forget quotations if there are blanks in the path.");
                System.out.println("   -b (base) : indicates the base path that the compiler will use for filenames");
                System.out.println("               of sources. Default is the current path. Attend to -h.");
                System.out.println("   -k (kind) : indicates the kind of installer to generate");
                System.out.println("               default is standard");
                System.out.println("   -o (out)  : indicates the output file name");
                System.out.println("               default is the xml file name\n");
                System.out.println("   -c (compression)  : indicates the compression format to be used for packs");
                System.out.println("               default is the internal deflate compression\n");
                System.out.println("   -l (compression-level)  : indicates the level for the used compression format");
                System.out.println("                if supported. Only integer are valid\n");
                System.out.println("   When using vm option -DSTACKTRACE=true there is all kind of debug info ");
                System.out.println("");
                n = 0;
            } else {
                String string6 = stringArray[0];
                String string7 = string6.substring(0, string6.length() - 3) + "jar";
                block10: for (int i = 1; i < n3; ++i) {
                    if (stringArray[i].startsWith("-") && stringArray[i].length() == 2) {
                        switch (stringArray[i].toLowerCase().charAt(1)) {
                            case 'b': {
                                if (i + 1 < n3) {
                                    string3 = stringArray[++i];
                                    continue block10;
                                }
                                throw new Exception("base argument missing");
                            }
                            case 'k': {
                                if (i + 1 < n3) {
                                    string4 = stringArray[++i];
                                    continue block10;
                                }
                                throw new Exception("kind argument missing");
                            }
                            case 'o': {
                                if (i + 1 < n3) {
                                    string7 = stringArray[++i];
                                    continue block10;
                                }
                                throw new Exception("output argument missing");
                            }
                            case 'c': {
                                if (i + 1 < n3) {
                                    string5 = stringArray[++i];
                                    continue block10;
                                }
                                throw new Exception("compression format argument missing");
                            }
                            case 'l': {
                                if (i + 1 < n3) {
                                    n2 = Integer.parseInt(stringArray[++i]);
                                    continue block10;
                                }
                                throw new Exception("compression level argument missing");
                            }
                            case 'h': {
                                if (i + 1 < n3) {
                                    string = stringArray[++i];
                                    continue block10;
                                }
                                throw new Exception("IzPack home path argument missing");
                            }
                            default: {
                                throw new Exception("unknown argument");
                            }
                        }
                    }
                    throw new Exception("bad argument");
                }
                string = CompilerConfig.resolveIzPackHome(string);
                System.out.println("-> Processing  : " + string6);
                System.out.println("-> Output      : " + string7);
                System.out.println("-> Base path   : " + string3);
                System.out.println("-> Kind        : " + string4);
                System.out.println("-> Compression : " + string5);
                System.out.println("-> Compr. level: " + n2);
                System.out.println("-> IzPack home : " + string);
                System.out.println("");
                Compiler.setIzpackHome(string);
                Compiler.CmdlinePackagerListener cmdlinePackagerListener = new Compiler.CmdlinePackagerListener();
                CompilerConfig compilerConfig = new CompilerConfig(string6, string3, string4, string7, string5, n2, cmdlinePackagerListener, null);
                compilerConfig.executeCompiler();
                while (compilerConfig.isAlive()) {
                    Thread.sleep(100L);
                }
                if (compilerConfig.wasSuccessful()) {
                    n = 0;
                }
                System.out.println("Build time: " + new Date());
            }
        }
        catch (Exception exception) {
            System.err.println("-> Fatal error :");
            System.err.println("   " + exception.getMessage());
            exception.printStackTrace();
            System.err.println("");
            System.err.println("(tip : use -? to get the commmand line parameters)");
        }
        System.exit(n);
    }

    private static String resolveIzPackHome(String string) {
        File file = new File(string, IZ_TEST_SUBDIR + File.separator + IZ_TEST_FILE);
        if (file.exists()) {
            return string;
        }
        String string2 = Compiler.class.getName();
        string2 = string2.replace('.', '/');
        string2 = "/" + string2 + ".class";
        URL uRL = Compiler.class.getResource(string2);
        String string3 = uRL.getFile();
        int n = string3.indexOf(string2);
        if ((string3 = string3.substring(0, n)).endsWith("!")) {
            if (string3.endsWith("standalone-compiler.jar!") || string3.endsWith("standalone-compiler-4.0.0.jar!") || string3.matches("standalone-compiler-[\\d\\.]+.jar!")) {
                return ".";
            }
            string3 = string3.substring(0, string3.length() - 1);
        }
        File file2 = null;
        file2 = URI.create(string3).isAbsolute() ? new File(URI.create(string3)) : new File(string3);
        while (true) {
            if (file2 == null) {
                throw new IllegalArgumentException("No valid IzPack home directory found");
            }
            file = new File(file2, IZ_TEST_SUBDIR + File.separator + IZ_TEST_FILE);
            if (file.exists()) {
                return file2.getAbsolutePath();
            }
            file2 = file2.getParentFile();
        }
    }

    private void addCustomListeners(IXMLElement iXMLElement) throws Exception {
        IXMLElement iXMLElement2 = iXMLElement.getFirstChildNamed("listeners");
        if (iXMLElement2 == null) {
            return;
        }
        for (IXMLElement iXMLElement3 : iXMLElement2.getChildrenNamed("listener")) {
            Object[] objectArray = this.getCompilerListenerInstance(iXMLElement3);
            if (objectArray != null) {
                this.addCompilerListener((CompilerListener)objectArray[0]);
            }
            String[] stringArray = new String[]{"installer", "uninstaller"};
            int[] nArray = new int[]{0, 1};
            for (int i = 0; i < stringArray.length; ++i) {
                String string = iXMLElement3.getAttribute(stringArray[i]);
                if (string == null) continue;
                String string2 = iXMLElement3.getAttribute("jar");
                if ((string2 = this.compiler.replaceProperties(string2)) == null) {
                    string2 = "bin/customActions/" + string + ".jar";
                }
                List<OsConstraint> list = OsConstraint.getOsList(iXMLElement3);
                this.compiler.addCustomListener(nArray[i], string, string2, list);
            }
        }
    }

    private List<String> getContainedFilePaths(URL uRL) throws Exception {
        JarInputStream jarInputStream = new JarInputStream(uRL.openStream());
        ZipEntry zipEntry = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        while ((zipEntry = jarInputStream.getNextEntry()) != null) {
            String string = zipEntry.getName();
            if (zipEntry.isDirectory()) continue;
            arrayList.add(string);
        }
        jarInputStream.close();
        return arrayList;
    }

    private String getFullClassName(URL uRL, String string) throws IOException {
        JarInputStream jarInputStream = new JarInputStream(uRL.openStream());
        ZipEntry zipEntry = null;
        while ((zipEntry = jarInputStream.getNextEntry()) != null) {
            String string2 = zipEntry.getName();
            int n = string2.lastIndexOf(".class");
            if (n < 0) continue;
            string2 = string2.replace('/', '.');
            int n2 = -1;
            int n3 = -1;
            if (string != null) {
                n2 = string2.indexOf(string);
                n3 = string2.toLowerCase().indexOf(string.toLowerCase());
            }
            if (n2 != -1 && string2.length() == n2 + string.length() + 6) {
                jarInputStream.close();
                return string2.substring(0, n);
            }
            if (n3 == -1 || string2.length() != n3 + string.length() + 6) continue;
            throw new IllegalArgumentException("Fatal error! The declared panel name in the xml file (" + string + ") differs in case to the founded class file (" + string2 + ").");
        }
        jarInputStream.close();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] getCompilerListenerInstance(IXMLElement iXMLElement) throws Exception {
        Object object;
        URL uRL;
        String string;
        String string2 = iXMLElement.getAttribute("compiler");
        Class<?> clazz = null;
        Object var4_4 = null;
        if (string2 == null) {
            return null;
        }
        String string3 = iXMLElement.getAttribute("jar");
        if ((string3 = this.compiler.replaceProperties(string3)) == null) {
            string3 = "bin/customActions/" + string2 + ".jar";
        }
        if ((string = this.getFullClassName(uRL = this.findIzPackResource(string3, "CustomAction jar file", iXMLElement), string2)) == null) {
            return null;
        }
        if (uRL != null) {
            if (this.getClass().getResource("/" + string3) != null) {
                object = null;
                FileOutputStream fileOutputStream = null;
                byte[] byArray = new byte[5120];
                File file = null;
                try {
                    int n;
                    file = File.createTempFile("izpj", ".jar");
                    file.deleteOnExit();
                    fileOutputStream = new FileOutputStream(file);
                    object = this.getClass().getResourceAsStream("/" + string3);
                    long l = 0L;
                    while ((n = ((InputStream)object).read(byArray)) != -1) {
                        fileOutputStream.write(byArray, 0, n);
                        l += (long)n;
                    }
                }
                finally {
                    if (object != null) {
                        ((InputStream)object).close();
                    }
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                uRL = file.toURL();
            }
            object = new URLClassLoader(new URL[]{uRL}, CompilerListener.class.getClassLoader());
            clazz = ((ClassLoader)object).loadClass(string);
        }
        if (clazz != null) {
            var4_4 = clazz.newInstance();
        } else {
            this.parseError(iXMLElement, "Cannot find defined compiler listener " + string2);
        }
        if (!CompilerListener.class.isInstance(var4_4)) {
            this.parseError(iXMLElement, "'" + string2 + "' must be implemented " + CompilerListener.class.toString());
        }
        object = OsConstraint.getOsList(iXMLElement);
        return new Object[]{var4_4, string2, object};
    }

    private void addCompilerListener(CompilerListener compilerListener) {
        this.compilerListeners.add(compilerListener);
    }

    private void notifyCompilerListener(String string, int n, IXMLElement iXMLElement) throws CompilerException {
        Iterator<CompilerListener> iterator = this.compilerListeners.iterator();
        IPackager iPackager = this.compiler.getPackager();
        while (iterator != null && iterator.hasNext()) {
            CompilerListener compilerListener = iterator.next();
            compilerListener.notify(string, n, iXMLElement, iPackager);
        }
    }

    private Map getAdditionals(IXMLElement iXMLElement) throws CompilerException {
        Iterator<CompilerListener> iterator = this.compilerListeners.iterator();
        Map map = null;
        try {
            while (iterator != null && iterator.hasNext()) {
                map = iterator.next().reviseAdditionalDataMap(map, iXMLElement);
            }
        }
        catch (CompilerException compilerException) {
            this.parseError(iXMLElement, compilerException.getMessage());
        }
        return map;
    }

    private void mergePacksLangFiles() throws CompilerException {
        if (this.packsLangUrlMap.size() <= 0) {
            return;
        }
        OutputStream outputStream = null;
        try {
            XMLParser xMLParser = new XMLParser();
            for (String string : this.packsLangUrlMap.keySet()) {
                URL uRL = null;
                List<URL> list = this.packsLangUrlMap.get(string);
                if (list.size() == 0) continue;
                if (list.size() == 1) {
                    uRL = list.get(0);
                } else {
                    Object object;
                    IXMLElement iXMLElement = null;
                    for (URL uRL2 : list) {
                        object = xMLParser.parse(uRL2);
                        if (iXMLElement == null) {
                            iXMLElement = object;
                            continue;
                        }
                        Vector<IXMLElement> vector = object.getChildrenNamed("str");
                        for (IXMLElement iXMLElement2 : vector) {
                            iXMLElement.addChild(iXMLElement2);
                        }
                    }
                    File file = File.createTempFile("izpp", null);
                    file.deleteOnExit();
                    FileOutputStream object22 = new FileOutputStream(file);
                    outputStream = new BufferedOutputStream(object22);
                    object = new XMLWriter(outputStream);
                    object.write(iXMLElement);
                    outputStream.close();
                    outputStream = null;
                    uRL = file.toURL();
                }
                this.compiler.addResource(string, uRL);
            }
        }
        catch (Exception exception) {
            throw new CompilerException("Unable to merge multiple packsLang.xml files: " + exception.getMessage(), exception);
        }
        finally {
            if (null != outputStream) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void addPanelActions(IXMLElement iXMLElement, Panel panel) throws CompilerException {
        IXMLElement iXMLElement2 = iXMLElement.getFirstChildNamed("actions");
        if (iXMLElement2 != null) {
            Vector<IXMLElement> vector = iXMLElement2.getChildrenNamed("action");
            if (vector != null) {
                for (IXMLElement iXMLElement3 : vector) {
                    Object object;
                    String string = iXMLElement3.getAttribute("stage");
                    String string2 = iXMLElement3.getAttribute("classname");
                    if (string2 != null) {
                        object = iXMLElement3.getChildrenNamed("param");
                        PanelActionConfiguration panelActionConfiguration = new PanelActionConfiguration();
                        Iterator iterator = ((Vector)object).iterator();
                        while (iterator.hasNext()) {
                            IXMLElement iXMLElement4 = (IXMLElement)iterator.next();
                            IXMLElement iXMLElement5 = iXMLElement4.getFirstChildNamed("key");
                            IXMLElement iXMLElement6 = iXMLElement4.getFirstChildNamed("value");
                            if (iXMLElement5 == null || iXMLElement6 == null) continue;
                            Debug.trace("Adding configuration property " + iXMLElement5.getContent() + " with value " + iXMLElement6.getContent() + " for action " + string2);
                            panelActionConfiguration.addProperty(iXMLElement5.getContent(), iXMLElement6.getContent());
                        }
                        panel.putPanelActionConfiguration(string2, panelActionConfiguration);
                    }
                    try {
                        object = PanelAction.ActionStage.valueOf(string);
                        switch (1.$SwitchMap$com$izforge$izpack$installer$PanelAction$ActionStage[((Enum)object).ordinal()]) {
                            case 1: {
                                panel.addPreConstructionActions(string2);
                                break;
                            }
                            case 2: {
                                panel.addPreActivationAction(string2);
                                break;
                            }
                            case 3: {
                                panel.addPreValidationAction(string2);
                                break;
                            }
                            case 4: {
                                panel.addPostValidationAction(string2);
                            }
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        this.parseError(iXMLElement3, "Invalid value [" + string + "] for attribute : " + "stage");
                    }
                }
            } else {
                this.parseError(iXMLElement2, "<actions> requires a <action>");
            }
        }
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$com$izforge$izpack$installer$PanelAction$ActionStage;

        static {
            $SwitchMap$com$izforge$izpack$installer$PanelAction$ActionStage = new int[PanelAction.ActionStage.values().length];
            try {
                1.$SwitchMap$com$izforge$izpack$installer$PanelAction$ActionStage[PanelAction.ActionStage.preconstruct.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$izforge$izpack$installer$PanelAction$ActionStage[PanelAction.ActionStage.preactivate.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$izforge$izpack$installer$PanelAction$ActionStage[PanelAction.ActionStage.prevalidate.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$izforge$izpack$installer$PanelAction$ActionStage[PanelAction.ActionStage.postvalidate.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    private class Edge {
        PackInfo u;
        PackInfo v;

        Edge(PackInfo packInfo, PackInfo packInfo2) {
            this.u = packInfo;
            this.v = packInfo2;
        }
    }
}

