/*
 * Decompiled with CFR 0.152.
 */
package org.cinvoke;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import org.cinvoke.CBThunk;
import org.cinvoke.CInvokeError;
import org.cinvoke.NativeInt;
import org.cinvoke.NativeLong;
import org.cinvoke.NativeLongLong;
import org.cinvoke.NativeShort;
import org.cinvoke.Ptr;

class Natives {
    private static final int T_JSHORT = -1;
    private static final int T_JINT = -2;
    private static final int T_JLONG = -3;
    private static final int T_CHAR = 0;
    private static final int T_SHORT = 1;
    private static final int T_INT = 2;
    private static final int T_LONG = 3;
    private static final int T_EXTRALONG = 4;
    private static final int T_FLOAT = 5;
    private static final int T_DOUBLE = 6;
    private static final int T_PTR = 7;
    private static final int STRUCT_TYPE = -999;
    public long _ctx = Natives.createContext();
    private HashMap _functions;
    private HashMap _structs;
    private HashMap _callbacks;

    public static native long createContext();

    public static native String getError(long var0);

    public static native int deleteContext(long var0);

    public static native long createLibrary(long var0, String var2);

    public static native long loadEPLibrary(long var0, long var2, String var4);

    public static native int deleteLibrary(long var0, long var2);

    public static native long createFunction(long var0, int var2, String var3, String var4);

    public static native Object invokeFunction(long var0, long var2, long var4, Object[] var6, int[] var7, Class var8, int var9);

    public static native int deleteFunction(long var0, long var2);

    public static native long createStruct(long var0);

    public static native int addValueMemberStruct(long var0, long var2, String var4, int var5);

    public static native int addStructMemberStruct(long var0, long var2, String var4, long var5);

    public static native long alloc(int var0);

    public static native void free(long var0);

    public static native int sizeofBasic(int var0);

    public static native long writeValue(long var0, Object var2, int var3);

    public static native Object readValue(long var0, Class var2, int var3);

    public static native int setMemberValueStruct(long var0, long var2, long var4, String var6, Object var7, int var8);

    public static native Object getMemberValueStruct(long var0, long var2, long var4, String var6, Class var7, int var8);

    public static native long getMemberPtrStruct(long var0, long var2, long var4, String var6);

    public static native int finishStruct(long var0, long var2);

    public static native int sizeStruct(long var0, long var2);

    public static native int deleteStruct(long var0, long var2);

    public static native long createCallback(long var0, long var2, CBThunk var4, Class[] var5, int[] var6, boolean var7, int var8);

    public static native long getEPCallback(long var0, long var2);

    public static native int deleteCallback(long var0, long var2);

    public static native String ptrToStringUTF8(long var0);

    public static native String ptrToStringUnicode(long var0, int var2);

    public static native long stringToPtrUTF8(String var0);

    public static native long stringToPtrUnicode(String var0);

    public Natives() {
        if (this._ctx == 0L) {
            throw new OutOfMemoryError();
        }
        this._functions = new HashMap();
        this._structs = new HashMap();
        this._callbacks = new HashMap();
    }

    public void close() {
        Iterator iterator = this._functions.values().iterator();
        while (iterator.hasNext()) {
            ((NativeMethod)iterator.next()).close();
        }
        iterator = this._structs.values().iterator();
        while (iterator.hasNext()) {
            ((NativeStruct)iterator.next()).close();
        }
        if (this._ctx != 0L) {
            Natives.deleteContext(this._ctx);
            this._ctx = 0L;
        }
    }

    public void fail() {
        throw new CInvokeError(Natives.getError(this._ctx));
    }

    public NativeMethod createNativeMethod(Method method, long l, int n) {
        NativeMethod nativeMethod = (NativeMethod)this._functions.get(method);
        if (nativeMethod == null) {
            nativeMethod = this.createNative(method, l, n);
            this._functions.put(method, nativeMethod);
        }
        return nativeMethod;
    }

    private int gettypeint(Class clazz, boolean bl) {
        if (clazz.isArray()) {
            if (clazz.isInterface()) {
                throw new CInvokeError("Arrays of callbacks not supported");
            }
            if (clazz.equals(String.class)) {
                throw new CInvokeError("Arrays of strings not supported");
            }
            return 7;
        }
        if (clazz.isInterface()) {
            return 7;
        }
        if (clazz.equals(String.class)) {
            return 7;
        }
        if (clazz.equals(Byte.class) || clazz.equals(Byte.TYPE)) {
            return 0;
        }
        if (clazz.equals(Short.class) || clazz.equals(Short.TYPE)) {
            return -1;
        }
        if (clazz.equals(Integer.class) || clazz.equals(Integer.TYPE)) {
            return -2;
        }
        if (clazz.equals(Long.class) || clazz.equals(Long.TYPE)) {
            return -3;
        }
        if (clazz.equals(Float.class) || clazz.equals(Float.TYPE)) {
            return 5;
        }
        if (clazz.equals(Double.class) || clazz.equals(Double.TYPE)) {
            return 6;
        }
        if (clazz.equals(NativeShort.class)) {
            return 1;
        }
        if (clazz.equals(NativeInt.class)) {
            return 2;
        }
        if (clazz.equals(NativeLong.class)) {
            return 3;
        }
        if (clazz.equals(NativeLongLong.class)) {
            return 4;
        }
        if (clazz.equals(Ptr.class)) {
            return 7;
        }
        if (bl) {
            throw new CInvokeError("Passing or returning structures by value not supported");
        }
        return -999;
    }

    private char gettypechar(int n) {
        switch (n) {
            case -1: {
                return '2';
            }
            case -2: {
                return '4';
            }
            case -3: {
                return '8';
            }
            case 0: {
                return 'c';
            }
            case 1: {
                return 's';
            }
            case 2: {
                return 'i';
            }
            case 3: {
                return 'l';
            }
            case 4: {
                return 'e';
            }
            case 5: {
                return 'f';
            }
            case 6: {
                return 'd';
            }
            case 7: {
                return 'p';
            }
        }
        throw new UnknownError("unknown type");
    }

    private NativeMethod createNative(Method method, long l, int n) {
        long l2 = 0L;
        if (l != 0L && (l2 = Natives.loadEPLibrary(this._ctx, l, method.getName())) == 0L) {
            this.fail();
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        boolean bl = false;
        int n2 = 0;
        Class<?> clazz = method.getReturnType();
        if (!clazz.equals(Void.TYPE)) {
            if (clazz.isArray()) {
                throw new CInvokeError("returning arrays not supported");
            }
            if (clazz.isInterface()) {
                throw new CInvokeError("returning callbacks not supported");
            }
            if (l == 0L && clazz.equals(String.class)) {
                throw new CInvokeError("returning strings not supported for callback methods");
            }
            bl = true;
            n2 = this.gettypeint(clazz, true);
            stringBuffer.append(this.gettypechar(n2));
        }
        Class<?>[] classArray = method.getParameterTypes();
        int[] nArray = new int[classArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            if (l == 0L) {
                if (classArray[i].isArray()) {
                    throw new CInvokeError("passing arrays not supported for callbacks methods");
                }
                if (classArray[i].isInterface()) {
                    throw new CInvokeError("passing callbacks not supported for callback methods");
                }
                if (classArray[i].equals(String.class)) {
                    throw new CInvokeError("passing strings not supported for callback methods");
                }
            }
            nArray[i] = this.gettypeint(classArray[i], true);
            stringBuffer2.append(this.gettypechar(nArray[i]));
        }
        long l3 = Natives.createFunction(this._ctx, n, stringBuffer.toString(), stringBuffer2.toString());
        if (l3 == 0L) {
            this.fail();
        }
        return new NativeMethod(this._ctx, l3, l2, nArray, bl, n2);
    }

    public Object unmarshalString(long l, int n) {
        if (l == 0L) {
            return null;
        }
        if (n == 1) {
            return Natives.ptrToStringUnicode(l, -1);
        }
        return Natives.ptrToStringUTF8(l);
    }

    private Object unmarshalStruct(long l, Class clazz) {
        Object t;
        long l2 = this.getNativeStruct((Class)clazz).st;
        Field[] fieldArray = clazz.getFields();
        Arrays.sort(fieldArray, new FieldComparator());
        try {
            t = clazz.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new CInvokeError("Cannot create new instance of class " + clazz.getName() + " due a security error: " + illegalAccessException.toString());
        }
        catch (InstantiationException instantiationException) {
            throw new CInvokeError("Cannot create new instance of class " + clazz.getName() + " due to error: " + instantiationException.toString());
        }
        for (int i = 0; i < fieldArray.length; ++i) {
            Object object;
            Field field = fieldArray[i];
            Class<?> clazz2 = field.getType();
            int n = this.gettypeint(clazz2, false);
            if (n == -999) {
                long l3 = Natives.getMemberPtrStruct(this._ctx, l2, l, field.getName());
                if (l3 == 0L) {
                    this.fail();
                }
                object = this.unmarshalStruct(l3, clazz2);
            } else {
                object = Natives.getMemberValueStruct(this._ctx, l2, l, field.getName(), this.filterType(clazz2), n);
            }
            try {
                field.set(t, object);
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new CInvokeError(clazz.getName() + " field access failed: " + illegalAccessException.toString());
            }
        }
        return t;
    }

    private long marshalStruct(long l, Object object, Class clazz) {
        int n;
        if (object == null) {
            throw new CInvokeError("Invalid null value");
        }
        long l2 = this.getNativeStruct((Class)clazz).st;
        Field[] fieldArray = clazz.getFields();
        Arrays.sort(fieldArray, new FieldComparator());
        for (n = 0; n < fieldArray.length; ++n) {
            Object object2;
            Field field = fieldArray[n];
            Class<?> clazz2 = field.getType();
            try {
                object2 = field.get(object);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new CInvokeError(clazz.getName() + " field access failed: " + illegalAccessException.toString());
            }
            int n2 = this.gettypeint(clazz2, false);
            if (n2 == -999) {
                long l3 = Natives.getMemberPtrStruct(this._ctx, l2, l, field.getName());
                if (l3 == 0L) {
                    this.fail();
                }
                this.marshalStruct(l3, object2, clazz2);
                continue;
            }
            if (Natives.setMemberValueStruct(this._ctx, l2, l, field.getName(), object2, n2) != 0) continue;
            this.fail();
        }
        n = Natives.sizeStruct(this._ctx, l2);
        if (n == -1) {
            this.fail();
        }
        return l + (long)n;
    }

    public Object marshalBasic(Object object, Class clazz) {
        if (object == null) {
            if (clazz.equals(Ptr.class)) {
                return new Ptr(0L);
            }
            throw new CInvokeError("Invalid null value");
        }
        return object;
    }

    public Ptr marshalString(String string, int n) {
        if (string == null) {
            return new Ptr(0L);
        }
        long l = n == 1 ? Natives.stringToPtrUnicode(string) : Natives.stringToPtrUTF8(string);
        if (l == 0L) {
            throw new OutOfMemoryError();
        }
        return new Ptr(l);
    }

    public Ptr marshalArray(Class clazz, Object object) {
        if (object == null) {
            return new Ptr(0L);
        }
        int n = Array.getLength(object);
        int n2 = n * this.getSize(clazz);
        long l = Natives.alloc(n2);
        if (l == 0L) {
            throw new OutOfMemoryError();
        }
        int n3 = this.gettypeint(clazz, false);
        long l2 = l;
        for (int i = 0; i < n; ++i) {
            Object object2 = Array.get(object, i);
            l2 = n3 == -999 ? this.marshalStruct(l2, object2, clazz) : Natives.writeValue(l2, this.marshalBasic(object2, clazz), n3);
        }
        return new Ptr(l);
    }

    public void unmarshalArray(long l, Object object, Class clazz) {
        if (l == 0L) {
            throw new CInvokeError("Reading array from null pointer");
        }
        clazz = this.filterType(clazz);
        int n = Array.getLength(object);
        int n2 = this.gettypeint(clazz, false);
        int n3 = this.getSize(clazz);
        long l2 = l;
        for (int i = 0; i < n; ++i) {
            Object object2 = n2 == -999 ? this.unmarshalStruct(l2, clazz) : Natives.readValue(l2, clazz, n2);
            Array.set(object, i, object2);
            l2 += (long)n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NativeStruct getNativeStruct(Class clazz) {
        NativeStruct nativeStruct = (NativeStruct)this._structs.get(clazz);
        if (nativeStruct == null) {
            if (this._structs.containsKey(clazz)) {
                throw new CInvokeError("Structures cannot have themselves as members");
            }
            this._structs.put(clazz, null);
            try {
                long l = Natives.createStruct(this._ctx);
                if (l == 0L) {
                    this.fail();
                }
                Field[] fieldArray = clazz.getFields();
                Arrays.sort(fieldArray, new FieldComparator());
                for (int i = 0; i < fieldArray.length; ++i) {
                    Class<?> clazz2 = fieldArray[i].getType();
                    if (clazz2.isArray()) {
                        Natives.deleteStruct(this._ctx, l);
                        throw new CInvokeError("Array structure members not supported");
                    }
                    if (clazz2.isInterface()) {
                        Natives.deleteStruct(this._ctx, l);
                        throw new CInvokeError("Callback structure members not supported");
                    }
                    if (clazz2.equals(String.class)) {
                        Natives.deleteStruct(this._ctx, l);
                        throw new CInvokeError("String structure members not supported");
                    }
                    int n = this.gettypeint(clazz2, false);
                    if (n == -999) {
                        if (Natives.addStructMemberStruct(this._ctx, l, fieldArray[i].getName(), this.getNativeStruct(clazz2).st) != 0) continue;
                        try {
                            this.fail();
                            continue;
                        }
                        finally {
                            Natives.deleteStruct(this._ctx, l);
                        }
                    }
                    if (Natives.addValueMemberStruct(this._ctx, l, fieldArray[i].getName(), n) != 0) continue;
                    try {
                        this.fail();
                        continue;
                    }
                    finally {
                        Natives.deleteStruct(this._ctx, l);
                    }
                }
                if (Natives.finishStruct(this._ctx, l) == 0) {
                    try {
                        this.fail();
                    }
                    finally {
                        Natives.deleteStruct(this._ctx, l);
                    }
                }
                nativeStruct = new NativeStruct(this._ctx, l);
                this._structs.put(clazz, nativeStruct);
            }
            finally {
                if (this._structs.get(clazz) == null) {
                    this._structs.remove(clazz);
                }
            }
        }
        return nativeStruct;
    }

    private Class filterType(Class clazz) {
        if (clazz.equals(Byte.TYPE)) {
            return Byte.class;
        }
        if (clazz.equals(Short.TYPE)) {
            return Short.class;
        }
        if (clazz.equals(Integer.TYPE)) {
            return Integer.class;
        }
        if (clazz.equals(Long.TYPE)) {
            return Long.class;
        }
        if (clazz.equals(Float.TYPE)) {
            return Float.class;
        }
        if (clazz.equals(Double.TYPE)) {
            return Double.class;
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long createCB(Object object, Class clazz, int n) {
        long l;
        Method[] methodArray = clazz.getDeclaredMethods();
        if (methodArray.length != 1) {
            throw new CInvokeError("Interface " + clazz.getName() + " has " + methodArray.length + " methods, not 1");
        }
        Method method = methodArray[0];
        NativeMethod nativeMethod = this.createNativeMethod(method, 0L, n);
        Class[] classArray = method.getParameterTypes();
        for (int i = 0; i < classArray.length; ++i) {
            classArray[i] = this.filterType(classArray[i]);
        }
        long l2 = Natives.createCallback(this._ctx, nativeMethod.func, new CBThunk(object, method), classArray, nativeMethod.types, nativeMethod.hasret, nativeMethod.rettype);
        if (l2 == 0L) {
            this.fail();
        }
        if ((l = Natives.getEPCallback(this._ctx, l2)) == 0L) {
            try {
                this.fail();
            }
            finally {
                Natives.deleteCallback(this._ctx, l2);
            }
        }
        this._callbacks.put(new Long(l), new Long(l2));
        return l;
    }

    public void deleteCB(long l) {
        Long l2 = (Long)this._callbacks.get(new Long(l));
        if (l2 != null) {
            Natives.deleteCallback(this._ctx, l2);
        }
    }

    public String ptrToString(Ptr ptr, int n, int n2) {
        if (n2 == 1) {
            return Natives.ptrToStringUnicode(ptr.longValue(), n);
        }
        return Natives.ptrToStringUTF8(ptr.longValue());
    }

    public Object[] ptrToArray(Ptr ptr, Class clazz, int n) {
        if (clazz.isInterface()) {
            throw new CInvokeError("Arrays of callbacks not supported");
        }
        Object object = Array.newInstance(clazz, n);
        this.unmarshalArray(ptr.longValue(), object, clazz);
        return (Object[])object;
    }

    public int getSize(Class clazz) {
        int n = this.gettypeint(clazz, false);
        if (n == -999) {
            int n2 = Natives.sizeStruct(this._ctx, this.getNativeStruct((Class)clazz).st);
            if (n2 == -1) {
                this.fail();
            }
            return n2;
        }
        return Natives.sizeofBasic(n);
    }

    public int getSize(Object object) {
        Class<?> clazz = object.getClass();
        if (clazz.isArray()) {
            if (clazz.isInterface()) {
                throw new CInvokeError("Arrays of callbacks not supported");
            }
            return Array.getLength(object) * this.getSize(clazz.getComponentType());
        }
        return this.getSize(clazz);
    }

    static {
        System.loadLibrary("cinvoke_java");
    }

    private class FieldComparator
    implements Comparator {
        private FieldComparator() {
        }

        public int compare(Object object, Object object2) {
            return ((Field)object).getName().compareTo(((Field)object2).getName());
        }
    }

    class NativeMethod {
        private long _ctx;
        public long func;
        public long ep;
        public int[] types;
        public boolean hasret;
        public int rettype;

        public NativeMethod(long l, long l2, long l3, int[] nArray, boolean bl, int n) {
            this.func = l2;
            this.ep = l3;
            this.types = nArray;
            this.hasret = bl;
            this.rettype = n;
            this._ctx = l;
        }

        public void close() {
            if (this.func != 0L) {
                Natives.deleteFunction(this._ctx, this.func);
                this.func = 0L;
            }
        }
    }

    class NativeStruct {
        public long st;
        private long _ctx;

        public NativeStruct(long l, long l2) {
            this._ctx = l;
            this.st = l2;
        }

        public void close() {
            if (this.st != 0L) {
                Natives.deleteStruct(this._ctx, this.st);
                this.st = 0L;
            }
        }
    }
}

