/*
 * Decompiled with CFR 0.152.
 */
package net.n3.nanoxml;

import java.io.Reader;
import java.util.Enumeration;
import java.util.Properties;
import net.n3.nanoxml.ContentReader;
import net.n3.nanoxml.IXMLBuilder;
import net.n3.nanoxml.IXMLEntityResolver;
import net.n3.nanoxml.IXMLParser;
import net.n3.nanoxml.IXMLReader;
import net.n3.nanoxml.IXMLValidator;
import net.n3.nanoxml.XMLEntityResolver;
import net.n3.nanoxml.XMLException;
import net.n3.nanoxml.XMLUtil;

public class StdXMLParser
implements IXMLParser {
    private static final char[] END_OF_PI = new char[]{'>', '?'};
    private static final char[] END_OF_CDATA = new char[]{'>', ']', ']'};
    private static final char[] END_OF_PCDATA = new char[]{'<'};
    private IXMLBuilder builder = null;
    private IXMLReader reader = null;
    private IXMLEntityResolver entityResolver = new XMLEntityResolver();
    private IXMLValidator validator = null;

    protected void finalize() throws Throwable {
        this.builder = null;
        this.reader = null;
        this.entityResolver = null;
        this.validator = null;
        super.finalize();
    }

    public void setBuilder(IXMLBuilder iXMLBuilder) {
        this.builder = iXMLBuilder;
    }

    public IXMLBuilder getBuilder() {
        return this.builder;
    }

    public void setValidator(IXMLValidator iXMLValidator) {
        this.validator = iXMLValidator;
    }

    public IXMLValidator getValidator() {
        return this.validator;
    }

    public void setResolver(IXMLEntityResolver iXMLEntityResolver) {
        this.entityResolver = iXMLEntityResolver;
    }

    public IXMLEntityResolver getResolver() {
        return this.entityResolver;
    }

    public void setReader(IXMLReader iXMLReader) {
        this.reader = iXMLReader;
    }

    public IXMLReader getReader() {
        return this.reader;
    }

    public Object parse() throws XMLException {
        try {
            this.builder.startBuilding(this.reader.getSystemID(), this.reader.getLineNr());
            this.scanData();
            return this.builder.getResult();
        }
        catch (XMLException xMLException) {
            throw xMLException;
        }
        catch (Exception exception) {
            throw new XMLException(exception);
        }
    }

    protected void scanData() throws Exception {
        while (!this.reader.atEOF() && this.builder.getResult() == null) {
            char c = XMLUtil.read(this.reader, null, '&', this.entityResolver);
            switch (c) {
                case '<': {
                    this.scanSomeTag(false);
                    break;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    break;
                }
                default: {
                    XMLUtil.errorInvalidInput(this.reader.getSystemID(), this.reader.getLineNr(), "`" + c + "' (0x" + Integer.toHexString(c) + ')');
                }
            }
        }
    }

    protected void scanSomeTag(boolean bl) throws Exception {
        char c = XMLUtil.read(this.reader, null, '&', this.entityResolver);
        switch (c) {
            case '?': {
                this.processPI();
                break;
            }
            case '!': {
                this.processSpecialTag(bl);
                break;
            }
            default: {
                this.reader.unread(c);
                this.processElement();
            }
        }
    }

    protected void processPI() throws Exception {
        XMLUtil.skipWhitespace(this.reader, '&', null, null);
        String string = XMLUtil.scanIdentifier(this.reader, '&', this.entityResolver);
        XMLUtil.skipWhitespace(this.reader, '&', null, null);
        ContentReader contentReader = new ContentReader(this.reader, this.entityResolver, '&', END_OF_PI, true, "");
        if (!string.equalsIgnoreCase("xml")) {
            this.builder.newProcessingInstruction(string, contentReader);
        }
        ((Reader)contentReader).close();
    }

    protected void processSpecialTag(boolean bl) throws Exception {
        char c = XMLUtil.read(this.reader, null, '&', this.entityResolver);
        switch (c) {
            case '[': {
                if (bl) {
                    this.processCDATA();
                } else {
                    XMLUtil.skipTag(this.reader, '&', this.entityResolver);
                }
                return;
            }
            case 'D': {
                this.processDocType();
                return;
            }
            case '-': {
                XMLUtil.skipComment(this.reader, this.entityResolver);
                return;
            }
        }
    }

    protected void processCDATA() throws Exception {
        if (!XMLUtil.checkLiteral(this.reader, '&', this.entityResolver, "CDATA[")) {
            XMLUtil.skipTag(this.reader, '&', this.entityResolver);
            return;
        }
        this.validator.PCDataAdded(this.reader.getSystemID(), this.reader.getLineNr());
        ContentReader contentReader = new ContentReader(this.reader, this.entityResolver, '&', END_OF_CDATA, true, "");
        this.builder.addPCData(contentReader, this.reader.getSystemID(), this.reader.getLineNr());
        ((Reader)contentReader).close();
    }

    protected void processDocType() throws Exception {
        if (!XMLUtil.checkLiteral(this.reader, '&', this.entityResolver, "OCTYPE")) {
            XMLUtil.skipTag(this.reader, '&', this.entityResolver);
            return;
        }
        XMLUtil.skipWhitespace(this.reader, '&', null, null);
        String string = null;
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = XMLUtil.scanIdentifier(this.reader, '&', this.entityResolver);
        XMLUtil.skipWhitespace(this.reader, '&', null, null);
        char c = XMLUtil.read(this.reader, null, '&', this.entityResolver);
        if (c == 'P') {
            string = XMLUtil.scanPublicID(stringBuffer, this.reader, '&', this.entityResolver);
            XMLUtil.skipWhitespace(this.reader, '&', null, null);
            c = XMLUtil.read(this.reader, null, '&', this.entityResolver);
        } else if (c == 'S') {
            string = XMLUtil.scanSystemID(this.reader, '&', this.entityResolver);
            XMLUtil.skipWhitespace(this.reader, '&', null, null);
            c = XMLUtil.read(this.reader, null, '&', this.entityResolver);
        }
        if (c == '[') {
            this.validator.parseDTD(stringBuffer.toString(), this.reader, this.entityResolver, false);
            XMLUtil.skipWhitespace(this.reader, '&', null, null);
            c = XMLUtil.read(this.reader, null, '&', this.entityResolver);
        }
        if (c != '>') {
            XMLUtil.errorExpectedInput(this.reader.getSystemID(), this.reader.getLineNr(), "`>'");
        }
        if (string != null) {
            Reader reader = this.reader.openStream(stringBuffer.toString(), string);
            this.reader.startNewStream(reader);
            this.reader.setSystemID(string);
            this.reader.setPublicID(stringBuffer.toString());
            this.validator.parseDTD(stringBuffer.toString(), this.reader, this.entityResolver, true);
        }
    }

    protected void processElement() throws Exception {
        Object object;
        Object object2;
        CharSequence charSequence;
        char c;
        String string = XMLUtil.scanIdentifier(this.reader, '&', this.entityResolver);
        XMLUtil.skipWhitespace(this.reader, '&', null, null);
        String string2 = null;
        int n = string.indexOf(58);
        if (n > 0) {
            string2 = string.substring(0, n);
            string = string.substring(n + 1);
        }
        this.validator.elementStarted(string, string2, null, this.reader.getSystemID(), this.reader.getLineNr());
        this.builder.startElement(string, string2, null, this.reader.getSystemID(), this.reader.getLineNr());
        while ((c = XMLUtil.read(this.reader, null, '&', this.entityResolver)) != '/' && c != '>') {
            this.reader.unread(c);
            this.processAttribute();
            XMLUtil.skipWhitespace(this.reader, '&', null, null);
        }
        Properties properties = new Properties();
        this.validator.elementAttributesProcessed(string, string2, null, properties, this.reader.getSystemID(), this.reader.getLineNr());
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            charSequence = (String)enumeration.nextElement();
            object2 = properties.getProperty((String)charSequence);
            object = null;
            n = ((String)charSequence).indexOf(58);
            if (n > 0) {
                object = ((String)charSequence).substring(0, n);
                charSequence = ((String)charSequence).substring(n + 1);
            }
            this.builder.addAttribute((String)charSequence, (String)object, null, (String)object2, "CDATA");
        }
        this.builder.elementAttributesProcessed(string, string2, null);
        if (c == '/') {
            if (XMLUtil.read(this.reader, null, '&', this.entityResolver) != '>') {
                XMLUtil.errorExpectedInput(this.reader.getSystemID(), this.reader.getLineNr(), "`>'");
            }
            this.validator.elementEnded(string, string2, null, this.reader.getSystemID(), this.reader.getLineNr());
            this.builder.endElement(string, string2, null);
            return;
        }
        charSequence = new StringBuffer(16);
        while (true) {
            ((StringBuffer)charSequence).setLength(0);
            object2 = new boolean[1];
            XMLUtil.skipWhitespace(this.reader, '&', (StringBuffer)charSequence, (boolean[])object2);
            c = XMLUtil.read(this.reader, null, '&', this.entityResolver);
            if (c == '<' && object2[0] == false) {
                c = this.reader.read();
                if (c == '/') {
                    XMLUtil.skipWhitespace(this.reader, '&', null, null);
                    object = XMLUtil.scanIdentifier(this.reader, '&', this.entityResolver);
                    if (!((String)object).equals(string)) {
                        XMLUtil.errorWrongClosingTag(this.reader.getSystemID(), this.reader.getLineNr(), string, (String)object);
                    }
                    XMLUtil.skipWhitespace(this.reader, '&', null, null);
                    if (XMLUtil.read(this.reader, null, '&', this.entityResolver) != '>') {
                        XMLUtil.errorClosingTagNotEmpty(this.reader.getSystemID(), this.reader.getLineNr());
                    }
                    break;
                }
                this.reader.unread(c);
                this.scanSomeTag(true);
                continue;
            }
            this.validator.PCDataAdded(this.reader.getSystemID(), this.reader.getLineNr());
            this.reader.unread(c);
            object = new ContentReader(this.reader, this.entityResolver, '&', END_OF_PCDATA, false, ((StringBuffer)charSequence).toString());
            this.builder.addPCData((Reader)object, this.reader.getSystemID(), this.reader.getLineNr());
            ((Reader)object).close();
            this.reader.unread('<');
        }
        this.validator.elementEnded(string, string2, null, this.reader.getSystemID(), this.reader.getLineNr());
        this.builder.endElement(string, string2, null);
    }

    protected void processAttribute() throws Exception {
        String string = XMLUtil.scanIdentifier(this.reader, '&', this.entityResolver);
        XMLUtil.skipWhitespace(this.reader, '&', null, null);
        if (XMLUtil.read(this.reader, null, '&', this.entityResolver) != '=') {
            XMLUtil.errorExpectedInput(this.reader.getSystemID(), this.reader.getLineNr(), "`='");
        }
        String string2 = XMLUtil.scanString(this.reader, '&', true, this.entityResolver);
        this.validator.attributeAdded(string, null, null, string2, this.reader.getSystemID(), this.reader.getLineNr());
        this.builder.addAttribute(string, null, null, string2, "CDATA");
    }
}

