/*
 * Decompiled with CFR 0.152.
 */
package net.n3.nanoxml;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PushbackInputStream;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Stack;
import net.n3.nanoxml.IXMLReader;

public class StdXMLReader
implements IXMLReader {
    private Stack pbreaders;
    private Stack linereaders;
    private Stack systemIds;
    private Stack publicIds;
    private PushbackReader currentPbReader;
    private LineNumberReader currentLineReader;
    private URL currentSystemID;
    private String currentPublicID;

    public static IXMLReader stringReader(String string) {
        return new StdXMLReader(new StringReader(string));
    }

    public static IXMLReader fileReader(String string) throws FileNotFoundException, IOException {
        StdXMLReader stdXMLReader = new StdXMLReader(new FileInputStream(string));
        stdXMLReader.setSystemID(string);
        return stdXMLReader;
    }

    protected void finalize() throws Throwable {
        this.currentLineReader = null;
        this.currentPbReader = null;
        this.pbreaders.clear();
        this.pbreaders = null;
        this.linereaders.clear();
        this.linereaders = null;
        this.publicIds.clear();
        this.publicIds = null;
        this.systemIds.clear();
        this.systemIds = null;
        this.currentPublicID = null;
        super.finalize();
    }

    /*
     * Unable to fully structure code
     */
    protected String getEncoding(String var1_1) {
        if (!var1_1.startsWith("<?xml")) {
            return null;
        }
        var2_2 = 5;
        while (var2_2 < var1_1.length()) {
            var3_3 = new StringBuffer();
            while (var2_2 < var1_1.length() && var1_1.charAt(var2_2) <= ' ') {
                ++var2_2;
            }
            while (var2_2 < var1_1.length() && var1_1.charAt(var2_2) >= 'a' && var1_1.charAt(var2_2) <= 'z') {
                var3_3.append(var1_1.charAt(var2_2));
                ++var2_2;
            }
            while (var2_2 < var1_1.length() && var1_1.charAt(var2_2) <= ' ') {
                ++var2_2;
            }
            if (var2_2 < var1_1.length() && var1_1.charAt(var2_2) == '=') ** GOTO lbl20
            break;
lbl-1000:
            // 1 sources

            {
                ++var2_2;
lbl20:
                // 2 sources

                ** while (var2_2 < var1_1.length() && var1_1.charAt((int)var2_2) != '\'' && var1_1.charAt((int)var2_2) != '\"')
            }
lbl21:
            // 1 sources

            if (var2_2 >= var1_1.length() || (var5_5 = var1_1.indexOf(var4_4 = var1_1.charAt(var2_2), ++var2_2)) < 0) break;
            if (var3_3.toString().equals("encoding")) {
                return var1_1.substring(var2_2, var5_5);
            }
            var2_2 = var5_5 + 1;
        }
        return null;
    }

    protected Reader stream2reader(InputStream inputStream, StringBuffer stringBuffer) throws IOException {
        PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream);
        int n = pushbackInputStream.read();
        switch (n) {
            case 0: 
            case 254: 
            case 255: {
                pushbackInputStream.unread(n);
                return new InputStreamReader((InputStream)pushbackInputStream, "UTF-16");
            }
            case 239: {
                int n2 = 0;
                while (n2 < 2) {
                    pushbackInputStream.read();
                    ++n2;
                }
                return new InputStreamReader((InputStream)pushbackInputStream, "UTF-8");
            }
            case 60: {
                String string;
                n = pushbackInputStream.read();
                stringBuffer.append('<');
                while (n > 0 && n != 62) {
                    stringBuffer.append((char)n);
                    n = pushbackInputStream.read();
                }
                if (n > 0) {
                    stringBuffer.append((char)n);
                }
                if ((string = this.getEncoding(stringBuffer.toString())) == null) {
                    return new InputStreamReader((InputStream)pushbackInputStream, "UTF-8");
                }
                stringBuffer.setLength(0);
                try {
                    return new InputStreamReader((InputStream)pushbackInputStream, string);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    return new InputStreamReader((InputStream)pushbackInputStream, "UTF-8");
                }
            }
        }
        stringBuffer.append((char)n);
        return new InputStreamReader((InputStream)pushbackInputStream, "UTF-8");
    }

    public char read() throws IOException {
        int n = this.currentPbReader.read();
        while (n < 0) {
            if (this.pbreaders.empty()) {
                throw new IOException("Unexpected EOF");
            }
            this.currentPbReader.close();
            this.currentPbReader = (PushbackReader)this.pbreaders.pop();
            this.currentLineReader = (LineNumberReader)this.linereaders.pop();
            this.currentSystemID = (URL)this.systemIds.pop();
            this.currentPublicID = (String)this.publicIds.pop();
            n = this.currentPbReader.read();
        }
        if (n == 13 && (n = (int)this.read()) != 10) {
            this.currentPbReader.unread(n);
            return '\n';
        }
        return (char)n;
    }

    public boolean atEOFOfCurrentStream() throws IOException {
        int n = this.currentPbReader.read();
        if (n < 0) {
            return true;
        }
        this.currentPbReader.unread(n);
        return false;
    }

    public boolean atEOF() throws IOException {
        int n = this.currentPbReader.read();
        while (n < 0) {
            if (this.pbreaders.empty()) {
                return true;
            }
            this.currentPbReader.close();
            this.currentPbReader = (PushbackReader)this.pbreaders.pop();
            this.currentLineReader = (LineNumberReader)this.linereaders.pop();
            this.currentSystemID = (URL)this.systemIds.pop();
            this.currentPublicID = (String)this.publicIds.pop();
            n = this.currentPbReader.read();
        }
        this.currentPbReader.unread(n);
        return false;
    }

    public void unread(char c) throws IOException {
        this.currentPbReader.unread(c);
    }

    public Reader openStream(String string, String string2) throws MalformedURLException, FileNotFoundException, IOException {
        URL uRL = new URL(this.currentSystemID, string2);
        StringBuffer stringBuffer = new StringBuffer();
        Reader reader = this.stream2reader(uRL.openStream(), stringBuffer);
        if (stringBuffer.length() == 0) {
            return reader;
        }
        String string3 = stringBuffer.toString();
        PushbackReader pushbackReader = new PushbackReader(reader, string3.length());
        int n = string3.length() - 1;
        while (n >= 0) {
            pushbackReader.unread(string3.charAt(n));
            --n;
        }
        return pushbackReader;
    }

    public void startNewStream(Reader reader) {
        this.pbreaders.push(this.currentPbReader);
        this.linereaders.push(this.currentLineReader);
        this.systemIds.push(this.currentSystemID);
        this.publicIds.push(this.currentPublicID);
        this.currentLineReader = new LineNumberReader(reader);
        this.currentPbReader = new PushbackReader(this.currentLineReader, 2);
    }

    public int getLineNr() {
        return this.currentLineReader.getLineNumber() + 1;
    }

    public void setSystemID(String string) throws MalformedURLException {
        this.currentSystemID = new URL(this.currentSystemID, string);
    }

    public void setPublicID(String string) {
        this.currentPublicID = string;
    }

    public String getSystemID() {
        return this.currentSystemID.toString();
    }

    public String getPublicID() {
        return this.currentPublicID;
    }

    public StdXMLReader(String string, String string2) throws MalformedURLException, FileNotFoundException, IOException {
        URL uRL = null;
        try {
            uRL = new URL(string2);
        }
        catch (MalformedURLException malformedURLException) {
            string2 = "file:" + string2;
            try {
                uRL = new URL(string2);
            }
            catch (MalformedURLException malformedURLException2) {
                throw malformedURLException;
            }
        }
        Reader reader = this.openStream(string, uRL.toString());
        this.currentLineReader = new LineNumberReader(reader);
        this.currentPbReader = new PushbackReader(this.currentLineReader, 2);
        this.pbreaders = new Stack();
        this.linereaders = new Stack();
        this.publicIds = new Stack();
        this.systemIds = new Stack();
        this.currentPublicID = string;
        this.currentSystemID = uRL;
    }

    public StdXMLReader(Reader reader) {
        this.currentLineReader = new LineNumberReader(reader);
        this.currentPbReader = new PushbackReader(this.currentLineReader, 2);
        this.pbreaders = new Stack();
        this.linereaders = new Stack();
        this.publicIds = new Stack();
        this.systemIds = new Stack();
        this.currentPublicID = "";
        try {
            this.currentSystemID = new URL("file:.");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public StdXMLReader(InputStream inputStream) throws IOException {
        PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream);
        StringBuffer stringBuffer = new StringBuffer();
        Reader reader = this.stream2reader(inputStream, stringBuffer);
        this.currentLineReader = new LineNumberReader(reader);
        this.currentPbReader = new PushbackReader(this.currentLineReader, 2);
        this.pbreaders = new Stack();
        this.linereaders = new Stack();
        this.publicIds = new Stack();
        this.systemIds = new Stack();
        this.currentPublicID = "";
        try {
            this.currentSystemID = new URL("file:.");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        this.startNewStream(new StringReader(stringBuffer.toString()));
    }
}

