# SPEC file for packages libest2 and libest2-devel
# Usage: rpmbuild -bb libest2.spec
#
# You may have to create/change your ~/.rpmmacros
# http://rpm5.org/docs/api/macros.html
#
# Here is my ~/.rpmmacros which has only a single line:
# %_topdir        /home/meolic/libest2/rpm
#
# This file has been constructed using the following examples:
#
# http://www.rpm-based.org/how-to-create-rpm-package
# http://www.rpm.org/max-rpm/
# http://kmymoney2.sourceforge.net/phb/rpm-example.html
# http://dries.ulyssis.org/apt/packages/gnunet/gnunet-spec.html
#

Name: libest2
Requires: libbiddy1
Summary: Efficient Symbolic Tools 2nd Edition
Version: THISVERSION
Release: THISRELEASE
License: GPL
Group: Other
URL: http://lms.uni-mb.si/EST/
Source: libest2-%{version}.tar.gz
BuildRoot: %{_tmppath}/%{name}
Packager: meolic

%description
EST is a tool for the formal verification of systems.

 EST is a collection of symbolic algorithms based on binary decision diagrams (BDDs).
Curently, it supports only our own BDD package called Biddy, but one day it could
support other BDD packages, too.

 EST provides libraries of functions, which you can use in your own main program.

http://lms.uni-mb.si/EST/

%package devel
Requires: libbiddy1, libest2 = %{version}-%{release}
Summary: Efficient Symbolic Tools 2nd Edition (development files)
Group: Other

%description devel
EST is a tool for the formal verification of systems.

 EST is a collection of symbolic algorithms based on binary decision diagrams (BDDs).
Curently, it supports only our own BDD package called Biddy, but one day it could
support other BDD packages, too.

 EST provides libraries of functions, which you can use in your own main program.

http://lms.uni-mb.si/EST/

This package contains the development headers, only.

%prep
echo "Preparing %{name}-%{version}-%{release}"
%setup -q
echo "Sources OK. Let's go building!"

%build
%{__make} lib "BINDIR=`pwd`/bin"
%{__make} clean "BINDIR=`pwd`/bin"
%{__make} staticlib "BINDIR=`pwd`/bin"

%define _sharedir %{_prefix}/share

%install
%{__rm} -rf %{buildroot}
%{__make} -f Makefile.Linux DESTDIR=%{buildroot}/usr installlib "BINDIR=`pwd`/bin"
%{__make} -f Makefile.Linux DESTDIR=%{buildroot}/usr installlibdev "BINDIR=`pwd`/bin"

%clean
%{__rm} -rf %{buildroot}

%files
%defattr(-, root, root, 0755)
%doc VERSION CHANGES
%{_libdir}/libest2.so.%{version}
%{_libdir}/libest2.so.5
%{_sharedir}/libest2/README

%files devel
%defattr(-, root, root, 0755)
%{_includedir}/est2ed/
%{_libdir}/libest2.a
%{_libdir}/libest2.so

%changelog
