/**CFile*******************************************************************
  PackageName [ccs]
  Synopsis    [Package 'ccs' provides an extended CCS parser.]

  FileName    [ccsMain.c]
  Revision    [$Revision: 53 $]
  Date        [$Date: 2012-05-16 11:42:47 +0200 (sre, 16 maj 2012) $]
  Authors     [Robert Meolic (meolic@uni-mb.si)]
  Description [File ccsMain.c contains main functions.]
  SeeAlso     [ccs.h, ccsInt.h]

  Copyright   [This file is part of EST (Efficient Symbolic Tools).
               Copyright (C) 2003, 2012
               UM-FERI, Smetanova ulica 17, SI-2000 Maribor, Slovenia

               EST is free software; you can redistribute it and/or modify
               it under the terms of the GNU General Public License as
               published by the Free Software Foundation; either version 2
               of the License, or (at your option) any later version.

               EST is distributed in the hope that it will be useful,
               but WITHOUT ANY WARRANTY; without even the implied warranty of
               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
               GNU General Public License for more details.

               You should have received a copy of the GNU General Public
               License along with this program; if not, write to the Free
               Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
               Boston, MA 02110-1301 USA.]
  ************************************************************************/

#include "ccsInt.h"

/*-----------------------------------------------------------------------*/
/* Variable declarations                                                 */
/*-----------------------------------------------------------------------*/

/* EXPORTED VARIABLES */

int ccs_status = 0;                     /* initialization status */

/* INTERNAL VARIABLES */

/* used and not initialized by flex/bison */
char *ccstext = NULL; /* from lex.ccs.c */
void *ccsleng = NULL; /* from lex.ccs.c */
int ccsnerrs = 0;     /* from ccs.tab.c: number of syntax errors so far */
int ccschar = 0;      /* from ccs.tab.c: the lookahead symbol */
struct ccsstype {void *i1; void *i2;} ccslval = {NULL, NULL};
   /* the semantic value of the lookahead symbol */
   /* this should be compatible with the union from ccsParser.y */

/* used and not initialized by flex/bison */
char *verilogtext = NULL; /* from lex.verilog.c */
void *verilogleng = NULL; /* from lex.verilog.c */
int verilognerrs = 0;     /* from verilog.tab.c: number of syntax errors so far */
int verilogchar = 0;      /* from verilog.tab.c: the lookahead symbol */
struct verilogstype {void *i1;} veriloglval = {NULL};
   /* the semantic value of the lookahead symbol */
   /* this should be compatible with the union from ccsVerilog.y */

/**AutomaticStart*********************************************************/

/*-----------------------------------------------------------------------*/
/* Static function prototypes                                            */
/*-----------------------------------------------------------------------*/

/**AutomaticEnd***********************************************************/

/*-----------------------------------------------------------------------*/
/* Definition of exported functions                                      */
/*-----------------------------------------------------------------------*/

/**Function****************************************************************
  Synopsis    []
  Description []
  SideEffects []
  SeeAlso     []
  ************************************************************************/

#ifndef TCLOUT
   void Ccs_Init(void) {}
#endif

/**Function****************************************************************
  Synopsis    [Function Ccs_InitPkg.]
  Description []
  SideEffects []
  SeeAlso     []
  ************************************************************************/

void
Ccs_InitPkg()
{
  if (ccs_status == 1) {
    printf("\nCCS package is already initialized. ");
    return;
  } else {
    ccs_status = 1;
  }

  return;
}

/**Function****************************************************************
  Synopsis    [Function Ccs_ExitPkg.]
  Description []
  SideEffects []
  SeeAlso     []
  ************************************************************************/

void
Ccs_ExitPkg()
{
  if (ccs_status == 0) {
    printf("\nCCS package is not initialized. ");
    return;
  } else {
    ccs_status = 0;
  }

}

/**Function****************************************************************
  Synopsis    [Function Ccs_AboutPkg]
  Description [Ccs_AboutPkg reports release of CCS package.]
  SideEffects []
  SeeAlso     []
  ************************************************************************/

void
Ccs_AboutPkg()
{
  printf("EST ");
  printf(EDITION);
  printf(", version ");
  printf(VERSION);
  printf(", ");
  printf("CCS package");
  printf("\n");
}


/*-----------------------------------------------------------------------*/
/* Definition of internal functions                                      */
/*-----------------------------------------------------------------------*/


/*-----------------------------------------------------------------------*/
/* Definition of static functions                                        */
/*-----------------------------------------------------------------------*/
