/**CFile*******************************************************************
  PackageName [est]
  Synopsis    [EST 2nd Edition]

  FileName    [est2ed.c]
  Revision    [$Revision: 61 $]
  Date        [$Date: 2012-07-05 14:18:15 +0200 (čet, 05 jul 2012) $]
  Authors     [Robert Meolic (meolic@uni-mb.si)]
  Description [File est2ed.c initializes and start Tcl/Tk GUI.]
  SeeAlso     [est2ed.tcl]

  Copyright   [This file is part of EST (Efficient Symbolic Tools).
               Copyright (C) 2003, 2012
               UM-FERI, Smetanova ulica 17, SI-2000 Maribor, Slovenia

               EST is free software; you can redistribute it and/or modify
               it under the terms of the GNU General Public License as
               published by the Free Software Foundation; either version 2
               of the License, or (at your option) any later version.

               EST is distributed in the hope that it will be useful,
               but WITHOUT ANY WARRANTY; without even the implied warranty of
               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
               GNU General Public License for more details.

               You should have received a copy of the GNU General Public
               License along with this program; if not, write to the Free
               Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
               Boston, MA 02110-1301 USA.]
  ************************************************************************/

#undef USE_TCL_STUBS

#include <stdio.h>
#include <stdlib.h>
#include <tcl.h>
#include <tk.h>

int AppInit(Tcl_Interp *interp) {

  if(Tcl_Init(interp) == TCL_ERROR) return TCL_ERROR;
  Tk_InitConsoleChannels(interp);
  if(Tk_Init(interp) == TCL_ERROR) return TCL_ERROR;
  Tcl_Eval(interp,"set auto_path [linsert $auto_path 0 [file dirname [info nameofexecutable]]]");
  Tcl_PkgRequire(interp,"est2ed","1",0);
  return TCL_OK;
}

int main(int argc, char *argv[]) {
  Tk_Main(argc, argv, AppInit);
  return 0;
}
