/**CHeaderFile*************************************************************
  PackageName [strucval]
  Synopsis    [Structure-driven validation of hardware and software systems]

  FileName    [strucval.h]
  Revision    [$Revision: 53 $]
  Date        [$Date: 2012-05-16 11:42:47 +0200 (sre, 16 maj 2012) $]
  Authors     [Robert Meolic (meolic@uni-mb.si)]
  Description [File strucval.h contains declaration of all external
               data structures.]
  SeeAlso     [strucvalInt.h]

  Copyright   [This file is part of EST (Efficient Symbolic Tools).
               Copyright (C) 2003, 2012
               UM-FERI, Smetanova ulica 17, SI-2000 Maribor, Slovenia

               EST is free software; you can redistribute it and/or modify
               it under the terms of the GNU General Public License as
               published by the Free Software Foundation; either version 2
               of the License, or (at your option) any later version.

               EST is distributed in the hope that it will be useful,
               but WITHOUT ANY WARRANTY; without even the implied warranty of
               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
               GNU General Public License for more details.

               You should have received a copy of the GNU General Public
               License along with this program; if not, write to the Free
               Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
               Boston, MA 02110-1301 USA.]
  ************************************************************************/

#ifndef _STRUCVAL
#define _STRUCVAL

#include <est.h>
#include <bdd.h>
#include <pa.h>
#include <versis.h>
#include <mc.h>

/* ON WIN32 THERE HAS TO BE DEFINED ESTWIN32 */
/* ON UNIX THERE HAS TO BE DEFINED ESTUNIX */
/* ON MACOSX THERE HAS TO BE DEFINED ESTMACOSX */

#ifdef ESTUNIX
#  ifndef EXTERN
#    define EXTERN extern
#  endif
#endif

#ifdef ESTMACOSX
#  ifndef EXTERN
#    define EXTERN extern
#  endif
#endif

#ifdef ESTWIN32
#  ifdef TCL
#    undef EXTERN
#    define EXTERN extern
#  else
#    if defined(BUILD_EST) || defined(BUILD_STRUCVAL)
#      undef EXTERN
#      define EXTERN __declspec (dllexport)
#    else
#      if defined(USE_EST) || defined(USE_STRUCVAL)
#        undef EXTERN
#        define EXTERN __declspec (dllimport)
#      else
#        undef EXTERN
#        define EXTERN extern
#      endif
#    endif
#  endif
#endif

/*-----------------------------------------------------------------------*/
/* Constant declarations                                                 */
/*-----------------------------------------------------------------------*/

/*-----------------------------------------------------------------------*/
/* Type declarations                                                     */
/*-----------------------------------------------------------------------*/

/*-----------------------------------------------------------------------*/
/* Structure declarations                                                */
/*-----------------------------------------------------------------------*/

/*-----------------------------------------------------------------------*/
/* Variable declarations                                                 */
/*-----------------------------------------------------------------------*/

EXTERN int strucval_status;

/*-----------------------------------------------------------------------*/
/* Macro declarations                                                    */
/*-----------------------------------------------------------------------*/

/**AutomaticStart*********************************************************/

/*-----------------------------------------------------------------------*/
/* Function prototypes                                                   */
/*-----------------------------------------------------------------------*/

/*-----------------------------------------------------------------------*/
/* strucvalMain.c                                                        */
/*-----------------------------------------------------------------------*/

EXTERN void Strucval_InitPkg();

EXTERN void Strucval_ExitPkg();

EXTERN void Strucval_AboutPkg();

EXTERN void Strucval_SyncProduct(Est_String name, Est_String lts,
				 Est_String wca, Est_String actions);

/**AutomaticEnd***********************************************************/

#endif  /* _STRUCVAL */

