global MENU
global MENUITEMS
global MENUBG
global MENUFG

set MENUTEST $MENU.test
menu $MENUTEST -activeborderwidth 1 -activebackground #ffffc0 -activeforeground #000040 -font MENUFONT -relief groove -borderwidth 4 -tearoff false
$MENU insert [expr [$MENU index last]] cascade -menu $MENUTEST -activebackground #ffffc0 -activeforeground #000040 -font MENUFONT -label "Test"

$MENUTEST add command -command menu_test_testFile -label "testFile"
$MENUTEST add command -command menu_test_testTerm -label "testTerm"
$MENUTEST add command -command menu_test_testParam -label "testParam"

lappend MENUITEMS $MENUTEST
refresh

proc menu_test_testFile {  } {
    global NAME
    global SYNOPSIS
    global SYNTAX
    global EXAMPLE
    global EXPLANATION
    global BROWSE
    global CMD
    global CMDEND

    set NAME "fileBrowse"
    set SYNOPSIS ""
    set SYNTAX ""
    set EXAMPLE ""
    set EXPLANATION ""
    set BROWSE [list \
      {file "Select file" {{{Internal format} {.*}}}} \
    ]

    set CMD "outline"
    set CMDEND ""

    commonDialog
}

proc menu_test_testTerm {  } {
    global NAME
    global SYNOPSIS
    global SYNTAX
    global EXAMPLE
    global EXPLANATION
    global BROWSE
    global CMD
    global CMDEND

    set NAME "termBrowse"
    set SYNOPSIS ""
    set SYNTAX ""
    set EXAMPLE ""
    set EXPLANATION ""
    set BROWSE [list \
      {boolean "Boolean value"} \
      {term "Logic value" "0 1"} \
    ]

    set CMD "outline \[list"
    set CMDEND "\]"

    commonDialog
}

proc menu_test_testParam {  } {
    global NAME
    global SYNOPSIS
    global SYNTAX
    global EXAMPLE
    global EXPLANATION
    global BROWSE
    global CMD
    global CMDEND

    set PARAM ""
    set PARAM "\$Saturday"
    set PARAM "$PARAM | \$Sunday"
    set PARAM "{\[expr $PARAM\]}"

    set NAME "termParam"
    set SYNOPSIS ""
    set SYNTAX ""
    set EXAMPLE ""
    set EXPLANATION ""

    set BROWSE [list \
      {optional "Optional value" 30 0} \
      [concat {optional "Optional value" 30} $PARAM] \
      {required "Required value" 30} \
      {nonempty "Nonempty value" 30} \
    ]

    set CMD "outline \[list"
    set CMDEND "\]"

    commonDialog
}
