#  Authors     [Robert Meolic (meolic@uni-mb.si)]
#  Revision    [$Revision: 76 $]
#  Date        [$Date: 2013-04-26 14:26:09 +0200 (pet, 26 apr 2013) $]
#
#  Copyright   [This file is part of EST (Efficient Symbolic Tools).
#               Copyright (C) 2003, 2013
#               UM-FERI, Smetanova ulica 17, SI-2000 Maribor, Slovenia
#
#               EST is free software; you can redistribute it and/or modify
#               it under the terms of the GNU General Public License as
#               published by the Free Software Foundation; either version 2
#               of the License, or (at your option) any later version.
#
#               EST is distributed in the hope that it will be useful,
#               but WITHOUT ANY WARRANTY; without even the implied warranty of
#               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
#               GNU General Public License for more details.
#
#               You should have received a copy of the GNU General Public
#               License along with this program; if not, write to the Free
#               Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
#               Boston, MA 02110-1301 USA.]

global MENU
global MENUITEMS
global MENUBG
global MENUFG

set MENUCCS $MENU.ccs
menu $MENUCCS -activeborderwidth 1 -activebackground #ffffc0 -activeforeground #000040 -font MENUFONT -relief groove -borderwidth 4 -tearoff false
$MENU insert [expr [$MENU index last]] cascade -menu $MENUCCS -activebackground #ffffc0 -activeforeground #000040 -font MENUFONT -label "CCS"

$MENUCCS add command -command menu_ccs_read -label "ccs_read"
$MENUCCS add command -command menu_ccs_convert_verilog -label "ccs_convert_verilog"
$MENUCCS add separator
$MENUCCS add command -command ccs_about -label "ccs_about"

lappend MENUITEMS $MENUCCS
refresh

proc ccs_about {  } {
    global BINDIR

    outline ""
    outline "\#\#\# "
    out "\# "
    ccs_aboutPkg

    set OK ""
    if {[file isfile "/usr/lib/est2ed/ccs.about"]} {
      set OK "OK"
      set f [open "/usr/lib/est2ed/ccs.about" r]
    } else {
      if {[file isfile "$BINDIR/ccs.about"]} {
        set OK "OK"
        set f [open "$BINDIR/ccs.about" r]
      }
    }

    if { $OK == "OK"} {
      while {[gets $f line] >= 0} {
        out "\# "
        outline $line
      }
      outline "\#\#\# "
      close $f
    }
}

# ##########################################################
# FIELD1: Initial string/value
# FIELD2: List of arguments/values (where applicable)
#
# BROWSE types defined in mi.tcl
#
# file%s        filename
# boolean%s     false or true
# term%s        list of given terminals
# optional%s    optional parameter, can be left out
# required%s    required parameter, if empty then use ""
# nonempty%s    required parameter, must not be equal to ""
#
# BROWSE types defined in paDialog.tcl
#
# name%s        sort/process/composition name
# list%s        list of sorts/processes/compositions
#
# BROWSE types defined in versisDialog.tcl
#
# comtype%d     composition type
#
# BROWSE types defined in mcDialog.tcl
#
# form%s        formula
#
# ##########################################################

proc menu_ccs_read {  } {
    global NAME
    global SYNOPSIS
    global SYNTAX
    global EXAMPLE
    global EXPLANATION
    global BROWSE
    global CMD
    global CMDEND

    set NAME "ccs_read"
    set SYNOPSIS "Read CCS file."
    set SYNTAX "fname%s"
    set EXAMPLE "ccs_read philo/philo.ccs"
    set EXPLANATION "Read file ./philo/philo.ccs"
    set BROWSE [list \
        {file "Select file with CCS model" {{{CCS model} {.ccs}} {{All files} {*.*}}}} \
    ]

    set CMD $NAME
    set CMDEND ""

    commonDialog
}

proc menu_ccs_convert_verilog {  } {
    global NAME
    global SYNOPSIS
    global SYNTAX
    global EXAMPLE
    global EXPLANATION
    global BROWSE
    global CMD
    global CMDEND

    set NAME "ccs_convert_verilog"
    set SYNOPSIS "Read Verilog netlist and represent it with CCS."
    set SYNTAX "fname%s"
    set EXAMPLE "ccs_convert_verilog iscas85/c17.v"
    set EXPLANATION "Convert Verilog netlist from file ./iscas85/c17.v"
    set BROWSE [list \
        {file "Select file with Verilog netlist" {{{CCS model} {.v}} {{All files} {*.*}}}} \
        {nonempty "Output file" 60} \
    ]

    set CMD $NAME
    set CMDEND ""

    commonDialog
}
