
# This is a TCL script file. First line must be empty.
# $Revision: 21 $
# $Date: 2013-03-25 10:16:58 +0100 (pon, 25 mar 2013) $

# Some explanation of menu system
# http://www.tkdocs.com/tutorial/menus.html

global MENU
global MENUITEMS
global MENUBG
global MENUFG

set MENUINTERFACE $MENU.interface
menu $MENUINTERFACE -activeborderwidth 1 -activebackground #ffffc0 -activeforeground #000040 -font MENUFONT -relief groove -borderwidth 4 -tearoff false
$MENU add cascade -menu $MENUINTERFACE -activebackground #ffffc0 -activeforeground #000040 -font MENUFONT -label "Interface"

$MENUINTERFACE add command -command menu_interface_source -label "source"
$MENUINTERFACE add command -command menu_interface_xsource -label "xsource"
$MENUINTERFACE add command -command menu_interface_xxsource -label "xxsource"
$MENUINTERFACE add separator
$MENUINTERFACE add command -command menu_interface_printLog -label "Print Log"
$MENUINTERFACE add command -command menu_interface_printSelection -label "Print Selection"
$MENUINTERFACE add separator
$MENUINTERFACE add command -command menu_interface_fonts -label "Fonts..."
$MENUINTERFACE add command -command menu_interface_colors -label "Colors..."
$MENUINTERFACE add separator
$MENUINTERFACE add command -command exit -label "Exit"

lappend MENUITEMS $MENUINTERFACE

set MENUHELP $MENU.help
menu $MENUHELP -activeborderwidth 1 -activebackground #ffffc0 -activeforeground #000040 -font MENUFONT -relief groove -borderwidth 4 -tearoff false
$MENU add cascade -menu $MENUHELP -activebackground #ffffc0 -activeforeground #000040 -font MENUFONT -label "Help"

$MENUHELP add command -command license -label "License"

lappend MENUITEMS $MENUHELP

# update colors in new menus
refresh

proc menu_interface_source {  } {
    global PROMPT
    global INPUTWINDOW

    set types {
      {"Tcl Scripts" {.tcl}}
      {"All files" *}
    }
    set filename [tk_getOpenFile -filetypes $types]
    if {$filename != ""} {
      set l "cd \"[file dirname $filename]\"; source \"[file tail $filename]\"; cd \"[pwd]\""
      $INPUTWINDOW insert insert "$l\n"
      $INPUTWINDOW insert insert $PROMPT
      $INPUTWINDOW see insert
      $INPUTWINDOW mark set limit insert
      evalCommand $l
    }
}

proc menu_interface_xsource {  } {
    global PROMPT
    global INPUTWINDOW

    set types {
      {"Tcl Scripts" {.tcl}}
      {"All files" *}
    }
    set filename [tk_getOpenFile -filetypes $types]
    if {$filename != ""} {
      #set l "xsource \"$filename\""
      set l "cd \"[file dirname $filename]\"; xsource \"[file tail $filename]\"; cd \"[pwd]\""
      $INPUTWINDOW insert insert "$l\n"
      $INPUTWINDOW insert insert $PROMPT
      $INPUTWINDOW see insert
      $INPUTWINDOW mark set limit insert
      evalCommand $l
    }
}

proc menu_interface_xxsource {  } {
    global PROMPT
    global INPUTWINDOW

    set types {
      {"Tcl Scripts" {.tcl}}
      {"All files" *}
    }
    set filename [tk_getOpenFile -filetypes $types]
    if {$filename != ""} {
      #set l "xsource \"$filename\""
      set l "cd \"[file dirname $filename]\"; xxsource \"[file tail $filename]\"; cd \"[pwd]\""
      $INPUTWINDOW insert insert "$l\n"
      $INPUTWINDOW insert insert $PROMPT
      $INPUTWINDOW see insert
      $INPUTWINDOW mark set limit insert
      evalCommand $l
    }
}

proc menu_interface_printLog {  } {
    global NAME
    global SYNOPSIS
    global SYNTAX
    global EXAMPLE
    global EXPLANATION
    global BROWSE
    global CMD
    global CMDEND
    global PARAM

    set NAME "print_log"
    set SYNOPSIS "Print text in output window."
    set SYNTAX "print_log"
    set EXAMPLE "print_log"
    set EXPLANATION "Print output window"

    set BROWSE [list ]

    set CMD $NAME
    set CMDEND ""
    set PARAM ""

    commonDialog

}

proc menu_interface_printSelection {  } {
    global NAME
    global SYNOPSIS
    global SYNTAX
    global EXAMPLE
    global EXPLANATION
    global BROWSE
    global CMD
    global CMDEND
    global PARAM

    set NAME "print_selection"
    set SYNOPSIS "Print selected text."
    set SYNTAX "print_selection"
    set EXAMPLE "print_selection"
    set EXPLANATION "Print currently selected text"

    set BROWSE [list ]

    set CMD $NAME
    set CMDEND ""
    set PARAM ""

    commonDialog
}

proc menu_interface_colors {  } {
  changeColors
}

proc menu_interface_fonts {  } {
  changeFonts
}

# ##########################################################
# ##########################################################

variable timerStack {}
proc timerEnter {cmd op} {
    variable timerStack
    lappend timerStack [clock milliseconds]
}

#verbose
proc timerLeave {cmd code result op} {
    variable timerStack
    set now [clock milliseconds]
    set then [lindex $timerStack end]
    set timerStack [lrange $timerStack 0 end-1]
    if {[llength $timerStack] < 1 &&
        ![string equal -length 3 $cmd "out"] &&
        ![string equal -length 3 $cmd "set"] &&
        ![string equal -length 4 $cmd "proc"]
    } {
      outline "\[CPU\]$cmd\[CPU: [expr {$now-$then}]ms\]"
    }
}

#very verbose!
proc timerLeaveX {cmd code result op} {
    variable timerStack
    set now [clock milliseconds]
    set then [lindex $timerStack end]
    set timerStack [lrange $timerStack 0 end-1]
    if {![string equal -length 3 $cmd "out"] &&
        ![string equal -length 4 $cmd "proc"]
    } {
      outline "\[CPU\]$cmd\[CPU: [expr {$now-$then}]ms\]"
    }
}

proc xsource fileName {
    global tcl_version

    if {$tcl_version < "8.5"} {
      outline "Error: xsource requires TCL version 8.5 (this is $tcl_version)"
      return
    }

    #This is from StackOverflow (thanks to Donal Fellows)
    trace add execution source enterstep timerEnter
    trace add execution source leavestep timerLeave

    source "$fileName"
    #use this for argument rewriting
    #source [set argv [lassign $argv argv0];set argv0]

    trace remove execution source enterstep timerEnter
    trace remove execution source leavestep timerLeave

    return
}

proc xxsource fileName {
    global tcl_version

    if {$tcl_version < "8.5"} {
      outline "Error: xxsource requires TCL version 8.5 (this is $tcl_version)"
      return
    }

    #This is from StackOverflow (thanks to Donal Fellows)
    trace add execution source enterstep timerEnter
    trace add execution source leavestep timerLeaveX

    source "$fileName"
    #use this for argument rewriting
    #source [set argv [lassign $argv argv0];set argv0]

    trace remove execution source enterstep timerEnter
    trace remove execution source leavestep timerLeaveX

    return
}

proc changeColors {  } {
    global MENUFG
    global MENUBG
    global INPUTFG
    global INPUTBG
    global OUTPUTFG
    global OUTPUTBG

    toplevel .interfaceColors -background $OUTPUTBG -highlightbackground $OUTPUTBG -highlightcolor $OUTPUTBG -highlightthickness 4
    wm title .interfaceColors {Colors}
    wm iconname .interfaceColors {Colors}
    wm resizable .interfaceColors false false
    grab set .interfaceColors

    frame .interfaceColors.menu -background $MENUBG -borderwidth 2 -highlightthickness 0 -relief raised
    pack .interfaceColors.menu -fill x -pady 4
    button .interfaceColors.menu.bg -activebackground $MENUBG -activeforeground $MENUFG -background $MENUBG -borderwidth 0 -command {
      set c [tk_chooseColor -parent .interfaceColors -initialcolor $MENUBG -title "Menu Background"]
      if {$c != ""} {
        .interfaceColors.menu.bg configure -bg $c
        .interfaceColors.menu.fg configure -bg $c
        .interfaceColors.menu configure -background $c
        .interfaceColors.menu.bg configure -activebackground $c
        .interfaceColors.menu.fg configure -activebackground $c
      }
    } -font FONT -foreground $MENUFG -highlightthickness 0 -relief flat -text "Menu Background" -width 18
    pack .interfaceColors.menu.bg -side left
    button .interfaceColors.menu.fg -activebackground $MENUBG -activeforeground $MENUFG -background $MENUBG -borderwidth 0 -command {
      set c [tk_chooseColor -parent .interfaceColors -initialcolor $MENUFG -title "Menu Foreground"]
      if {$c != ""} {
       .interfaceColors.menu.bg configure -fg $c
       .interfaceColors.menu.fg configure -fg $c
       .interfaceColors.menu.bg configure -activeforeground $c
       .interfaceColors.menu.fg configure -activeforeground $c
      }
    } -font FONT -foreground $MENUFG -highlightthickness 0 -relief flat -text "Menu Foreground" -width 18
    pack .interfaceColors.menu.fg -side right
    frame .interfaceColors.output -background $OUTPUTBG -borderwidth 0 -highlightthickness 0 -relief flat
    pack .interfaceColors.output -fill x
    scrollbar .interfaceColors.output.ys -borderwidth 0 -highlightthickness 0 -orient vertical
    pack .interfaceColors.output.ys -fill y -side right
    button .interfaceColors.output.bg -activebackground $OUTPUTBG -activeforeground $OUTPUTFG -background $OUTPUTBG -borderwidth 0 -command {
      set c [tk_chooseColor -parent .interfaceColors -initialcolor $OUTPUTBG -title "Output Background"]
      if {$c != ""} {
        .interfaceColors.output.bg configure -bg $c
        .interfaceColors.output.fg configure -bg $c
        .interfaceColors.output configure -background $c
        .interfaceColors configure -background $c
        .interfaceColors configure -highlightbackground $c
        .interfaceColors configure -highlightcolor $c
        .interfaceColors.output.bg configure -activebackground $c
        .interfaceColors.output.fg configure -activebackground $c
        .interfaceColors.buttons configure -background $c
        .interfaceColors.buttons.scheme configure -background $c
        .interfaceColors.buttons.scheme.label configure -background $c
      }
    } -font FONT -foreground $OUTPUTFG -height 4 -highlightthickness 0 -relief flat -text "Output Background" -width 18
    pack .interfaceColors.output.bg -side left
    button .interfaceColors.output.fg -activebackground $OUTPUTBG -activeforeground $OUTPUTFG -background $OUTPUTBG -borderwidth 0 -command {
      set c [tk_chooseColor -parent .interfaceColors -initialcolor $OUTPUTFG -title "Output Foreground"]
      if {$c != ""} {
        .interfaceColors.output.bg configure -fg $c
        .interfaceColors.output.fg configure -fg $c
        .interfaceColors.buttons.scheme.label configure -foreground $c
        .interfaceColors.output.bg configure -activeforeground $c
        .interfaceColors.output.fg configure -activeforeground $c
      }
    } -font FONT -foreground $OUTPUTFG -height 4 -highlightthickness 0 -relief flat -text "Output Foreground" -width 18
    pack .interfaceColors.output.fg -side right
    frame .interfaceColors.input -background $INPUTBG -borderwidth 1 -highlightthickness 0 -relief solid
    pack .interfaceColors.input -fill x -pady 4
    button .interfaceColors.input.bg -activebackground $INPUTBG -activeforeground $INPUTFG -background $INPUTBG -borderwidth 0 -command {
      set c [tk_chooseColor -parent .interfaceColors -initialcolor $INPUTBG -title "Input Background"]
      if {$c != ""} {
       .interfaceColors.input.bg configure -bg $c
       .interfaceColors.input.fg configure -bg $c
       .interfaceColors.input configure -background $c
       .interfaceColors.input.bg configure -activebackground $c
       .interfaceColors.input.fg configure -activebackground $c
      }
    } -font FONT -foreground $INPUTFG -highlightthickness 0 -relief flat -text "Input Background" -width 18
    pack .interfaceColors.input.bg -side left
    button .interfaceColors.input.fg -activebackground $INPUTBG -activeforeground $INPUTFG -background $INPUTBG -borderwidth 0 -command {
      set c [tk_chooseColor -parent .interfaceColors -initialcolor $INPUTFG -title "Input Foreground"]
      if {$c != ""} {
       .interfaceColors.input.bg configure -fg $c
       .interfaceColors.input.fg configure -fg $c
       .interfaceColors.input.bg configure -activeforeground $c
       .interfaceColors.input.fg configure -activeforeground $c
      }
    } -font FONT -foreground $INPUTFG -highlightthickness 0 -relief flat -text "Input Foreground" -width 18
    pack .interfaceColors.input.fg -side right
    frame .interfaceColors.buttons -background $OUTPUTBG
    pack .interfaceColors.buttons -ipady 10 -side bottom
    frame .interfaceColors.buttons.scheme -background $OUTPUTBG
    pack .interfaceColors.buttons.scheme -padx 20 -side left
    image create photo BOX_GREEN -height 12 -width 12
    image create photo BOX_GRAY -height 12 -width 12
    image create photo BOX_BLUE -height 12 -width 12
    image create photo BOX_ORANGE -height 12 -width 12
    image create photo BOX_WHITE -height 12 -width 12
    image create photo BOX_LIGHTBLUE -height 12 -width 12
    image create photo BOX_DARKBLUE -height 12 -width 12

    BOX_GREEN put #408080 -to 0 0 12 12
    BOX_GRAY put #c0c0c0 -to 0 0 12 12
    BOX_BLUE put #4864a7 -to 0 0 12 12
    BOX_ORANGE put #ffdab9 -to 0 0 12 12
    BOX_WHITE put #ffffff -to 0 0 12 12
    BOX_LIGHTBLUE put #80ffff -to 0 0 12 12
    BOX_DARKBLUE put #005090 -to 0 0 12 12

    label .interfaceColors.buttons.scheme.label -background $OUTPUTBG -font FONT -foreground $OUTPUTFG -text "Show scheme:"
    pack .interfaceColors.buttons.scheme.label
    button .interfaceColors.buttons.scheme.schemeGreen -background #c0c0c0 -borderwidth 1 -command {
      .interfaceColors.menu.bg configure -bg #008080
      .interfaceColors.menu.fg configure -bg #008080
      .interfaceColors.menu configure -background #008080
      .interfaceColors.output.bg configure -bg #408080
      .interfaceColors.output.fg configure -bg #408080
      .interfaceColors.output configure -background #408080
      .interfaceColors configure -background #408080
      .interfaceColors configure -highlightbackground #408080
      .interfaceColors configure -highlightcolor #408080
      .interfaceColors.buttons configure -background #408080
      .interfaceColors.input.bg configure -bg #008080
      .interfaceColors.input.fg configure -bg #008080
      .interfaceColors.input configure -background #008080
      .interfaceColors.menu.bg configure -fg #ffffff
      .interfaceColors.menu.fg configure -fg #ffffff
      .interfaceColors.output.bg configure -fg #ffffff
      .interfaceColors.output.fg configure -fg #ffffff
      .interfaceColors.input.bg configure -fg #ffffff
      .interfaceColors.input.fg configure -fg #ffffff
      .interfaceColors.menu.bg configure -activebackground #008080
      .interfaceColors.menu.fg configure -activebackground #008080
      .interfaceColors.output.bg configure -activebackground #408080
      .interfaceColors.output.fg configure -activebackground #408080
      .interfaceColors.input.bg configure -activebackground #008080
      .interfaceColors.input.fg configure -activebackground #008080
      .interfaceColors.menu.bg configure -activeforeground #ffffff
      .interfaceColors.menu.fg configure -activeforeground #ffffff
      .interfaceColors.output.bg configure -activeforeground #ffffff
      .interfaceColors.output.fg configure -activeforeground #ffffff
      .interfaceColors.input.bg configure -activeforeground #ffffff
      .interfaceColors.input.fg configure -activeforeground #ffffff
      .interfaceColors.buttons.scheme configure -background #408080
      .interfaceColors.buttons.scheme.label configure -background #408080
      .interfaceColors.buttons.scheme.label configure -foreground #ffffff
    } -image BOX_GREEN -relief ridge
    pack .interfaceColors.buttons.scheme.schemeGreen -ipadx 1 -ipady 1 -side left
    button .interfaceColors.buttons.scheme.schemeBlue -background #c0c0c0 -borderwidth 1 -command {
      .interfaceColors.menu.bg configure -bg #3f3fbe
      .interfaceColors.menu.fg configure -bg #3f3fbe
      .interfaceColors.menu configure -background #3f3fbe
      .interfaceColors.output.bg configure -bg #4864a7
      .interfaceColors.output.fg configure -bg #4864a7
      .interfaceColors.output configure -background #4864a7
      .interfaceColors configure -background #4864a7
      .interfaceColors configure -highlightbackground #4864a7
      .interfaceColors configure -highlightcolor #4864a7
      .interfaceColors.buttons configure -background #4864a7
      .interfaceColors.input.bg configure -bg #3f3fbe
      .interfaceColors.input.fg configure -bg #3f3fbe
      .interfaceColors.input configure -background #3f3fbe
      .interfaceColors.menu.bg configure -fg #fefefe
      .interfaceColors.menu.fg configure -fg #fefefe
      .interfaceColors.output.bg configure -fg #fefefe
      .interfaceColors.output.fg configure -fg #fefefe
      .interfaceColors.input.bg configure -fg #fefefe
      .interfaceColors.input.fg configure -fg #fefefe
      .interfaceColors.menu.bg configure -activebackground #3f3fbe
      .interfaceColors.menu.fg configure -activebackground #3f3fbe
      .interfaceColors.output.bg configure -activebackground #4864a7
      .interfaceColors.output.fg configure -activebackground #4864a7
      .interfaceColors.input.bg configure -activebackground #3f3fbe
      .interfaceColors.input.fg configure -activebackground #3f3fbe
      .interfaceColors.menu.bg configure -activeforeground #fefefe
      .interfaceColors.menu.fg configure -activeforeground #fefefe
      .interfaceColors.output.bg configure -activeforeground #fefefe
      .interfaceColors.output.fg configure -activeforeground #fefefe
      .interfaceColors.input.bg configure -activeforeground #fefefe
      .interfaceColors.input.fg configure -activeforeground #fefefe
      .interfaceColors.buttons.scheme configure -background #4864a7
      .interfaceColors.buttons.scheme.label configure -background #4864a7
      .interfaceColors.buttons.scheme.label configure -foreground #fefefe
    } -image BOX_BLUE
    pack .interfaceColors.buttons.scheme.schemeBlue -ipadx 1 -ipady 1 -side left
    button .interfaceColors.buttons.scheme.schemeDarkBlue -background #c0c0c0 -borderwidth 1 -command {
      .interfaceColors.menu.bg configure -bg #1750a4
      .interfaceColors.menu.fg configure -bg #1750a4
      .interfaceColors.menu configure -background #1750a4
      .interfaceColors.output.bg configure -bg #005090
      .interfaceColors.output.fg configure -bg #005090
      .interfaceColors.output configure -background #005090
      .interfaceColors configure -background #005090
      .interfaceColors configure -highlightbackground #005090
      .interfaceColors configure -highlightcolor #005090
      .interfaceColors.buttons configure -background #005090
      .interfaceColors.input.bg configure -bg #1750a4
      .interfaceColors.input.fg configure -bg #1750a4
      .interfaceColors.input configure -background #1750a4
      .interfaceColors.menu.bg configure -fg #faf580
      .interfaceColors.menu.fg configure -fg #faf580
      .interfaceColors.output.bg configure -fg #faf580
      .interfaceColors.output.fg configure -fg #faf580
      .interfaceColors.input.bg configure -fg #faf580
      .interfaceColors.input.fg configure -fg #faf580
      .interfaceColors.menu.bg configure -activebackground #1750a4
      .interfaceColors.menu.fg configure -activebackground #1750a4
      .interfaceColors.output.bg configure -activebackground #005090
      .interfaceColors.output.fg configure -activebackground #005090
      .interfaceColors.input.bg configure -activebackground #1750a4
      .interfaceColors.input.fg configure -activebackground #1750a4
      .interfaceColors.menu.bg configure -activeforeground #faf580
      .interfaceColors.menu.fg configure -activeforeground #faf580
      .interfaceColors.output.bg configure -activeforeground #faf580
      .interfaceColors.output.fg configure -activeforeground #faf580
      .interfaceColors.input.bg configure -activeforeground #faf580
      .interfaceColors.input.fg configure -activeforeground #faf580
      .interfaceColors.buttons.scheme configure -background #005090
      .interfaceColors.buttons.scheme.label configure -background #005090
      .interfaceColors.buttons.scheme.label configure -foreground #faf580
    } -image BOX_DARKBLUE
    pack .interfaceColors.buttons.scheme.schemeDarkBlue -ipadx 1 -ipady 1 -side left
    button .interfaceColors.buttons.scheme.schemeOrange -background #c0c0c0 -borderwidth 1 -command {
      .interfaceColors.menu.bg configure -bg #ffcec6
      .interfaceColors.menu.fg configure -bg #ffcec6
      .interfaceColors.menu configure -background #ffcec6
      .interfaceColors.output.bg configure -bg #ffdab9
      .interfaceColors.output.fg configure -bg #ffdab9
      .interfaceColors.output configure -background #ffdab9
      .interfaceColors configure -background #ffdab9
      .interfaceColors configure -highlightbackground #ffdab9
      .interfaceColors configure -highlightcolor #ffdab9
      .interfaceColors.buttons configure -background #ffdab9
      .interfaceColors.input.bg configure -bg #ffcec6
      .interfaceColors.input.fg configure -bg #ffcec6
      .interfaceColors.input configure -background #ffcec6
      .interfaceColors.menu.bg configure -fg #000040
      .interfaceColors.menu.fg configure -fg #000040
      .interfaceColors.output.bg configure -fg #000040
      .interfaceColors.output.fg configure -fg #000040
      .interfaceColors.input.bg configure -fg #000040
      .interfaceColors.input.fg configure -fg #000040
      .interfaceColors.menu.bg configure -activebackground #ffcec6
      .interfaceColors.menu.fg configure -activebackground #ffcec6
      .interfaceColors.output.bg configure -activebackground #ffdab9
      .interfaceColors.output.fg configure -activebackground #ffdab9
      .interfaceColors.input.bg configure -activebackground #ffcec6
      .interfaceColors.input.fg configure -activebackground #ffcec6
      .interfaceColors.menu.bg configure -activeforeground #000040
      .interfaceColors.menu.fg configure -activeforeground #000040
      .interfaceColors.output.bg configure -activeforeground #000040
      .interfaceColors.output.fg configure -activeforeground #000040
      .interfaceColors.input.bg configure -activeforeground #000040
      .interfaceColors.input.fg configure -activeforeground #000040
      .interfaceColors.buttons.scheme configure -background #ffdab9
      .interfaceColors.buttons.scheme.label configure -background #ffdab9
      .interfaceColors.buttons.scheme.label configure -foreground #000040
    } -image BOX_ORANGE
    pack .interfaceColors.buttons.scheme.schemeOrange -ipadx 1 -ipady 1 -side left
    button .interfaceColors.buttons.scheme.schemeLightBlue -background #c0c0c0 -borderwidth 1 -command {
      .interfaceColors.menu.bg configure -bg #00ffff
      .interfaceColors.menu.fg configure -bg #00ffff
      .interfaceColors.menu configure -background #00ffff
      .interfaceColors.output.bg configure -bg #80ffff
      .interfaceColors.output.fg configure -bg #80ffff
      .interfaceColors.output configure -background #80ffff
      .interfaceColors configure -background #80ffff
      .interfaceColors configure -highlightbackground #80ffff
      .interfaceColors configure -highlightcolor #80ffff
      .interfaceColors.buttons configure -background #80ffff
      .interfaceColors.input.bg configure -bg #00ffff
      .interfaceColors.input.fg configure -bg #00ffff
      .interfaceColors.input configure -background #00ffff
      .interfaceColors.menu.bg configure -fg #000000
      .interfaceColors.menu.fg configure -fg #000000
      .interfaceColors.output.bg configure -fg #000000
      .interfaceColors.output.fg configure -fg #000000
      .interfaceColors.input.bg configure -fg #000000
      .interfaceColors.input.fg configure -fg #000000
      .interfaceColors.menu.bg configure -activebackground #00ffff
      .interfaceColors.menu.fg configure -activebackground #00ffff
      .interfaceColors.output.bg configure -activebackground #80ffff
      .interfaceColors.output.fg configure -activebackground #80ffff
      .interfaceColors.input.bg configure -activebackground #00ffff
      .interfaceColors.input.fg configure -activebackground #00ffff
      .interfaceColors.menu.bg configure -activeforeground #000000
      .interfaceColors.menu.fg configure -activeforeground #000000
      .interfaceColors.output.bg configure -activeforeground #000000
      .interfaceColors.output.fg configure -activeforeground #000000
      .interfaceColors.input.bg configure -activeforeground #000000
      .interfaceColors.input.fg configure -activeforeground #000000
      .interfaceColors.buttons.scheme configure -background #80ffff
      .interfaceColors.buttons.scheme.label configure -background #80ffff
      .interfaceColors.buttons.scheme.label configure -foreground #000000
    } -image BOX_LIGHTBLUE
    pack .interfaceColors.buttons.scheme.schemeLightBlue -ipadx 1 -ipady 1 -side left
    button .interfaceColors.buttons.scheme.schemeGray -background #c0c0c0 -borderwidth 1 -command {
      .interfaceColors.menu.bg configure -bg #c0c0c0
      .interfaceColors.menu.fg configure -bg #c0c0c0
      .interfaceColors.menu configure -background #c0c0c0
      .interfaceColors.output.bg configure -bg #c0c0c0
      .interfaceColors.output.fg configure -bg #c0c0c0
      .interfaceColors.output configure -background #c0c0c0
      .interfaceColors configure -background #c0c0c0
      .interfaceColors configure -highlightbackground #c0c0c0
      .interfaceColors configure -highlightcolor #c0c0c0
      .interfaceColors.buttons configure -background #c0c0c0
      .interfaceColors.input.bg configure -bg #ffffff
      .interfaceColors.input.fg configure -bg #ffffff
      .interfaceColors.input configure -background #ffffff
      .interfaceColors.menu.bg configure -fg #000000
      .interfaceColors.menu.fg configure -fg #000000
      .interfaceColors.output.bg configure -fg #000000
      .interfaceColors.output.fg configure -fg #000000
      .interfaceColors.input.bg configure -fg #000000
      .interfaceColors.input.fg configure -fg #000000
      .interfaceColors.menu.bg configure -activebackground #ffffff
      .interfaceColors.menu.fg configure -activebackground #ffffff
      .interfaceColors.output.bg configure -activebackground #c0c0c0
      .interfaceColors.output.fg configure -activebackground #c0c0c0
      .interfaceColors.input.bg configure -activebackground #ffffff
      .interfaceColors.input.fg configure -activebackground #ffffff
      .interfaceColors.menu.bg configure -activeforeground #000000
      .interfaceColors.menu.fg configure -activeforeground #000000
      .interfaceColors.output.bg configure -activeforeground #000000
      .interfaceColors.output.fg configure -activeforeground #000000
      .interfaceColors.input.bg configure -activeforeground #000000
      .interfaceColors.input.fg configure -activeforeground #000000
      .interfaceColors.buttons.scheme configure -background #c0c0c0
      .interfaceColors.buttons.scheme.label configure -background #c0c0c0
      .interfaceColors.buttons.scheme.label configure -foreground #000000
    } -image BOX_GRAY -relief ridge
    pack .interfaceColors.buttons.scheme.schemeGray -ipadx 1 -ipady 1 -side left
    button .interfaceColors.buttons.scheme.schemeWhite -background #c0c0c0 -borderwidth 1 -command {
      .interfaceColors.menu.bg configure -bg #f6f6f6
      .interfaceColors.menu.fg configure -bg #f6f6f6
      .interfaceColors.menu configure -background #f6f6f6
      .interfaceColors.output.bg configure -bg #ffffff
      .interfaceColors.output.fg configure -bg #ffffff
      .interfaceColors.output configure -background #ffffff
      .interfaceColors configure -background #ffffff
      .interfaceColors configure -highlightbackground #ffffff
      .interfaceColors configure -highlightcolor #ffffff
      .interfaceColors.buttons configure -background #ffffff
      .interfaceColors.input.bg configure -bg #f6f6f6
      .interfaceColors.input.fg configure -bg #f6f6f6
      .interfaceColors.input configure -background #f6f6f6
      .interfaceColors.menu.bg configure -fg #000000
      .interfaceColors.menu.fg configure -fg #000000
      .interfaceColors.output.bg configure -fg #000000
      .interfaceColors.output.fg configure -fg #000000
      .interfaceColors.input.bg configure -fg #000000
      .interfaceColors.input.fg configure -fg #000000
      .interfaceColors.menu.bg configure -activebackground #f6f6f6
      .interfaceColors.menu.fg configure -activebackground #f6f6f6
      .interfaceColors.output.bg configure -activebackground #ffffff
      .interfaceColors.output.fg configure -activebackground #ffffff
      .interfaceColors.input.bg configure -activebackground #f6f6f6
      .interfaceColors.input.fg configure -activebackground #f6f6f6
      .interfaceColors.menu.bg configure -activeforeground #000000
      .interfaceColors.menu.fg configure -activeforeground #000000
      .interfaceColors.output.bg configure -activeforeground #000000
      .interfaceColors.output.fg configure -activeforeground #000000
      .interfaceColors.input.bg configure -activeforeground #000000
      .interfaceColors.input.fg configure -activeforeground #000000
      .interfaceColors.buttons.scheme configure -background #ffffff
      .interfaceColors.buttons.scheme.label configure -background #ffffff
      .interfaceColors.buttons.scheme.label configure -foreground #000000
    } -image BOX_WHITE
    pack .interfaceColors.buttons.scheme.schemeWhite -ipadx 1 -ipady 1 -side left
    button .interfaceColors.buttons.cancel -borderwidth 2 -command {
      destroy .interfaceColors
    } -font BUTTONFONT -relief raised -text Cancel -width 6
    pack .interfaceColors.buttons.cancel -padx 10 -side right
    button .interfaceColors.buttons.ok -borderwidth 2 -command {
      set MENUBG [.interfaceColors.menu.bg cget -bg]
      set MENUFG [.interfaceColors.menu.fg cget -fg]
      set OUTPUTBG [.interfaceColors.output.bg cget -bg]
      set OUTPUTFG [.interfaceColors.output.fg cget -fg]
      set INPUTBG [.interfaceColors.input.bg cget -bg]
      set INPUTFG [.interfaceColors.input.fg cget -fg]
      refresh
      destroy .interfaceColors
    } -font BUTTONFONT -relief raised -text OK -width 6
    pack .interfaceColors.buttons.ok -padx 10 -side right
}

proc changeFonts {  } {
    global FONTSIZE

    global MENUFG
    global MENUBG
    global INPUTFG
    global INPUTBG
    global OUTPUTFG
    global OUTPUTBG

    toplevel .interfaceFonts -background $OUTPUTBG -highlightbackground $OUTPUTBG -highlightcolor $OUTPUTBG -highlightthickness 4
    wm title .interfaceFonts {Fonts}
    wm iconname .interfaceFonts {Fonts}
    wm resizable .interfaceFonts false false
    grab set .interfaceFonts

    frame .interfaceFonts.size -background $OUTPUTBG
    pack .interfaceFonts.size
    label .interfaceFonts.size.label -anchor w -background $MENUBG -font BIGFONT -foreground $MENUFG -relief raised -text "Choose font size:" -width 32
    pack .interfaceFonts.size.label -fill x -ipady 5
    radiobutton .interfaceFonts.size.normal -activebackground $OUTPUTBG -activeforeground $OUTPUTFG -background $OUTPUTBG -font FONT -foreground $OUTPUTFG -highlightthickness 0 -selectcolor $OUTPUTBG -text "normal" -value 0 -variable FONTSIZE
    pack .interfaceFonts.size.normal -anchor w
    radiobutton .interfaceFonts.size.large -activebackground $OUTPUTBG -activeforeground $OUTPUTFG -background $OUTPUTBG -font FONT -foreground $OUTPUTFG -highlightthickness 0 -selectcolor $OUTPUTBG -text "large" -value 1 -variable FONTSIZE
    pack .interfaceFonts.size.large -anchor w
    radiobutton .interfaceFonts.size.huge -activebackground $OUTPUTBG -activeforeground $OUTPUTFG -background $OUTPUTBG -font FONT -foreground $OUTPUTFG -highlightthickness 0 -selectcolor $OUTPUTBG -text "huge" -value 2 -variable FONTSIZE
    pack .interfaceFonts.size.huge -anchor w
    frame .interfaceFonts.buttons -background $OUTPUTBG
    pack .interfaceFonts.buttons -ipady 10 -side bottom
    button .interfaceFonts.buttons.cancel -borderwidth 2 -command {
      destroy .interfaceFonts
    } -font BUTTONFONT -relief raised -text Cancel -width 6
    pack .interfaceFonts.buttons.cancel -padx 10 -side left
    button .interfaceFonts.buttons.ok -borderwidth 2 -command {
      if {$FONTSIZE == 0} {
        font configure FONT -size 14
        font configure BUTTONFONT -size 12
        font configure MENUFONT -size 12
        font configure BIGFONT -size 16
        font configure BLACKFONT -size 12
      }
      if {$FONTSIZE == 1} {
        font configure FONT -size 16
        font configure BUTTONFONT -size 14
        font configure MENUFONT -size 14
        font configure BIGFONT -size 18
        font configure BLACKFONT -size 14
      }
      if {$FONTSIZE == 2} {
        font configure FONT -size 18
        font configure BUTTONFONT -size 16
        font configure MENUFONT -size 16
        font configure BIGFONT -size 20
        font configure BLACKFONT -size 16
      }
      destroy .interfaceFonts
    } -font BUTTONFONT -relief raised -text OK -width 6
    pack .interfaceFonts.buttons.ok -padx 10 -side right
}

