/*
 * Decompiled with CFR 0.152.
 */
package org.natto;

import java.io.File;
import java.io.FileWriter;
import java.util.UUID;
import org.natto.StaticTools;

public final class ExecSecurity {
    private static ExecSecurity eSecInstance;
    private static String myIdent;
    private boolean securityIsOn = false;

    private ExecSecurity() {
    }

    public static synchronized ExecSecurity getInstance() {
        if (eSecInstance == null) {
            eSecInstance = new ExecSecurity();
        }
        return eSecInstance;
    }

    public boolean securityOn() {
        return this.securityIsOn;
    }

    public void turnOff() {
        this.securityIsOn = false;
    }

    public String turnOn() {
        String diags = ExecSecurity.signerOK();
        if ("".equals(diags)) {
            this.securityIsOn = true;
        }
        return diags;
    }

    public String getMyIdentity() {
        return myIdent;
    }

    public String getSigners() {
        String cmdOut = StaticTools.execGet("gpg  --list-keys", false);
        if (cmdOut == null) {
            cmdOut = "";
        }
        String sigNers = "";
        String[] parts = cmdOut.split("\n");
        for (int i = 0; i < parts.length; ++i) {
            if (!parts[i].startsWith("uid")) continue;
            String thisLine = parts[i].substring(4);
            thisLine = thisLine.trim();
            sigNers = thisLine + "\n";
        }
        return sigNers;
    }

    public void clearSignFile(String fileName) {
        String cmdOut = StaticTools.execGet("gpg --no-tty --clearsign " + fileName, true);
        if ("".equals(cmdOut)) {
            File beGone = new File(fileName);
            beGone.delete();
        }
    }

    public String verifySignature(String ascFileName) {
        String cmdOut = StaticTools.execGet("gpg --verify " + ascFileName, true);
        if (cmdOut.indexOf("Good signature") > 0) {
            return "";
        }
        return cmdOut;
    }

    public static String signerOK() {
        String testFileName = UUID.randomUUID().toString() + ".txt";
        File testFile = new File(testFileName);
        File ascFile = new File(testFileName + ".asc");
        try {
            FileWriter fileWr = new FileWriter(testFile);
            fileWr.write(testFileName + "\n");
            fileWr.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        String cmdOut = StaticTools.execGet("gpg --no-tty --clearsign " + testFileName, true);
        if (cmdOut.indexOf("no terminal at all") > 0) {
            String x = "";
            String myOs = System.getProperty("os.name");
            if (myOs.startsWith("Mac")) {
                String myDir = System.getProperty("user.dir");
                String commandFileName = testFileName.replace(".txt", ".command");
                File commandFile = new File(commandFileName);
                try {
                    FileWriter fileWr = new FileWriter(commandFile);
                    fileWr.write("cd " + myDir + "\n" + "gpg --clearsign " + testFileName + "\n");
                    fileWr.close();
                    x = StaticTools.execGet("chmod +x " + commandFileName, true);
                    Thread.sleep(2000L);
                    x = StaticTools.execGet("open " + commandFileName, true);
                    Thread.sleep(2000L);
                    boolean goOn = true;
                    while (goOn) {
                        x = StaticTools.execGet("ps", true);
                        if (x.indexOf("clearsign") == -1) {
                            goOn = false;
                            continue;
                        }
                        System.out.println("waiting");
                        Thread.sleep(2000L);
                    }
                    commandFile.delete();
                }
                catch (Exception e) {}
            } else {
                x = StaticTools.execGet("xterm -e gpg --clearsign " + testFileName, true);
            }
            System.out.println(x);
        }
        testFile.delete();
        if (ascFile.exists()) {
            int firstQuotePos;
            cmdOut = StaticTools.execGet("gpg --verify " + testFileName + ".asc", true);
            int lastQuotePos = cmdOut.indexOf("\"", (firstQuotePos = cmdOut.indexOf("\"")) + 1);
            if (lastQuotePos > 0) {
                myIdent = cmdOut.substring(firstQuotePos + 1, lastQuotePos);
            }
            ascFile.delete();
            return "";
        }
        if ("".equals(cmdOut)) {
            return "No response: maybe you do not have the PGP program?";
        }
        if (cmdOut.indexOf("no default") > 0) {
            return "No default pgp key. Please check your PGP configuration.";
        }
        if (!ascFile.exists()) {
            return "PGP could not produce a signed file.";
        }
        return "unspecified error";
    }

    static {
        myIdent = "";
    }
}

