# Copyright 2009 Ben Escoto
#
# This file is part of Explicans.

# Explicans is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.

# Explicans is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with Explicans.  If not, see <http://www.gnu.org/licenses/>.


import sys, types, time
from PyQt4 import QtCore, QtGui
import gui, stylesheets, program, extable, objects, program

sig_trigger = QtCore.SIGNAL("triggered()")

class MainWindow(QtGui.QMainWindow):
    def __init__(self):
        """Create the entire display from initial tuple string"""
        QtGui.QMainWindow.__init__(self)
        #self.setStyleSheet(stylesheets.background)
        self.supervisor = gui.Supervisor(lambda a, b, c: None)
        self.createMenus()
        self.createScroll()

    def createMenus(self):
        """Initialize the Menus"""
        self.fileMenu = self.menuBar().addMenu(self.tr("&File"))
        self.FlipAct = QtGui.QAction(self.tr("&Flip"), self)
        self.exitAct = QtGui.QAction(self.tr("E&xit"), self)
        self.connect(self.exitAct, sig_trigger, QtCore.SLOT("close()"))
        self.connect(self.FlipAct, sig_trigger, self.supervisor.flip_slot)
        self.fileMenu.addAction(self.FlipAct)
        self.fileMenu.addAction(self.exitAct)

    def createScroll(self):
        """Create a scrollable viewing area"""
        self.scrollarea = QtGui.QScrollArea()
        self.scrollarea.setStyleSheet(stylesheets.background)
        self.scrollarea.setMinimumSize(600, 600)
        self.setCentralWidget(self.scrollarea)
        self.scrollarea.setWidgetResizable(True)



def TuplesToGC(t, prog, super, abs_ref = program.AbsoluteReference(())):
    """Convert a nested tuple of strings to a GuiCell"""
    name, func, value = t
    if type(value) in (types.TupleType, types.ListType):
        new_value = [TuplesToGC(subtuple, prog, super, abs_ref.append(n))
                     for n, subtuple in enumerate(value)]
    elif isinstance(value, extable.ExTable):
        new_value = gui.GuiTable(prog, value, abs_ref)
    else: new_value = str(value)
    return gui.GuiCell(name, func, new_value, 'tall', abs_ref)


def maketable(height, width):
    """Return a sample ExTable object"""
    def thunk_maker(n):
        def thunk(): return objects.ExNum(n)
        return thunk

    t = extable.ExTable('rowname', 'colname',
                        ['row'+str(i) for i in range(height)],
                        ['row'+str(i) for i in range(height)])
    for i in range(height):
        for j in range(width):
            t.set_value_thunk(i, j, thunk_maker(10*(i+1)+(j+1)))
    return t

t = ('hidden', 'root', (('hello', 'there', 'test'),
                        ('foo', 'bar', 'baz'),
                        ('blah', 'poof', 'blah')))
t2 = ('hidden', 'root', (('hello', 'there', 'test'),
                         ('foo', 'bar', (('sub', 'nested', 'tuple'),
                                         ('blah', 'blah', 'blah'),
                                         ('third', 'row', 5.0))),
                         ('foo2', 'bar2', (('sub', 'nested', 'tuple'),
                                           ('blah', 'blah', 'blah'),
                                           ('third', 'row', 123.0),
                                           ('Fourth', 'row', 'etc'),
                                           ('fifth', '...', '...'))),
                         ('blah', 'poof', 'blah'),
                         ('end', 'last', 'row')))
t3 = ('hidden', 'root', (('hello', 'there', 'test'),
                         ('second', 'row', 'blah'),
                         ('table', 'row', maketable(4, 4)),
                         ('last name', 'last form', 'last elem')))

prog = program.Program(
"""Reference,Name,Formula
(),,array(4)
"(2)",,"table(2,2)"
"(2, T:R)",,row func
"(2, T:C)",,col func
"(2, T:0,1)",,col1 func
"(2, T:0,2)",,col2 func
"(2, T:1,0)",,row1 func
"(2, T:2,0)",,row2 func
""")

if __name__ == "__main__":
    app = QtGui.QApplication(sys.argv)
    mainWin = MainWindow()
    mainWin.show()
    gc = TuplesToGC(t3, prog, mainWin.supervisor)
    mainWin.supervisor.set_root(gc, lambda w: mainWin.scrollarea.setWidget(w))
    gc.set_widget_table_recursive()
    mainWin.scrollarea.setWidget(gc.value_widget)
    #while 1:
    #    app.processEvents()
    #    time.sleep(.02)
    #    if mainWin.controller.redraw:
    #        mainWin.scrollarea.setWidget(gc.value_widget)
    sys.exit(app.exec_())


