<?php
require('fpdf15/fpdf.php');

class PDF extends FPDF {

	//En-tte
	function Header(){
		//Logo
		$this->Image(HTTP_BDD.'images/ganesha.png',10,8,40);
		$this->SetFont('Arial','B',15);
		$this->Cell(40);
		$this->Cell(80,10,'Ganesha '.VERSION,0,0,'C');
		//Saut de ligne
		$this->Ln(20);
	}

	//Pied de page
	function Footer(){
		//Positionnement  1,5 cm du bas
		$this->SetY(-15);
		//Police Arial italique 8
		$this->SetFont('Arial','I',8);
		//Numro de page
		$this->Cell(60,7,'Copyright Anema Formation 2000-2003',0,0,'C');
		$this->Cell(80,7,'Page '.$this->PageNo().'/{nb}',0,0,'C');
		$this->Cell(60,7,'Ganesha '.VERSION,0,0,'C');
		$this->Ln();
	}
}

function pdfInit($name) {
	global $pdf, $BDD ;
	$pdf->Open();
	$pdf->SetAuthor("Georges Caldeira pour Anema Formation") ;
	$pdf->SetCreator("Georges Caldeira pour Anema Formation");
	$pdf->SetDisplayMode("real", "default" ) ;
	$pdf->AliasNbPages();
	if ( $name != $BDD['name'] ) {
		$pdf->SetSubject("Structures et proprits de la table ".$BDD['name']) ;
	} else {
		$pdf->SetSubject("Structures et proprits des tables de la base ".$BDD['name']) ;
	}
}

function pdfClose() {
	global $pdf ;
//	$pdf->Output($pdf_file.".pdf",true);
	$pdf->Output();
}

//Tableau color
function pdfTableSchema($data,$tablename){
	global $pdf;
	//Couleurs, paisseur du trait et police grasse
	$pdf->SetFillColor(0,0,0);
	$pdf->SetDrawColor(0,0,0);
	$pdf->SetLineWidth(.3);

	//En-tte
	$pdf->SetTextColor(255);
	//Titres des colonnes
	$header=array('Field','Type','Null','Key','Default','Extra');
	$w=array(35,35,20,20,40,40);
	for($i=0;$i<count($header);$i++) {
		$pdf->Cell($w[$i],7,$header[$i],1,0,'C',1);
	}
	$pdf->Ln();
	//Restauration des couleurs et de la police
	$pdf->SetFillColor(224,235,255);
	$pdf->SetTextColor(0);
	$pdf->SetFont('','',10);
	//Donnes
	$fill=0;
	for ( $i=0; $i<count($data); $i++ ) {
		$pdf->Cell($w[0],6,$data[$i][0],'LR',0,'L',$fill);
		$pdf->Cell($w[1],6,$data[$i][1],'LR',0,'L',$fill);
		$pdf->Cell($w[2],6,$data[$i][2],'LR',0,'L',$fill);
		$pdf->Cell($w[3],6,$data[$i][3],'LR',0,'L',$fill);
		$pdf->Cell($w[4],6,$data[$i][4],'LR',0,'L',$fill);
		if ( $data[$i][5] == "auto_increment" ) {
			$pdf->SetTextColor(255,0,0);
			$pdf->Cell($w[5],6,$data[$i][5],'LR',0,'L',$fill);
			$pdf->SetTextColor(0);
		} else {
			$pdf->Cell($w[5],6,$data[$i][5],'LR',0,'L',$fill);
		}
		$pdf->Ln();
		$fill=!$fill;
	}
	$pdf->Cell(array_sum($w),0,'','T');
	$pdf->Ln(10);
}

function pdfTableProperties($header,$data,$tablename){
	global $pdf;
	//Couleurs, paisseur du trait et police grasse
	$pdf->SetFillColor(0,0,0);
	$pdf->SetDrawColor(0,0,0);
	$pdf->SetLineWidth(.5);

	//En-tte
	$pdf->SetTextColor(255);
	$w=array(50,50);
	for($i=0;$i<count($header);$i++)
		$pdf->Cell($w[$i],7,$header[$i],1,0,'C',1);
	$pdf->Ln();
	//Restauration des couleurs et de la police
	$pdf->SetFillColor(224,235,255);
	$pdf->SetTextColor(0);
	$pdf->SetFont('','',10);
	//Donnes
	$fill=0;
	for ( $i=0; $i<count($data); $i++ ) {
		$pdf->Cell($w[0],6,$data[$i++],'LR',0,'L',$fill);
		$pdf->Cell($w[1],6,$data[$i],'LR',0,'L',$fill);
		$pdf->Ln();
		$fill=!$fill;
	}
	$pdf->Cell(array_sum($w),0,'','T');
}

function pdfTitre($titre) {
	global $pdf ;
	$pdf->SetFont('Arial','',14);
	$pdf->SetTextColor(0);
	$pdf->Write(7, $titre);
	$pdf->Ln();
	$pdf->Ln();
}

function pdfChapitre($titre) {
	global $pdf ;
    $pdf->SetFont('Arial','',14);
    $pdf->SetFillColor(200,220,255);
    $pdf->Cell(0,6,$titre,0,1,'L',1);
    $pdf->Ln(4);
}

function pdfSchema($pdf_file,$number='',$titre='') {
	global $pdf ;
	$db = new DB_Ganesha()	;
	//Chargement des donnes
	$data = array() ;
	$db->query("SHOW fields FROM ".$pdf_file);
	$num = $db->num_rows();
	for( $i = 0; $i < $num; $i++ ) {
		$db->next_record();
		$data[$i][] = $db->f("Field") ;
		$data[$i][] = $db->f("Type");
		$data[$i][] = $db->f("Null");
		$data[$i][] = $db->f("Key");
		$data[$i][] = $db->f("Default");
		$data[$i][] = $db->f("Extra");
	}
	$pdf->AddPage();
	if ( $titre != '' ) {
		pdfChapitre($titre);
	}
	pdfTitre($number." - Table ".$pdf_file);
	$num = ($number==''?'1':$number.'.1');
	pdfTitre($num." - Structure de la table");
	pdfTableSchema($data,$pdf_file);
}

function pdfPropeties($pdf_file,$number='') {
	global $pdf ;
	$db = new DB_Ganesha()	;
	//Titres des colonnes
	$header=array('Description','Valeur');
	//Chargement des donnes
	$prop = array() ;
	$db->query("SHOW fields FROM ".$pdf_file);
	$prop[]="Nombre de champs";
	$prop[] = $db->num_rows();
	
	$db->query("show table status");
	while ( $db->next_record() ) {
		if ( $db->f("Name") == $pdf_file ) {
			$prop[]="Format";
			$prop[] = $db->f('Row_format') ;
			$prop[]="Enregistrement";
			$prop[] = $db->f('Rows') ;
			$prop[]="Auto increment";
			$prop[] = $db->f('Auto_increment') ;
			$prop[]="Longueur";
			$prop[] = $db->f('Avg_row_length')." octets" ;
			$prop[]="Donnes";
			$prop[] = $db->f('Data_length')." octets" ;
			$prop[]="Index";
			$prop[] = $db->f('Index_length')." octets" ;
			$prop[]="Comment";
			$prop[] = $db->f('Comment') ;
			break;
		}
	}
	$num = ($number==''?'2':$number.'.2');
	pdfTitre( $num." - Proprits de la table ");
	pdfTableProperties($header,$prop,$pdf_file);
}

function pdfSommaire(){
	global $TBL, $pdf ;
	$db = new DB_Ganesha()	;
	$table = array_values($TBL);
	$nb = count($table) - 1 ;
	$pdf->SetFont('Arial','B',12);
	$pdf->SetTextColor(0);
	$pdf->SetDrawColor(255,255,255);
	$pdf->SetLineWidth(.0);
	$pdf->AddPage();
	pdfChapitre("S O M M A I R E");
	$pdf->Cell(0,6,"I - Table utilises par Ganesha",'LR',0,'L',false);
	$pdf->Ln();
	for ( $i=0; $i<$nb; $i++ ) {
		$tablename = $table[$i] ;
		$num = $i+1 ;
		$pdf->Cell(140,6,"			".$num." - Table ".$tablename,'LR',0,'L',false);
		$pdf->Cell(40,6,($i+2),'LR',0,'R',false);
		$pdf->Ln();
	}
/*	
	$pdf->Ln();
	$pdf->Cell(0,6,"II - Table des modules",'LR',0,'L',false);
	$pdf->Ln();
	$num = 1 ;
*/
/*	
	$tablename = $TBL['list_module'] ;
	$pdf->Cell(140,6,"			".$num++." - Table ".$tablename,'LR',0,'L',false);
	$pdf->Cell(40,6,($i++),'LR',0,'R',false);
	$pdf->Ln();	
	$tablename = $TBL['module'] ;
	$pdf->Cell(140,6,"			".$num++." - Table ".$tablename,'LR',0,'L',false);
	$pdf->Cell(40,6,($i++),'LR',0,'R',false);
	$pdf->Ln();
*/
/*
	$db->query("SELECT module_id FROM ".$TBL['list_module']);
	$num = 1 ;
	$i = $i + 2   ;
	while ( $db->next_record() ) {
		$tablename = "module_".$db->f(0);
		$pdf->Cell(140,6,"			".$num++." - Table ".$tablename,'LR',0,'L',false);
		$pdf->Cell(40,6,($i++),'LR',0,'R',false);
		$pdf->Ln();
	}
*/
	$pdf->Ln();
	$pdf->Ln();
	$pdf->Cell(0,6,"II - Table des forums",'LR',0,'L',false);
	$pdf->Ln();
	$pdf->Cell(140,6,"			1 - Table ".$TBL['forums'],'LR',0,'L',false);
	$pdf->Cell(40,6,($i++),'LR',0,'R',false);
	$pdf->Ln();
	$db->query("SELECT id FROM ".$TBL['forums']);
	$num = 2 ;
	while ( $db->next_record() ) {
		$tablename = "g".$db->f(0);
		$pdf->Cell(140,6,"			".$num++." - Table ".$tablename,'LR',0,'L',false);
		$pdf->Cell(40,6,($i++),'LR',0,'R',false);
		$pdf->Ln();
		$tablename.= "_bodies";
		$pdf->Cell(140,6,"			".$num++." - Table ".$tablename,'LR',0,'L',false);
		$pdf->Cell(40,6,($i++),'LR',0,'R',false);
		$pdf->Ln();
	}
}

$pdf=new PDF()			;
$db = new DB_Ganesha()	;

pdfInit($pdf_file)		;
if ( $pdf_file != $BDD['name'] )  {
	pdfSchema($pdf_file)	;
	pdfPropeties($pdf_file)	;
} else {
	pdfSommaire();
	$table = array_values($TBL);
	$num = count($table) - 1 ;
	for( $i = 0; $i < $num; $i++ ) {
		$tablename = $table[$i];
		if ( $i == 0 ) {
			pdfSchema($tablename,$i+1,"I - Table utilises par Ganesha");
		} else {
			pdfSchema($tablename,$i+1);
		}
		pdfPropeties($tablename,$i+1);
	}
	$i++ ;
	pdfSchema($TBL['forums'],1,"II - Table des forums");
	pdfPropeties($TBL['forums'],1);
	$db->query("SELECT id FROM ".$TBL['forums']);
	$num = 2 ;
	while ( $db->next_record() ) {
		$tablename = "g".$db->f(0);
		pdfSchema($tablename,$num);
		pdfPropeties($tablename,$num);
		$num++ ;
		$tablename.= "_bodies";
		pdfSchema($tablename,$num);
		pdfPropeties($tablename,$num);		
		$num++ ;
	}

	/*
	$i++ ;
	pdfSchema($TBL['list_module'],$i,"II - Table des modules");
	pdfPropeties($TBL['list_module'],$i);
	$i++ ;
	pdfSchema($TBL['module'],$i);
	pdfPropeties($TBL['module'],$i);
	*/
	/*
	$db->query("SELECT module_id FROM ".$TBL['list_module']);
	$i = 0 ;
	while ( $db->next_record() ) {
		//$tablename = "module_".$db->f(0);
		if ( $i == 0 ) {
			pdfSchema($tablename,$i+1,"II - Table des modules");
		} else {
			pdfSchema($tablename,$i+1);
		}
		pdfPropeties($tablename,$i+1);
	}
	*/
}
pdfClose()	;
exit()		;

?>