<?PHP
/* vim: set expandtab tabstop=4 shiftwidth=4: */
// +----------------------------------------------------------------------------+
// | <G a n e s h a> - Free Web Based Training System                           |
// +----------------------------------------------------------------------------+
// | <G a n e s h a> - Plate-forme de tlformation gratuite et en open source  |
// +----------------------------------------------------------------------------|
// | Copyright (C) 2001-2003  Anma Formation  <http://www.anema.fr/>           |
// +----------------------------------------------------------------------------+
// |           Developer : Georges CALDEIRA <gcaldeira@anemalab.org>            |
// +----------------------------------------------------------------------------+
// |              Infos on project <http://anemalab.org/>                       |
// +----------------------------------------------------------------------------+
// | This program is free software; you can redistribute it and/or modify       |
// | it under the terms of the GNU General Public License as published by       |
// | the Free Software Foundation; either version 2 of the License, or          |
// | (at your option) any later version.                                        |
// |                                                                            |
// | This program is distributed in the hope that it will be useful,            |
// | but WITHOUT ANY WARRANTY; without even the implied warranty of             |
// | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              |
// | GNU General Public License for more details.                               |
// |                                                                            |
// | You should have received a copy of the GNU General Public License          |
// | along with this program; if not, write to the Free Software                |
// | Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA   |
// +----------------------------------------------------------------------------+

/**
* Definition de la class pour la gestion des formations.
* @author	Georges Caldeira <gcaldeira@anemalab.org>
* @package	GaneshaClass
*/
/**
* Fournit une API pour acceder aux formations.
* @author	Georges Caldeira <gcaldeira@anemalab.org>
* @access	public
* @package	GaneshaClass
*/
class Formation {

	/**
	* Contient la connexion locale de la classe
	* @var	object DB_Ganesha	$_db
	* @access	private
	*/
	var $_db ;

	/**
	* Constructeur de la classe Formation. Cre une connexion locale
	* @access	public
	*/
	function Formation() {
		$this->_db = new DB_Ganesha ;
	}


	/**
	* Lit une formation dans la base de donnee.
	* @param	integer	$idu Id du user
	* @param	integer	$idm Id du module a lire
	* @param	integer	$idg Id du groupe
	* @return	array Retourne les informations d'une formation ou sinon false
	* @access	public
	*/
	function Read($idu,$idm,$idg) {
	 global $TBL, $db;
		$sSQL = "SELECT f.avancement,l.date_debut,l.date_fin,l.date_presentiel ";
		$sSQL.= "FROM ".$TBL['formation']." f, ".$TBL['list_groupe']." l, ".$TBL['membres']." m ";
		$sSQL.= "WHERE f.user_id=".$idu." AND f.groupe_id=".$idg." "	;
		$sSQL.= "AND f.module_id=".$idm." AND m.id=".$idu ;
		$db->query($sSQL)	;
		if ( $db->next_record()	) {
			$ret['avancement']	= $db->f(0) ;
			$ret['datedebut']	= $db->f(1) ;
			$ret['datefin']		= $db->f(2) ;
			$ret['presentiel']	= $db->f(3) ;
			return($ret);
		} else {
			return(false);
		}
	}

	/**
	* Met a jour l'avancement d'un module.
	* @param	integer	$idm Id du module 
	* @param	integer	$idu Id du membre
	* @param	integer	$avancement avancement dans la formation
	* @param	integer	$idg Id du groupe
	* @access	public
	*/
	function Update($idm,$idu,$avancement,$idg) {
	 global $TBL, $db ;
		$sSQL = "update ".$TBL['formation']." set avancement ='".$avancement."' " ;
		$sSQL.= "where module_id=".$idm." and user_id=".$idu." AND groupe_id=".$idg ;
		$db->query($sSQL);
	}

	/**
	* Verifie que le membre courant peut utiliser un module
	* @param	integer	$idm Id du module a verifier
	* @param	integer	$idu Id du user
	* @param	integer	$idg Id du groupe
	* @return	integer	0 si le membre n'a pas le droit, >0 si le membre peut utiliser le module
	* @access	public
	*/
	function ModuleIsValid($idm,$idu,$idg) {
	 global $TBL, $db ;
		$sSQL = "SELECT id_module FROM ".$TBL['session_groupe']." " ;
		$sSQL.= "WHERE id_module=".$idm." AND id_groupe=".$idg;
		$db->query($sSQL)			;
		return($db->num_rows()>0)	;
	}

	/**
	* supprime la formation d'un user
	* @param	integer	$idu Id du user
	* @param	integer	$idm Id du module
	* @access	public
	*/
	function del($idu,$idm,$idg) {
	 global $TBL, $db ;
		$sSQL = "DELETE FROM ".$TBL['formation']." " ;
		$sSQL.= "WHERE module_id=".$idm." AND user_id=".$idu." AND groupe_id=".$idg;
		$db->query($sSQL)			;
	}

	/**
	* supprime un module de formation
	* @param	integer	$idm Id du module
	* @access	public
	*/
	function delModule($idm) {
	 global $TBL, $db ;
		$sSQL = "DELETE FROM ".$TBL['formation']." WHERE module_id=".$idm ;
		$db->query($sSQL)	;
	}

	/**
	* supprime un groupe de formation
	* @param	integer	$idg Id du groupe
	* @access	public
	*/
	function delGroupe($idg) {
	 global $TBL, $db ;
		$sSQL = "DELETE FROM ".$TBL['formation']." WHERE groupe_id=".$idg ;
		$db->query($sSQL)	;
	}

	/**
	* supprime un groupe de formation
	* @param	integer	$idg Id du groupe
	* @access	public
	*/
	function add($idu,$idm,$idg) {
	 global $TBL, $db ;
		if ( is_numeric($idu) && $idu>0 ) {
			$sSQL = "INSERT INTO ".$TBL['formation']." ";
			$sSQL.= "(id,user_id,module_id,groupe_id,avancement,note,ordre) ";
			$sSQL.= "VALUES('',".$idu.",".$idm.",".$idg.",0,0,0) ";
			$db->query($sSQL)	;
		}
	}
		
 } // class Formation

/**
* Instance de la classe Formation
* @var	object	Formation	$ClsFormation
*/
$ClsFormation = new Formation ;

?>