<?php
/* vim: set expandtab tabstop=4 shiftwidth=4: */
// +----------------------------------------------------------------------------+
// | <G a n e s h a> - Free Web Based Training System                           |
// +----------------------------------------------------------------------------+
// | <G a n e s h a> - Plate-forme de tlformation gratuite et en open source  |
// +----------------------------------------------------------------------------|
// | Copyright (C) 2001-2003  Anma Formation  <http://www.anema.fr/>           |
// +----------------------------------------------------------------------------+
// |           Developer : Georges CALDEIRA <gcaldeira@anemalab.org>            |
// +----------------------------------------------------------------------------+
// |              Infos on project <http://anemalab.org/>                       |
// +----------------------------------------------------------------------------+
// | This program is free software; you can redistribute it and/or modify       |
// | it under the terms of the GNU General Public License as published by       |
// | the Free Software Foundation; either version 2 of the License, or          |
// | (at your option) any later version.                                        |
// |                                                                            |
// | This program is distributed in the hope that it will be useful,            |
// | but WITHOUT ANY WARRANTY; without even the implied warranty of             |
// | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              |
// | GNU General Public License for more details.                               |
// |                                                                            |
// | You should have received a copy of the GNU General Public License          |
// | along with this program; if not, write to the Free Software                |
// | Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA   |
// +----------------------------------------------------------------------------+

/**
* Gestion des valuations annexes
*
* @author		Eric Villard <evillard@nef.fr>
* @package		GaneshaInc
*/

	/**
	* Affiche la page tableau de bord du profil tuteur
	* @access	public
	*/
	function page_evalannexes() {
	 global $color2, $tu_titre, $evx_menu, $confirm;
	 	// tableau recensant les titres des sous-menus
	 	$tabevx_menu = array(1 => $tu_titre["gesteval"], 
	 						 2 => $tu_titre["assigneval"], 
	 						 3 => $tu_titre["rapporteval"]);
		// formatage du titre et de la barre des menus
		if (!isset($confirm)) {
			Title($tabevx_menu[$evx_menu]);
			if ($evx_menu == MENU_EVX_MNG) {
				menuSelection(array($tu_titre["crer"], $tu_titre["modifier"], $tu_titre["supprimer"]),
							  array(IMG_ADD, IMG_MODIF, IMG_DEL) );
			} elseif ($evx_menu == MENU_EVX_ASS)  {
				menuSelection(array($tu_titre["assigner"], $tu_titre["supprimer"]),array(IMG_MODIF, IMG_DEL) );
			} elseif ($evx_menu == MENU_EVX_RPT)  {
				menuSelection(array($tu_titre["crer"], $tu_titre["modifier"], $tu_titre["supprimer"], $tu_titre["consulter"]),
							  array(IMG_ADD, IMG_MODIF, IMG_DEL, IMG_RIGHT) );
			}
		} else {
			Title($tu_titre["confirmation"]);
		}
		BR(2);
		routage();
	}

	/**
	* Cre un sous menu pour la gestion des valuations
	* @access	public
	*/
	function menu_evalannexes() {
	 	global $color2, $color1, $connexion, $menu, $evx_menu ;
	 	global $ext, $cmd;
		global $tu_titre ;
		
	 	// tableau recensant les titres des sous-menus
	 	$tabevx_menu = array(1 => $tu_titre["gesteval"], 2 => $tu_titre["assigneval"], 3 => $tu_titre["rapporteval"]);
		//reset($tabevx_menu);

		while (list($cle, $val) = each($tabevx_menu)) {
			// menu slectionn
	 		if ($cle == $evx_menu) {
				put ('     <tr><td width="5%" bgcolor="'.$color1.'" >&nbsp;</td>');
				$href   = 'href="#" ' ;
				$status = Status($val);
				$link = '<a class="HEADER2" target="FrmMain" '.$href.$status.'>'.Replace("| ".$val).'</a>';
				put ('     <td bgcolor="'.$color1.'">'.$link.'</td></tr>');
			
			// menus non slectionns
			} else {
				put ('     <tr><td width="5%"bgcolor="'.$color2.'">&nbsp;</td>');
				$href = 'href="'.HTTP_TUTEUR.'index'.$ext.'?connexion='.$connexion.'&evx_menu='.$cle ;
				$href.= '&menu='.$menu.'&cmd='.$cmd.'" ' ;
				$status = Status($val);
				$link = '<a class="HEADER1" target="FrmMain" '.$href.$status.'>'.Replace("| ".$val).'</a>';
				put ('     <td bgcolor="'.$color2.'">'.$link.'</td></tr>');
			}
		}
	}

	/**
	* Cre un menu de slection d'actions
	* @param	array	$label	tableau des intituls des menus d'actions
	* @access	public
	*/	
	function menuSelection($label,$image=array()) {
	 global $connexion, $ext, $menu, $cmd, $evx_menu, $evx_act;
	 global $color1, $color2;

	 	if ( $menu == MENU_EMPTY ) { $menu = MENU_TDB ; }
	 	// longueur du tableau des intituls des menus d'actions
		$longLabel = count($label);
		$larg = floor(100 / $longLabel);

		put('<center>');		
		put('<table width="100%" align="left" border="0" cellspacing="0" cellpadding="5">')	;

		// affichage des liens
		put('  <tr align="center" bgColor="'.$color2.'" >');
		for ($i=0; $i<$longLabel; $i++) {
			// style du menu
			$bgcolor = 	($evx_act == $i ? $color1: $color2 )   ;
			$class   =  ($evx_act == $i ? "HEADER2": "HEADER1");
			// statut
			$status = Status($label[$i]);
			// url
			$href = HTTP_TUTEUR.'index'.$ext.'?connexion='.$connexion.'&evx_menu='.$evx_menu.'&evx_act='.$i ;
			$href.= '&menu='.$menu.'&cmd='.$cmd;
			$img = (isset($image[$i])?$image[$i].'&nbsp;':'');
			$link = '<a href="'.$href.'" target="FrmMain" class="'.$class.'" '.$status.'>'.$img.$label[$i].'</a>';
			// affichage
			put('    <td width="'.$larg.'%" bgColor="'.$bgcolor.'">'.$link.'</td>');
		}
		put('  </tr>')	;
		put('</table>')	;
		put('</center>');
	}

	/**
	* affiche les pages correspondant  la requte
	* @access	public
	*/
	function routage() {
	 global $evx_menu, $evx_act, $confirm;
	 	if (!isset($confirm)) {
			if ($evx_menu != MENU_EVX_ASS) {
	 			switch ($evx_act) {
					case "1" : ($evx_menu==MENU_EVX_MNG) ? modifierEval(): modifierRapport(); break;
					case "2" : ($evx_menu==MENU_EVX_MNG) ? supprimerEval(): supprimerRapport(); break;
					case "3" : consulterRapport(); break;
					default  : ($evx_menu==MENU_EVX_MNG) ? creerEval(): creerRapport(); break;
				}
			} else {
				($evx_act==1) ? supprSession(): assignerEval();
			}
		} elseif ($confirm==2) {
			traitement();
		} else {
			confirmation();
		}
	}

	// confirmation
	/**
	* demande de confirmation des requtes
	* @access	public
	*/
	function confirmation() {
	 global $connexion, $ext, $cmd, $menu, $evx_menu, $evx_act;
	 global $tu_table, $HTTP_POST_VARS;
	 global $ClsEvalanx, $ClsGroupe, $ClsMembre;
	 	// le tableau $data contiendra les donnes  traiter
		// le tableau $conf contiendra les donnes  afficher pour la confirmation

		if ($evx_menu != MENU_EVX_ASS) {
	 		switch ($evx_act) {
			case "1" : 
				if ($evx_menu==MENU_EVX_MNG) {
					// modifier eval
					$data=array("id" => $HTTP_POST_VARS["LEval"], 
								$tu_table['nomeval'] => $HTTP_POST_VARS["text0"], 
								$tu_table['contexte'] => $HTTP_POST_VARS["textarea1"]);
					$conf=$data;
				} else {
					// modifier rapport
					$data=array();
					// Attention $$HTTP_POST_VARS["LEval"] contient l'id du rapport et non celui de l'valuation
					$data["id"] = $HTTP_POST_VARS["LEval"];
					$data[$tu_table['nomeval']] = $HTTP_POST_VARS["LEval"];
					$data[$tu_table['grpname']] = $HTTP_POST_VARS["LGroupe"];
					$data[$tu_table['staggpe']] = $HTTP_POST_VARS["LStagiaire"];
					$data[$tu_table['nomevalu']]= $HTTP_POST_VARS["LTuteur"];
					$data[$tu_table['evaldate']]= mktime(0,0,0,Unreplace($HTTP_POST_VARS["text1"]),Unreplace($HTTP_POST_VARS["text2"]),Unreplace($HTTP_POST_VARS["text3"]));
					$data[$tu_table['contexte']]= $HTTP_POST_VARS["textarea4"];
					$data[$tu_table['statut']] 	= $HTTP_POST_VARS["LStatut"];								
					$data[$tu_table['temps']] 	= mktime(Unreplace($HTTP_POST_VARS["text5"]),Unreplace($HTTP_POST_VARS["text6"]),0,1,1,1);
					$data[$tu_table['comment']] = $HTTP_POST_VARS["textarea7"];
					//
					$conf=array();
					$conf["id"] = $HTTP_POST_VARS["LEval"];
					$conf[$tu_table['nomeval']] = $ClsEvalanx->getNomEval($HTTP_POST_VARS["LEval"]);
					$conf[$tu_table['grpname']] = $ClsGroupe->Name($HTTP_POST_VARS["LGroupe"]);
					$conf[$tu_table['staggpe']] = $ClsMembre->GetPrenom($HTTP_POST_VARS["LStagiaire"])." ".$ClsMembre->GetNom($HTTP_POST_VARS["LStagiaire"]);
					$conf[$tu_table['nomevalu']]= $ClsMembre->GetPrenom($HTTP_POST_VARS["LTuteur"])." ".$ClsMembre->GetNom($HTTP_POST_VARS["LTuteur"]);
					$conf[$tu_table['evaldate']]= $HTTP_POST_VARS["text1"]."/".$HTTP_POST_VARS["text2"]."/".$HTTP_POST_VARS["text3"];
					$conf[$tu_table['contexte']]= $HTTP_POST_VARS["textarea4"];
					$conf[$tu_table['statut']] 	= ($HTTP_POST_VARS["LStatut"]==1) ? $tu_table["acquis"]: $tu_table["nonacquis"];
					$conf[$tu_table['temps']] 	= $HTTP_POST_VARS["text5"]." : ".$HTTP_POST_VARS["text6"];
					$conf[$tu_table['comment']]	= $HTTP_POST_VARS["textarea7"];
				}
				break;
			case "2" : 	
				if ($evx_menu==MENU_EVX_MNG) {
					// supprimer eval
					$data=array($tu_table['nomeval'] => $HTTP_POST_VARS["LEval"]);
					//
					$tNomEval=array();
					$lgEval = count($HTTP_POST_VARS["LEval"]);
					for ($i=0; $i<$lgEval; $i++) {
						$tNomEval[$i] = $ClsEvalanx->getNomEval($HTTP_POST_VARS["LEval"][$i]);
					}
					$conf = array($tu_table['nomeval'] => $tNomEval);
				} else {
					// supprimer rapport
					// Attention $HTTP_POST_VARS["LEval"] contient l'id du rapport et non celui de l'valuation
					$data=array("id" => $HTTP_POST_VARS["LEval"]);
					//
					$conf=$data;
				}
				break;
			// case "3" : affichage(); break;
			default  : 	
				if ($evx_menu==MENU_EVX_MNG) {
					// crer eval
					$data = array($tu_table['nomeval'] => $HTTP_POST_VARS["text0"], 
					              $tu_table['contexte'] => $HTTP_POST_VARS["textarea1"]);

					$conf=$data;
				} else {
					// crer rapport
					$data=array();
					$data[$tu_table['nomeval']] = $HTTP_POST_VARS["LEval"];
					$data[$tu_table['grpname']] = $HTTP_POST_VARS["LGroupe"];
					$data[$tu_table['staggpe']] = $HTTP_POST_VARS["LStagiaire"];
					$data[$tu_table['nomevalu']]= $HTTP_POST_VARS["LTuteur"];
					$data[$tu_table['evaldate']]= mktime(0,0,0,Unreplace($HTTP_POST_VARS["text2"]),Unreplace($HTTP_POST_VARS["text1"]),Unreplace($HTTP_POST_VARS["text3"]));
					$data[$tu_table['contexte']]= $HTTP_POST_VARS["textarea4"];
					$data[$tu_table['statut']] 	= $HTTP_POST_VARS["LStatut"];								
					$data[$tu_table['temps']] 	= mktime(Unreplace($HTTP_POST_VARS["text5"]),Unreplace($HTTP_POST_VARS["text6"]),0,1,1,1);
					$data[$tu_table['comment']] = $HTTP_POST_VARS["textarea7"];
					//
					$conf=array();
					$conf[$tu_table['nomeval']] = $ClsEvalanx->getNomEval($HTTP_POST_VARS["LEval"]);
					$conf[$tu_table['grpname']] = $ClsGroupe->Name($HTTP_POST_VARS["LGroupe"]);
					$conf[$tu_table['staggpe']] = $ClsMembre->GetPrenom($HTTP_POST_VARS["LStagiaire"])." ".$ClsMembre->GetNom($HTTP_POST_VARS["LStagiaire"]);
					$conf[$tu_table['nomevalu']]= $ClsMembre->GetPrenom($HTTP_POST_VARS["LTuteur"])." ".$ClsMembre->GetNom($HTTP_POST_VARS["LTuteur"]);
					$conf[$tu_table['evaldate']]= $HTTP_POST_VARS["text1"]."/".$HTTP_POST_VARS["text2"]."/".$HTTP_POST_VARS["text3"];
					$conf[$tu_table['contexte']]= $HTTP_POST_VARS["textarea4"];
					$conf[$tu_table['statut']] 	= ($HTTP_POST_VARS["LStatut"]==1) ? $tu_table["acquis"]: $tu_table["nonacquis"];
					$conf[$tu_table['temps']] 	= $HTTP_POST_VARS["text5"]." : ".$HTTP_POST_VARS["text6"];
					$conf[$tu_table['comment']] = $HTTP_POST_VARS["textarea7"];
				}
				break;
			}
		} else {
			// assignation
			if ($evx_act != 1) {
				$data = array($tu_table['grpname'] => $HTTP_POST_VARS["LGroupe"], 
							  $tu_table['nomeval'] => $HTTP_POST_VARS["LEval"], 
							  $tu_table['staggpe'] => $HTTP_POST_VARS["LStagiaire"]);
				//
				$tNomEval=array();
				$lgEval = count($HTTP_POST_VARS["LEval"]);
				for ($i=0; $i<$lgEval; $i++) {
					$tNomEval[$i] = $ClsEvalanx->getNomEval($HTTP_POST_VARS["LEval"][$i]);
				}
				$tStag=array();
				$lgStag = count($HTTP_POST_VARS["LStagiaire"]);
				for ($i=0; $i<$lgStag; $i++) {
					$tStag[$i] = $ClsMembre->GetPrenom($HTTP_POST_VARS["LStagiaire"][$i])." ".$ClsMembre->GetNom($HTTP_POST_VARS["LStagiaire"][$i]);
				}
				$conf = array($tu_table['grpname'] => $ClsGroupe->Name($HTTP_POST_VARS["LGroupe"]), 
				              $tu_table['nomeval'] => $tNomEval, 
				              $tu_table['staggpe'] => $tStag);

			// suppression de session
			} else {
				$data = array($tu_table['staggpe'] => $HTTP_POST_VARS["LStagiaire"], 
				              $tu_table['nomeval'] => $HTTP_POST_VARS["LEval"]);
				//
				$tNomEval=array();
				$lgEval = count($HTTP_POST_VARS["LEval"]);
				for ($i=0; $i<$lgEval; $i++) {
					$tNomEval[$i] = $ClsEvalanx->getNomEval($HTTP_POST_VARS["LEval"][$i]);
				}
				$stag = $ClsMembre->GetPrenom($HTTP_POST_VARS["LStagiaire"])." ".$ClsMembre->GetNom($HTTP_POST_VARS["LStagiaire"]);
				$conf = array($tu_table['staggpe'] => $stag, $tu_table['nomeval'] => $tNomEval);
			}
		}
		// affichage des donnes
		affichage($data, $conf);
	}

	/**
	* affichage des donnes de requtes
	* @param	array	$data	tableau de donnes  traiter
	* @param	array	$conf	tableau de donnes  afficher pour confirmation
	* @access	public
	*/
	function affichage($data,$conf) {
	 global $connexion, $ext, $cmd, $menu, $evx_menu, $evx_act;
	 global $color1, $color2, $color1a, $color2a;
	 global $tu_titre, $tu_table, $HTTP_POST_VARS;
	 	// url d'action du formulaire
		$url = HTTP_TUTEUR.'index'.$ext.'?connexion='.$connexion.'&evx_menu='.$evx_menu.'&evx_act='.$evx_act;
		$url.= '&confirm=2&menu='.$menu.'&cmd='.$cmd;

	 	// tableau rfrenant les intituls des boutons  afficher suivant le type d'action
		$bt = array($tu_titre["enregistrer"],$tu_titre["enregistrer"],$tu_titre["supprimer"]);
		$lgconf = count($conf);

		BeginBorder("80%",$color1);

		put(' <table width="100%" border="0" cellspacing="0" cellpadding="5" bgcolor="'.$color2.'">');
		put('  <tr align="middle">');
		put('   <td><p class="s_titre"><font color="ffffff">'.$tu_table['confirmation'].'</font></p> </td>');
		put('  </tr>');
		put(' </table>');

		put(' <table width="100%" border="0" cellspacing="1" cellpadding="5" bgcolor="#FFFFFF">');

		// affichage des donnes traites
		reset($conf);
		while (list($cle, $val) = each($conf)) {
			$bgcolor = ($bgcolor == $color2a ? $color1a: $color2a );
			if (gettype($val)=="string") {
				put(' <tr valign="top" align="left">');
				put('  <td bgcolor="'.$bgcolor.'" width="30%"><b>'.$cle.'</b></td>');
				put('  <td bgcolor="'.$bgcolor.'" width="70%">'.nl2br(CSS(Unreplace($val))).'</td>');
				put(' </tr>');
			} elseif (gettype($val)=="array") {
				$lgval = count($val);
				$flag = true;
				for ($i=0; $i < $lgval; $i++) { 
					// affichage titre + donnes
					if ($flag) {
						put('        <tr align="left">');
						put('          <td bgcolor="'.$bgcolor.'" width="30%"><b>'.$cle.'</b></td>');
						put('          <td bgcolor="'.$bgcolor.'" width="70%">'.Unreplace($val[$i]).'</td>');
						put('        </tr>');
						$flag = false;

					// affichage donnes seules
					} else {
						put('        <tr align="left">');
						put('          <td bgcolor="'.$bgcolor.'" width="30%">&nbsp;</td>');
						put('          <td bgcolor="'.$bgcolor.'" width="70%">'.Unreplace($val[$i]).'</td>');
						put('        </tr>');
					}
				}
			}
		}

		put('<form action="'.$url.'" method="POST">');
		put('		<tr bgcolor="'.$color2.'" align="right">');
		put('          <td>&nbsp;</td>');
		put('          <td>');

		// ajout de boutons d'action
		AjoutBouton($bt[$evx_act],0,"submit()");
		put('&nbsp;&nbsp;');
		AjoutBouton("Annuler",1,"window.history.go(-1)");

		put('	      </td>');
		put('        </tr>');

		// ajout de champs cachs contenant les donnes  transfrer
		AjoutHiddenRec($data);
		// pour l'assignation ajout de 2 champs cachs contenant les nombres d'valuations
		// et de stagiaires slectionns
		if ($evx_menu==MENU_EVX_ASS) {
			AjoutHidden("lgEval",count($HTTP_POST_VARS["LEval"])) 	;
			AjoutHidden("lgStag",count($HTTP_POST_VARS["LStagiaire"]));
		}

		put('</form>');
		put('        </table>');
		CloseBorder();
		BR(2);
	}

// traitement des donnes
	/**
	* effectue le traitement des requtes
	* @access	public
	*/
	function traitement() {
	 global $connexion, $ext, $cmd, $menu, $evx_menu, $evx_act;
	 global $ClsEvalanx, $HTTP_POST_VARS;

	 	if ($evx_menu != MENU_EVX_ASS) {
	 		switch ($evx_act) {
			case "1" : 	
				if ($evx_menu==MENU_EVX_MNG) {
					// modifier eval
					$ClsEvalanx->modify($HTTP_POST_VARS['champ'][0],$HTTP_POST_VARS['champ'][1],$HTTP_POST_VARS['champ'][2]);
				} else {
					// modifier rapport
					// id rapport
					$idrap = $HTTP_POST_VARS['champ'][0];
					// id valuation
					$ideval = $ClsEvalanx->getIdEval($idrap);
					// id stagiaire
					$ids = $HTTP_POST_VARS['champ'][3];
					// id valuateur
					$idtut = $HTTP_POST_VARS['champ'][4];
					// formatage date
					$date = $HTTP_POST_VARS['champ'][5];
					// statut
					$statut = $HTTP_POST_VARS['champ'][7];
					// formatage temps
					$tps = $HTTP_POST_VARS['champ'][8];
					// commentaires
					$obs = $HTTP_POST_VARS['champ'][9];
					// transfert BdD
					$ClsEvalanx->modifyReport($idrap, $ideval, $ids, $idtut, $date, $statut, $tps, $obs);
				}
				break;
			case "2" : 	
				if ($evx_menu==MENU_EVX_MNG) {
					// supprimer eval
					$lgid = count($HTTP_POST_VARS['champ']);
					for($i=0; $i < $lgid; $i++) {
						$ClsEvalanx->delete($HTTP_POST_VARS['champ'][$i]);
					}
				} else {
					// supprimer rapport
					$lgid = count($HTTP_POST_VARS['champ']);
					for($i=0; $i < $lgid; $i++) {
						$ClsEvalanx->deleteReport($HTTP_POST_VARS['champ'][$i]);
					}
				}
				break;
			// case "3" : affichage()								; break;
			default  : 	
				if ($evx_menu==MENU_EVX_MNG) {
					// crer eval
					$ClsEvalanx->add($HTTP_POST_VARS['champ'][0],$HTTP_POST_VARS['champ'][1]);
				} else {
					// crer rapport
					// id valuation
					$ideval = $HTTP_POST_VARS['champ'][0];
					// id stagiaire
					$ids = $HTTP_POST_VARS['champ'][2];
					// id valuateur
					$idtut = $HTTP_POST_VARS['champ'][3];
					// formatage date
					$date = $HTTP_POST_VARS['champ'][4];
					// statut
					$statut = $HTTP_POST_VARS['champ'][6];
					// formatage temps
					$tps = $HTTP_POST_VARS['champ'][7];
					// commentaires
					$obs = $HTTP_POST_VARS['champ'][8];
					// transfert BdD
					$ClsEvalanx->addReport($ideval, $ids, $idtut, $date, $statut, $tps, $obs);
				}
				break;
			}
		} else {
			// assignation
			if ($evx_act != 1) {
				// id groupe
				$idgpe = $HTTP_POST_VARS['champ'][0];
				// tableau d'valuations
				$tabEval = array();
				$fst = 1;
				$lst = $HTTP_POST_VARS['lgEval'];
				for ($i=0; $i<$lst; $i++) {
					$tabEval[$i] = $HTTP_POST_VARS['champ'][$i+$fst];
				}
				// tableau des stagiaires
				$tabStag = array();
				$fst = $fst+$lst;
				$lst = $HTTP_POST_VARS['lgStag'];
				for ($i=0; $i<$lst; $i++) {
					$tabStag[$i] = $HTTP_POST_VARS['champ'][$i+$fst];
				}
				// assignation des valuations
				$ClsEvalanx->setEval($idgpe, $tabStag, $tabEval);
				
			// suppression de sessions	
			} else {
				// id stagiaire
				$idStag = $HTTP_POST_VARS['champ'][0];
				// tableau d'valuations
				$tabEval = array();
				$fst = 1;
				$lst = $HTTP_POST_VARS['lgEval'];
				for ($i=0; $i<$lst; $i++) {
					$tabEval[$i] = $HTTP_POST_VARS['champ'][$i+$fst];
				}
				// assignation des valuations
				$ClsEvalanx->deleteEval($idStag, $tabEval);
			}
		}
		// redirection automatique
		$url = HTTP_TUTEUR.'index'.$ext.'?connexion='.$connexion.'&evx_menu='.$evx_menu.'&evx_act='.$evx_act;
		$url.= '&menu='.$menu.'&cmd='.$cmd;
		put("<script>window.location.href='".$url."'</script>");
	}

?>