<?PHP
/* vim: set expandtab tabstop=4 shiftwidth=4: */
// +----------------------------------------------------------------------------+
// | <G a n e s h a> - Free Web Based Training System                           |
// +----------------------------------------------------------------------------+
// | <G a n e s h a> - Plate-forme de tlformation gratuite et en open source  |
// +----------------------------------------------------------------------------|
// | Copyright (C) 2001-2003  Anma Formation  <http://www.anema.fr/>           |
// +----------------------------------------------------------------------------+
// |           Developer : Georges CALDEIRA <gcaldeira@anemalab.org>            |
// +----------------------------------------------------------------------------+
// |              Infos on project <http://anemalab.org/>                       |
// +----------------------------------------------------------------------------+
// | This program is free software; you can redistribute it and/or modify       |
// | it under the terms of the GNU General Public License as published by       |
// | the Free Software Foundation; either version 2 of the License, or          |
// | (at your option) any later version.                                        |
// |                                                                            |
// | This program is distributed in the hope that it will be useful,            |
// | but WITHOUT ANY WARRANTY; without even the implied warranty of             |
// | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              |
// | GNU General Public License for more details.                               |
// |                                                                            |
// | You should have received a copy of the GNU General Public License          |
// | along with this program; if not, write to the Free Software                |
// | Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA   |
// +----------------------------------------------------------------------------+

/**
* Liste de fonctions pour la gestion des tags HTML
*
* @author		Georges Caldeira <gcaldeira@anemalab.org>
* @package		GaneshaInc
*/

	/**
	* Affiche le nombre $nb de br
	* @param	integer	$nb	nombre de br a afficher
	* @access	public
	*/
	function BR($nb=1){ 
		for ($i=1; $i<=$nb; $i++) {
			put("<br>");
		}
	}

	/**
	* Affiche la balise UL
	* @access	public
	*/
	function UL(){ put("<ul>"); }

	/**
	* Affiche la balise /UL
	* @access	public
	*/
	function _UL(){ put("</ul>"); }

	/**
	* Affiche la balise LI
	* @access	public
	*/
	function LI($texte=''){ 
		if ( $texte == '' ) {
			put("<li>"); 
		} else {
			put("<li>".$texte."</li>"); 
		}
	}

	/**
	* Affiche la balise /LI
	* @access	public
	*/
	function _LI(){ put("</li>"); }

	/**
	* Genere un jeu de Frames avec comme page principale $url 
	* @param	string	$titre	Titre de la page
	* @param	string	$url	URL de la page principale
	* @access	public
	*/
	function FrameSet($titre, $url) {
	 global $gconnexionid, $menu, $ext;
		put('<html>
	<head>
	<title>'.$titre.'</title>
	</head>');
		put( '<frameset border="0" framespacing="0" rows="97,100%" frameborder="NO">');
		put( '<frame name="FrmHeader" marginWidth="0" marginHeight="0" target="_top" scrolling="NO" 	src="'.HTTP_COMMUN.'p_header'.$ext.'?connexion='.$gconnexionid.'&menu='.$menu.'" noresize>');
		put('<frame name="FrmMain" target="_top" src="'.$url.'" marginwidth="0" marginheight="0">');
		put('</frameset>');
		put('</html>');
	}

	/**
	* Genere le code html de fermeture d'une page 
	* @access	public
	* @see		InitPageHtml(), InitPageHtmlNoCache()
	*/
	function ClosePageHtml() {
		BR(2);
		put_debug("&copy; 2000-2003 Anma Formation");
		put("</body></html>");
	}

	/**
	* Genere le header html
	* @param	string	$titre	Titre de la page ( par defaut Ganesha )
	* @param	boolean	$cache	page sans cache
	* @access	public
	*/
	function headerHtml($titre="Ganesha",$cache=false) {
		global $charset ;
		put('<html>');
		put('<head>');
		put('<title>'.$titre.'</title>');
		if ( $cache ) {
			put('<meta http-equiv="Pragma" content="no-cache">')		;
			put('<meta http-equiv="Cache-Control" content="no-cache">')	;
			put('<meta http-equiv="Expires" content="0">')				;
		}
		put('<meta http-equiv="Content-Type" content="text/html; charset='.$charset.'">');
	}
	
	/**
	* Genere le code html de personnalisation de la balise body
	* @access	public
	*/
	function customBody() {
		global $color1, $color2 ;
		put('<style type="text/css">');
		put('<!--');
		put('body { scrollbar-face-color: '.$color1.'; scrollbar-highlight-color: #ffffff; scrollbar-shadow-color: silver; scrollbar-3dlight-color: silver; scrollbar-arrow-color: #ffffff; scrollbar-track-color: white; scrollbar-darkshadow-color: '.$color2.'  }');
		put('// -->');
		put('</style>');
	}

	/**
	* Genere le code html pour la balise body
	* @access	public
	*/
	function includeBody($cacheOff=false) {
		global $BodyColor, $header ;
		$onload = ($cacheOff==true?'onLoad="cacheOff();"':'');
		put('</head>');
		put('<body bgColor="'.$BodyColor.'" topmargin="0" marginheight="0" leftmargin="0" marginwidth="0" '.$onload.'>');
		if ( $cacheOff ) {
			put ('<style type="text/css">
<!--   
#cache {position:absolute; top:200px; z-index:10; visibility:hidden;}
//-->
</style>
<div id="cache">
<table width="400" bgcolor="#000000" border="0" cellpadding="2" cellspacing="0">
  <tr>
     <td align="center" valign="middle">
      <table width="100%" bgcolor="#FFFFFF" border="0" cellpadding="0" cellspacing="0">
	    <tr>
		  <td align="center" valign="middle"><font face="Verdana" size="4" color="#000000"> <br>'.$header['wait'].'<br><br></font></td>
		</tr>
	  </table>
	 </td>
  </tr>
</table>
</div>

<script language="JavaScript">
/* http://www.editeurjavascript.com */
var nava = (document.layers);
var dom = (document.getElementById);
var iex = (document.all);
if (nava) { cach = document.cache }
else if (dom) { cach = document.getElementById("cache").style }
else if (iex) { cach = cache.style }
largeur = screen.width;
cach.left = Math.round((largeur/2)-200);
cach.visibility = "visible";

function cacheOff()
	{
	cach.visibility = "hidden";
	}
</script>');
		}				
	}
		
	/**
	* Genere le code html pour inclure les javascripts
	* @access	public
	*/
	function includeJavaScript() {
		$lang = explode('.',GLANG) ;
		put('<script language="JavaScript" src="'.HTTP_SCRIPT.$lang[0].'.js"></script>');
		put('<script language="JavaScript" src="'.HTTP_SCRIPT.'fonctions.js"></script>');
		put('<script language="JavaScript" src="'.HTTP_SCRIPT.'admin.js"></script>');
		put('<script language="JavaScript"> ');
		put('<!--');
		put('window.defaultStatus="Ganesha '.VERSION.'";');
		put('//-->');
		put('</script>');
	}

	/**
	* Genere le code html pour recharger la page appelante
	* @access	public
	*/
	function includeJavaScriptOpenerReload() {
		put('<script language="JavaScript">');
		put('<!--');
		put('window.opener.location.reload()');
		put('//-->');
		put('</script>');
	}

	/**
	* Affiche le css courant
	* @access	public
	*/
	function stylesheet() { 
		global $gfilecss ;
		$gfilecss = ( $gfilecss==''?'anema':$gfilecss ) ;
		if ( ! OPT_SKIN_ACTIVE) {
			$gfilecss = 'default' ;
		} 
		echo '<link href="'.HTTP_SKIN.$gfilecss.'/ganesha.css" rel="stylesheet">' ;
	}

	/**
	* Genere le code html jusqu'a la balise <body>
	* @param	string	$titre	Titre de la page ( par defaut Ganesha )
	* @param	string	$option	Option a mettre dans la balise <body ...> 
	* @access	public
	* @see		ClosePageHtml()
	*/
	function InitPageHtmlOpenerReload( $titre="Ganesha") {
	 global $BodyColor ;	 
		put_copyright();		
		headerHtml($titre);
		stylesheet();				
		customBody();	
		includeJavaScript();
		includeJavaScriptOpenerReload();	
		includeBody();
	}

	/**
	* Genere le code html jusqu'a la balise <body>
	* @param	string	$titre	Titre de la page ( par defaut Ganesha )
	* @param	string	$option	Option a mettre dans la balise <body ...> 
	* @access	public
	* @see		ClosePageHtml()
	*/
	function InitPageHtml( $titre="Ganesha", $layer=true) {
		put_copyright();
		$cacheOff = ($layer==true?'onLoad="cacheOff();"':'');
		headerHtml($titre);
		stylesheet();
		customBody();
		includeJavaScript();
		includeBody($layer);
	}

	/**
	* Genere le code html jusqu'a la balise <body> avec les 
	* META pour ne pas gerer la page dans le cache
	* @param	string	$option	Option a mettre dans la balise <body ...>
	* @access	public
	* @see		ClosePageHtml()
	*/
	function InitPageHtmlNoCache( $titre="Ganesha") {
		put_copyright();
		headerHtml($titre,true);
		stylesheet();
		customBody();
		includeJavaScript();
		includeBody();
	}

	/**
	* Force l'affichage de la page p_error.php(3) 
	* @access	public
	*/
	function PageErreur() {
	 global $ext;
		Header("Location: ".HTTP_COMMUN."p_error".$ext); 
		exit(); 
	}

	/**
	* Force l'affichage d'une nouvelle page
	* @param	string	$url	URL de la npuvelle page
	* @access	public
	*/
	function location($url) {
		header("Location: ".$url); 
		exit(); 
	}
	
	/**
	* Genere le code JavaScript pour la fermeture d'une fenetre
	* @access	public
	*/
	function CloseWindow() {
	 global $color1 ;
	 global $st_titre ;
		$texte = $st_titre['fermer'];
		$link  = "JavaScript:self.close();"	;
		put('	<br>')	;
		put('	<br>')	;
		put('	<table width="100%" border="0" cellspacing="5" cellpadding="5">')	;
		put('	<tr bgColor="'.$color1.'">')										;
		put('	 <td align="center" class="title2"> <a href="'.$link.'" class="student">'.$texte.'</a></td>') ;
		put('	</tr>')		;
		put('	</table>')	;
	}

	/**
	* Genere le code JavaScript pour le retour a la page precedente
	* @access	public
	*/
	function BackWindow() {
	 global $color1 ;
	 global $st_titre ;
		$texte = $st_titre['retour'] ;
		$link  = "JavaScript:window.history.back();" ;
		put('	<br>')	;
		put('	<br>')	;
		put('	<table width="100%" border="0" cellspacing="5" cellpadding="5">')	;
		put('	<tr bgColor="'.$color1.'">')	;
		put('	 <td align="center" class="title2"> <a href="'.$link.'" class="student">'.$texte.'</a></td>') ;
		put('	</tr>')		;
		put('	</table>')	;
	}

	/**
	* Affiche un sous titre 
	* @param	string	$title	Titre a afficher
	* @param	string	$width	Taille de la zone
	* @access	public
	*/
	function SubTitle($title, $width="230" ) {
	 global $color2 ;
		put('<table width="'.$width.'" border="0" cellspacing="5" cellpadding="5">');
		put(' <tr>')	;
		put('  <td bgColor="'.$color2.'" class="title2">&nbsp;'.$title.'</td>')	;
		put(' </tr>')	;
		put('</table>')	;
	}

	/**
	* Affiche un sous titre avec une image
	* @param	string	$title	Titre a afficher
	* @param	string	$width	Taille de la zone
	* @access	public
	*/
	function SubTitleImage($title, $image, $width="230" ) {
	 global $color2 ;
		put('<table width="'.$width.'" border="0" cellspacing="3" cellpadding="0">');
		put(' <tr><td>')	;	 
		put(' <table width="'.$width.'" border="0" cellspacing="0" cellpadding="3">');
		put(' <tr valign="middle" align="center">')	;
		put('  <td valign="middle" align="right" bgColor="'.$color2.'" >&nbsp;'.$image.'</td>')	;		
		put('  <td valign="middle" align="left" bgColor="'.$color2.'" class="title2">'.$title.'</td>')	;
		put(' </tr>')	;
		put(' </table>')	;
		put('</td><tr>');	 		
		put('</table>')	;	 
	}

	/**
	* Affiche un titre principale 
	* @param	string	$title	Titre a afficher
	* @param	string	$width	Taille de la zone
	* @access	public
	*/
	function Title( $title, $width="100%") {
	 global $color1 ;
		put('	<table width="'.$width.'" border="0" cellspacing="0" cellpadding="5">')	;
		put('	  <tr>')	;
		put('		<td bgColor="'.$color1.'" class="title1"> '.$title.' </td>')	;
		put('	  </tr>')	;
		put('	</table>')	;
		put('	<br><br>')	;
	}

	/**
	* Genere le code JavaScript pour la gestion de la barre Status
	* @param	string	$text	Texte a affiche
	* @access	public
	*/
	function Status( $text = "" ) {
		$vers = 'Ganesha '.VERSION ;
		if ( $text == "" ) {
			$text = $vers ;
		}
		$text = addslashes($text) ;
		$over = ' onMouseOver="window.status=\''.$text.'\';return true;" ';
		$out  = ' onMouseOut="window.status=\''.$vers.'\';return true;" ' ; 
		return($over." ".$out);
	}

	/**
	* Affiche le menu du bas de chaque page avec les credits, <c>, ...
	* @access	public
	*/
	function Footer() {
	 global $gfilecss, $ext, $color1, $color2 ;
	 global $st_texte ;
		$style = HTTP_SKIN.($gfilecss==""?"anema.css":$gfilecss) ;
		$param = $ext."?style=".urlencode($style)."&color1=".urlencode($color1)."&color2=".urlencode($color2) ;
		$conf  = 'scrollbars=yes,width=420,height=400';
		put('
	<table border="0" cellspacing="0" cellpadding="0" align="center">
	  <tr valign="top">
		<td width="100%">
		 <div align="center" class="small">
		  <HR size="1" noshade width="80%" align="center">
		  &copy; 2000-2003 An&eacute;ma Formation<br>
		  <a class="slink" href="#" onClick="openWindow(\''.HTTP_COM.'copyright'.$param.'\',\'fent\',\''.$conf.'\')" '.Status("Copyright Ganesha").'  >'.$st_texte['copyright'].'</a>
		  | <a class="slink" href="#" onClick="openWindow(\''.HTTP_COM.'anemalab'.$param.'\',\'fent\',\''.$conf.'\')" '.Status("AnemaLab.org").' >'.$st_texte['anemalab'].'</a>
		  | <a class="slink" href="#" onClick="openWindow(\''.HTTP_COM.'outils'.$param.'\',\'fent\',\''.$conf.'\')" '.Status("Trousse &agrave; outils").' >'.$st_texte['trousse'].'</a>
		  | <a class="slink" href="#" onClick="openWindow(\''.HTTP_COM.'credits'.$param.'\',\'fent\',\''.$conf.'\')" '.Status("Cr&eacute;dits Ganesha").' >'.$st_texte['credits'].'</a>
		  </div>
		</td>
	  </tr>
	</table>');
	}

	/**
	* Genere le code Javascript pour la selection automatique sur une Liste
	*
	* @param	string	$name	Message a afficher
	* @access	public
	*/
	function BeginSelect($name) {
		put('<select name="'.$name.'" class="combo1" size="1" onchange="parent.parent.window.location.href=this.options[this.selectedIndex].value">');
	}

	/**
	* ferme le code html d'une Liste
	* @access	public
	*/
	function EndSelect(){
		put("</select>");
	}

	/**
	* Ajoute une selection a une Liste
	* @param	string	$text	Texte affiche dans la liste
	* @param	string	$value	Valeur associe a l'element 
	* @param	string	$selected	Indique si l'element est selectionne
	* @access	public
	*/
	function AddSelectValue($text,$value,$selected="") {
		$text = Unreplace($text) ;
		put('<option value="'.$value.'" '.$selected.'>'.$text.'</option>');
	}

	/**
	* dessine une bordure autour d'un tableau
	* @param	string	$width	taille de la bordure
	* @param	string	$color	couleur de la bordure
	* @param	string	$text	texte a afficher en titre
	* @access	public
	*/
	function BeginBorder($width,$color,$text='') {
		put('<table align="center" width="'.$width.'" border="0" cellspacing="0" cellpadding="1" bgcolor="'.$color.'">');
		if ( $text != '' ) {
			put('<tr align="middle"><td>'.$text.'</td></tr>');			
		} 
		put('<tr><td>');
		
	}

	/**
	* ferme la bordure autour d'un tableau
	* @access	public
	*/
	function CloseBorder() {
		put('</td></tr>');
		put('</table>')	;
	}

	/**
	* place un ancre nomme
	* @param	string	$anchor	nom de l'ancre nomme
	* @access	public
	*/
	function Anchor($anchor) {
		put('<a name="'.$anchor.'"></a>');
	}

	/**
	* place un lien vers un ancre nomme
	* @param	string	$text	texte du lien
	* @param	string	$anchor	valeur de l'ancre nomme
	* @param	boolean	$center	centrer le texte
	* @access	public
	*/
	function LinkAnchor($text,$anchor,$center=false) {
		if ( $center) {
			put('<center><a class="student" href="#'.$anchor.'">'.$text.'</a></center>');
		} else {
			put('<a class="student" href="#'.$anchor.'">'.$text.'</a>');
		}
	}

	/**
	* Affiche une page avec un message et arrete le script.
	* @param	string	$msg Message a afficher dans la page
	* @access	public
	*/
	function PageMessageErreur($msg,$url='') {
		global $st_titre, $tu_titre ;
		put('<html>');
		put('<head>');
		put('<title>Message</title>');
		put('</head>');
		put('<body bgColor="#FFFFFF">');
		BR(3);
		put('<center><h2>'.$msg.'</h2></center>');
		BR(2) ;
		if ( $url == '' ) {
			put('<i><center><a href="javascript:history.go(-1)">-'.$st_titre['retour']	.'-</a></center></i>');
		} else {
			put('<i><center><a href="'.$url.'">-'.$tu_titre['paccueil'].'-</a></center></i>');			
		}
		put('</body>');
		put('</html>');
		exit;
	}

	/**
	* Initialise un tableau HTML
	* @param	string	$cellpadding	valeur du cellpadding de la table
	* @param	string	$cellspacing	valeur du cellspacing de la table
	* @access	public
	*/
	function InitTableau($cellpadding=0,$cellspacing=1){
		global $color2 ;
		put('<table width="80%" border="0" cellPadding="1" cellSpacing="1" align="center" bgcolor="'.$color2.'" >');
		put('<tr ><td>');
		put('  <table width="100%" align="top" border="0" cellspacing="'.$cellspacing.'" cellpadding="'.$cellpadding.'" bgcolor="#FFFFFF" bordercolor="#FFFFFF" >');
	}

	/**
	* Affiche un titre d'une colonne dans un tableau 
	* @param	string	$titre	Titre de la colonne
	* @param	string	$width	Taille de la colonne
	* @param	string	$color	valeur de la couleur
	* @access	public
	*/
	function TitreTableau($titre,$width,$color='') { 
		global $color2;
		$color = ($color==''?$color2:$color);
		put(' <td class="title2" width="'.$width.'%" align="center" bgcolor="'.$color.'">'.$titre.'</td>');
	}

	/**
	* Affiche un element dans une cellule d'un tableau
	* @param	string	$txt	texte a afficher
	* @param	integer	$couleur	couleur de la cellule
	* @param	style	$style	style du texte
	* @access	public
	*/
	function ColTableau($txt,$couleur='',$style='') {
		if ( $txt == '' ) $txt = '&nbsp;';
		switch ( $style )  {
		case 'b' : $txt = '<b>'.$txt.'</b>'; break;
		case 'i' : $txt = '<i>'.$txt.'</i>'; break;
		}
		if ( $couleur == '' ) {
			put('<td class="small" bgColor="'.CouleurForm().'">'.$txt.'</td>');
		} else {
			put('<td class="small" bgColor="'.$couleur.'">'.$txt.'</td>');
		}
	}

	/**
	* termine un tableau HTML
	* @access	public
	*/
	function FermeTableau(){
		put('</td><tr>');
		put("</table>");
		put("</table>");
	}

	/**
	* Commence une nouvelle ligne dans un tableau HTML
	* @access	public
	*/
	function DebutLigne($action=true,$color=''){
		global $color1a, $color1 ;
		$mouse = '' ;
		if ($action) {
			$mouse = 'onmouseover="setPointer(this, \'over\', \''.$color1a.'\',\''.$color1.'\')" onmouseout="setPointer(this, \'out\', \''.$color1a.'\',\''.$color1.'\')" onmousedown="setPointer(this, \'click\', \''.$color1a.'\',\''.$color1.'\')"';
		}
		$bgcolor=($color==''?'':'bgcolor="'.$color.'"');
		put('<tr valign="middle" '.$mouse.' '.$bgcolor.'>');
	}

	/**
	* Termine une ligne d'un tableau HTML
	* @access	public
	*/
	function FinLigne(){  
		put("</tr>");
	}

	/**
	* Permet un retour en haut de page
	* @access	public
	*/
	function GoTop() {
		global $footer ;
		put('<br><center><a class="student" href="#haut">'.$footer['top']	.'</a>');
		put("<br>");
		//put_copyright_GANESHA();
	}

	/**
	* Permet un retour a la page precedente
	* @access	public
	*/
     function GoBack() {
     	global $ad_titre;
     	$url = PAGE.'&action=liste';
        put('<center>&nbsp;&nbsp;<a class="student" href="'.$url.'" >'.IMG_RIGHT.'&nbsp;&nbsp;'.$ad_titre['retour']	.'</a></center><br>');
	}

	/**
	* Commence un formulaire
	* @param	string	$action	action du formulaire	
	* @param	string	$form	nom du formulaire	
	* @param	string	$color	couleur du form	
	* @access	public
	*/
     function BeginFormulaire($action,$form='',$color='') { 
		global $color2;
		$color = ($color==''?$color2:$color);
		$name  = ($form==''?'formulaire':$form);
		put('
<!-- Debut du formulaire //-->
<center>
<form action="'.$action.'" method="post" name="'.$name.'">
<table width="90%" bgcolor="'.$color.'" border="0" cellpadding="2" cellspacing="0" >
<tr><td>
 <table width="100%" cellSpacing="0" cellpadding="2" border="0">');
     }

	/**
	* termine un formulaire
	* @param	string	$action	permet d'affecter une action au bouton	
	* @access	public
	*/     
     function EndFormulaire($action='',$color='') { 
		 global $color2, $color1a, $ad_titre, $ad_titre ;
		 $color = ($color==''?$color2:$color);
		 if ( $action != '' ) {
		 	$valid = '<input class="bouton" value="'.$ad_titre['enreg'].'" type="button" onclick="return('.$action.'(this.form));">';
		 } else{
		 	$valid = '<input class="bouton" type="submit" value="'.$ad_titre['enreg'].'" >';
		 }
		 put('
 <tr bgColor="'.$color.'">
  <td align="center" class="small" bgColor="'.$color1a.'">* : '.$ad_titre['renseign'].'&nbsp;</td>
  <td align="right">'.IMG_ENREG.$valid.'&nbsp;</td>
 </tr>
 </table>
</td></tr>
</table>
</form>
</center>
<!-- Fin du formulaire //-->');
	     }

	/**	 
	* procdure AddText
	* crer un champ de texte dans une nouvelle ligne
	* @param	string	$titre	intitul
	* @param	variant $val	valeur de l'attribut "value"	
	* @param	string	$num	n du champ de texte
	* @param	boolean $obligatoire	indique si le champs est obligatoire
	* @access	public
	*/ 
     function AddText($titre,$val,$num,$obligatoire=true,$size=45) {
        put('<tr bgcolor="'.CouleurForm().'">');
        put('  <td class="small" >&nbsp;'.$titre.'&nbsp;</td>');
		$obl = ($obligatoire?'*':'');
        put('  <td>&nbsp;<input class="bouton" type="text" maxlength="50" size="'.$size.'" value="'.$val.'" name="text'.$num.'" />&nbsp;'.$obl.'</td>');
        put("</tr>");
     }

	/**	 
	* procdure AddText
	* crer un champ de texte de type password dans une nouvelle ligne
	* @param	string	$titre	intitul
	* @param	variant $val	valeur de l'attribut "value"	
	* @param	string	$num	n du champ de texte
	* @param	boolean $obligatoire	indique si le champs est obligatoire
	* @access	public
	*/ 
     function AddPassword($titre,$val,$num,$obligatoire=true,$size=45) {
        put('<tr bgcolor="'.CouleurForm().'">');
        put('  <td class="small" >&nbsp;'.$titre.'&nbsp;</td>');
		$obl = ($obligatoire?'*':'');
        put('  <td>&nbsp;<input class="bouton" type="password" maxlength="50" size="'.$size.'" value="'.$val.'" name="text'.$num.'" />&nbsp;'.$obl.'</td>');
        put("</tr>");
     }

	/**	 
	* procdure AddTitreText
	* crer une ligne de texte dans une nouvelle ligne de tableau
	* @param	string	$titre	intitul
	* @param	string	$color	couleur de la ligne
	* @access	public
	*/ 
     function AddTitreText($titre,$color='') {
     	if ( $color == '' ) {
     		$color = CouleurForm() ;
     	}
        put('<tr bgcolor="'.$color.'">');
        put('  <td class="small" >&nbsp;'.$titre.'&nbsp;</td><td>&nbsp;</td>');
        put("</tr>");
     }

	/**	 
	* procdure AddHidden
	* crer un champ hidden dans une nouvelle ligne
	* @param	variant $val	valeur de l'attribut "value"	
	* @param	string	$num	n du champ de texte
	* @access	public
	*/ 
     function AddHidden($val,$num) {
        put('  <input type="hidden" value="'.$val.'" name="text'.$num.'" />');
     }

	/**	 
	* procdure AddTextFile
	* crer un champ de texte dans une nouvelle ligne
	* @param	string	$titre	intitul
	* @param	variant $val	valeur de l'attribut "value"	
	* @param	string	$num	n du champ de texte
	* @param	boolean $obligatoire	indique si le champs est obligatoire
	* @param	string $form	nom du formulaire	
	* @access	public
	*/ 
     function AddTextFile($titre,$val,$num,$cmd,$obligatoire=true,$form='formulaire') {
     	//$img = HTTP_IMAGES.'filemanager/explorer.gif';
     	$url = PAGE_DIR.'&cmd='.$cmd.'&id='.$num.'&form='.$form ;     	
		$click = "onClick=\"openWindow('".$url."','filemanager','scrollbars=yes,width=500,height=590')\" ";     	
        put('<tr bgcolor="'.CouleurForm().'">');
        put('  <td class="small" >&nbsp;'.$titre.'&nbsp;</td>');
		$obl = ($obligatoire?'*':'&nbsp;');
        put('  <td>&nbsp;<input class="bouton" type="text" maxLength="50" size="40" value="'.$val.'" name="text'.$num.'" />&nbsp;'.$obl.'&nbsp;');
		put('<a href="javascript:void(0);" '.$click.'>'.IMG_FILE.'</a>');        
        put("</td></tr>");
     }

	/**
	* Affiche la liste des tuteurs
	* @param	string	$titre	libelle de la liste
	* @param	integer	$id		id du tuteur selectionne
	* @param	boolean	$obligatoire indique si le champ est obligatoire
	* @access	public
	*/
	function ListeTypeChapitre($id=-1,$obligatoire=true) {
		global $ClsModule, $ad_texte ;
		put('<tr bgcolor="'.CouleurForm().'">');
		put('  <td class="small" >&nbsp;'.$ad_texte['selchapitre'].'</td>');
		put('  <td>') ;
		BeginOption("LType");
		AddOption($ClsModule->type(DOCUMENT),DOCUMENT,($id==DOCUMENT)) ;
		AddOption($ClsModule->type(QUIZZ),QUIZZ,($id==QUIZZ)) ;
		AddOption($ClsModule->type(TITRE),TITRE,($id==TITRE)) ;		
		EndOption(false);
		put("  </td></tr>");
	}

	/**	 
	* procdure AddDoubleTextFile
	* crer un champ de texte dans une nouvelle ligne
	* @param	string	$titre	intitul
	* @param	variant $val1	valeur de l'attribut "value" pour le champ texte
	* @param	variant $val1	valeur de l'attribut "value" pour le champ fichier
	* @param	string	$num	n du champ de texte
	* @param	integer	$cmd	selection fichier/repertoire
	* @param	boolean $obligatoire	indique si le champs est obligatoire
	* @access	public
	*/ 
     function AddDoubleTextFile($titre,$val1,$val2,$num,$cmd,$obligatoire=true) {
     	global $ad_texte ;
     	$url = PAGE_DIR.'&cmd='.$cmd.'&id='.$num ;     	
		$click = "onClick=\"openWindow('".$url."','filemanager','scrollbars=yes,width=500,height=590')\" ";     	
        put('<tr bgcolor="'.CouleurForm().'">');
        put('  <td class="small" >&nbsp;'.$titre.'&nbsp;</td><td><br>&nbsp;');
		$obl = ($obligatoire?'*':'&nbsp;');
		BeginOption("LType".$num);
		AddOption($ad_texte['typedoc'],0,true) ;
		AddOption($ad_texte['typequizz'],1,false) ;
		AddOption($ad_texte['typetitre'],2,false) ;		
		EndOption(false);				
        put('  &nbsp;<input class="bouton" type=text maxLength="50" size="40" value="'.$val1.'" name="Chaptext'.$num.'" /><br>');		
        put('  &nbsp;&nbsp;&nbsp;<input class="bouton" type=text maxLength="60" size="55" value="'.$val2.'" name="text'.$num.'" />&nbsp;'.$obl.'&nbsp;');
		put('<a href="#" '.$click.'>'.IMG_FILE.'</a>&nbsp;');        
        put("</td></tr>");
     }

    /**	 
	* procdure AddDoubleText
	* crer une ligne de tableau avec deux champs de texte 
	* @param	string	$titre1	intitul du premier champ
	* @param	variant $val1	valeur de l'attribut "value" du premier champ
	* @param	string	$num1	n du  premier champ
	* @param	string	$titre2	intitul du second champ
	* @param	variant $val2	valeur de l'attribut "value" du second champ
	* @param	string	$num2	n du  second champ	
	* @param	boolean $obligatoire	indique si le champs est obligatoire
	* @access	public
	*/ 
	function AddDoubleText($titre1,$val1,$num1,$titre2,$val2,$num2,$obligatoire=true) {
		$obl = ($obligatoire?'&nbsp;*':'');
		put('<tr bgcolor="'.CouleurForm().'">');
		put('  <td class="small">&nbsp;'.$titre1.'&nbsp;</td>');
		put('  <td class="small">&nbsp;<input class="bouton" type="text" maxLength="50" size="15" value="'.Unreplace($val1).'" name="text'.$num1.'">&nbsp;&nbsp;'.$titre2);
		put('  &nbsp;<input class="bouton" type="text" maxLength="50" size="30" value="'.Unreplace($val2).'" name="text'.$num2.'">'.$obl.'</td>');
		put('</tr>');
	}

	/**	 
	* procdure AddCheck
	* creer un champ de texte dans une nouvelle ligne
	* @param	string	$titre	intitul
	* @param	variant $val	valeur de l'attribut "value"	
	* @param	string	$num	n du champ de texte
	* @param	boolean $checked	indique si le champs est selectionne
	* @access	public
	*/ 
     function AddCheck($titre,$val,$num,$checked=false)  {
     	$check = ($checked==true?'checked':'');
		 put('<tr bgcolor="'.CouleurForm().'">');
		 put('  <td class="small">&nbsp;'.$titre.'&nbsp;</td>');
		 put('  <td>&nbsp;<input class="bouton" '.$check.' type="checkbox"  name="check'.$num.'" value="'.$val.'">&nbsp;</td>');
		 put('</tr>');
     }     

	/**	 
	* procdure BeginOption
	* commence une liste
	* @param	string	$name	nom de la liste
	* @access	public
	*/ 
     function BeginOption($name) {
        put_debug(" Debut OPTION ".$name);
        put('&nbsp;<select class="bouton" name="'.$name.'" size=1>');
     }     

	/**	 
	* procdure EndOption
	* termine une liste
	* @param	boolean	$obligatoire	champ obligatoire
	* @access	public
	*/ 
	function EndOption($obligatoire=true){
		$obl = ($obligatoire?'&nbsp;*':'');
		put("</select>".$obl);
		put_debug(" Fin OPTION ");
	}

    /**	 
	* procdure AddOption
	* ajoute un element dans une liste
	* @param	string	$text	description de l'element
	* @param	integer	$value	valeur de l'element
	* @param	boolean	$selected	element selectionne
	* @access	public
	*/ 
	function AddOption($text,$value,$selected=false) {
		$text = Unreplace($text) ;
		$sel  = ($selected==true?'selected':'');
		put('<option value="'.$value.'" '.$sel.'>'.$text.'</option>');
	}

    /**	 
	* procdure messageError
	* affiche un message d'erreur dans un tableau
	* @param	string	$msg	message
	* @param	string	$url	l'url de retour
	* @access	public
	*/ 
    function messageError($msg,$url=''){
    	InitPageHtmlNoCache('Erreur Ganesha');
    	BR(5);
    	BeginBorder("40%",'red');
		put('<table width="100%" border="0" bgcolor="#FFFFFF" cellpadding="2" cellspacing="10">');
		put('<tr>');
  		put('  <td class="error" align="center">'.$msg.'</td>');
		put('</tr>');
		if ( $url != '' ) {
			put('<tr>');
	  		put('  <td class="student" align="center">'.$url.'</td>');
			put('</tr>');
			put('<tr>');
	  		put('  <td>&nbsp;</td>');
			put('</tr>');			
			put('</table>');	    	
			CloseBorder();
	    } else {
			put('</table>');
			CloseBorder();	    	
			BR();
        	put('<center>&nbsp;&nbsp;<a class="student" href="javascript:history.go(-1);" >'.IMG_RIGHT.' Retour</a></center><br>');
	    }
    	ClosePageHtml();
    	die();
    }

    /**	 
	* procdure ErrorBdd
	* affiche un message d'erreur d'acces a la bdd
	* @access	public
	*/ 
	function ErrorBdd() {
		put('<table width="100%" border=0">');
		put('<tr>');
  		put('  <td width="10%">&nbsp;</td>');
  		put('  <td width="80%" height="50" class="error" align=center>Erreur : Connexion  la base de donnes !!! </td>');
  		put('  <td width="10%">&nbsp;</td>');
		put('</tr>');
		put('</table>');
   		ClosePageHtml();
	}

	/**	 
	* procdure message
	* affiche un message d'erreur dans un tableau
	* @param	string	$msg	message
	* @param	string	$url	l'url de retour
	* @access	public
	*/ 
	function message($msg) { 
		global $color1;
		if ( trim($msg) != '' ) {
			put('
<table width="100%" border=0">
<tr>
 <td width="10%"></td>
 <td width="80%" align="center" height="50" class="confirm">'.$msg.'</td>
 <td width="10%"></td>
</tr>
</table>');
		}
	}

	/**
	* Affiche la liste des tuteurs
	* @param	string	$titre	libelle de la liste
	* @param	integer	$id		id du tuteur selectionne
	* @param	boolean	$obligatoire indique si le champ est obligatoire
	* @access	public
	*/
	function AddListeAuteur($id=-1,$obligatoire=true) {
		global $TBL, $ad_texte ;
		$db = new DB_GANESHA ;
		$sSQL = "SELECT id,prenom,nom FROM ".$TBL['membres']." WHERE type=".TUTEUR." ORDER BY prenom,nom" ;
		$db->query($sSQL)   ;
		put('<tr bgcolor="'.CouleurForm().'">');
		put('  <td class="small" >&nbsp;'.$ad_texte['selauteur'].'</td>');
		put("  <td>") ;
		BeginOption("LAuteur");
		AddOption(' ',-1,false) ;
		while($db->next_record())  {
			$select = false ;
			if ( $db->f(0) == $id )	$select = true ;
			AddOption($db->f(1)." ".$db->f(2),$db->f(0),$select) ;
		}
		EndOption($obligatoire);
		put("  </td></tr>");
	}

	/**
	* Affiche la liste des societes
	* @param	integer	$id		id de la societe selectionnee
	* @param	boolean	$obligatoire indique si le champ est obligatoire
	* @access	public
	*/
	function AddListeSociete($id=-1,$obligatoire=true) {
		global $TBL, $ad_texte ;
		$db = new DB_GANESHA ;
		$sSQL = "SELECT id_societe,description FROM ".$TBL['list_societe']." ORDER BY description";
		$db->query($sSQL)   ;
		put('<tr bgcolor="'.CouleurForm().'">');
		put('  <td class="small">&nbsp;'.$ad_texte['selsociete'].'</td>');
		put('  <td>');
		BeginOption("LSociete");
		AddOption(' ',-1,true) ;
		while($db->next_record())  {
			$select = false ;
			if ( $db->f(0) == $id ) $select = true ;
			AddOption($db->f(1),$db->f(0),$select) ;
		}
		EndOption($obligatoire);
		put("  </td></tr>");
	}	

	/**
	* Affiche la liste de toutes les normes
	* @param	integer	$id		id du tuteur selectionne
	* @param	boolean	$obligatoire indique si le champ est obligatoire
	* @access	public
	*/
	function ListeNorme($id,$obligatoire=true) {
		global $ad_texte ;
		put('<tr bgcolor="'.CouleurForm().'">');
		put('  <td class="small">&nbsp;'.$ad_texte['selnorme'].'</td>');
		put('  <td>');	
		put('     <input type="radio" name="LNorme" class="bouton" value="0" '.($id==GANESHA?'checked':'').'> <b>GANESHA</b>&nbsp;&nbsp;&nbsp;&nbsp;');
		put('     <input type="radio" name="LNorme" class="bouton" value="1" '.($id==AICC?'checked':'').'> <b>AICC</a></b>&nbsp;&nbsp;&nbsp;&nbsp;');
		put('     <input type="radio" name="LNorme" class="bouton" value="2" '.($id==SCORM?'checked':'').'> <b>SCORM</a></b>');
		put('  </td></tr>');		
		/*
		put('<tr bgcolor="'.CouleurForm().'">');
		put('  <td class="small">&nbsp;Slectionner la norme</td>');
		put('  <td>');	
		put('     <input type="radio" name="LNorme" class="bouton" value="0" '.($id==GANESHA?'checked':'').'> <b>');
		put('<a class="student" href="javascript:CheckRadio(document.forms[\'formulaire\'].LNorme[\''.GANESHA.'\']);">GANESHA</a></b>&nbsp;&nbsp;&nbsp;&nbsp;');
		put('     <input type="radio" name="LNorme" class="bouton" value="1" '.($id==AICC?'checked':'').'> <b>');
		put('<a class="student" href="javascript:CheckRadio(document.forms[\'formulaire\'].LNorme[\''.AICC.'\']);">AICC</a></b>&nbsp;&nbsp;&nbsp;&nbsp;');
		put('     <input type="radio" name="LNorme" class="bouton" value="2" '.($id==SCORM?'checked':'').'> <b>');
		put('<a class="student" href="javascript:CheckRadio(document.forms[\'formulaire\'].LNorme[\''.SCORM.'\']);">SCORM</a></b>&nbsp;&nbsp;&nbsp;&nbsp;');
		put('  </td></tr>');
		*/
	}

	/**
	* Affiche une liste pour selectionner les groupes
	* @param	integer	$idu	id du membre
	* @access	public
	*/
	function SelectGroupe($idu=-1) {
		global $ClsGroupe, $ad_texte ;
		put('<tr align="top" bgcolor="'.CouleurForm().'">');
		put('  <td class="small">&nbsp;'.$ad_texte['selgroupe'].'</td><td>');
		$grp = array();
		if ( $idu != -1 ) {
			$ClsGroupe->InitList($idu);
			while($ret=$ClsGroupe->NextItem()) {
				$grp[] = $ret['id_groupe'];
			}
		}
		$lgrp = $ClsGroupe->read();
		for($i=0;$i<$lgrp['cnt'];$i++) {
			if ( $lgrp[$i]['id'] > 0 ) {
				$id 	= $lgrp[$i]['id'] 	;
				$name 	= CSS($lgrp[$i]['name']) ;
				$check	= (in_array($id,$grp)?'checked':'');
				put(' &nbsp;<input class="bouton" type="checkbox" '.$check.' name="checkGroupe'.$i.'" value="'.$id.'">  '.$name.' <br>');		
			}
		}
		put('<input type="hidden" name="nbgroupe" value="'.$lgrp['cnt'].'">');				
		put('  </td></tr>');		
	}

	/**
	* Affiche une liste pour selectionner les tuteurs
	* @param	integer	$idg	id du groupe
	* @access	public
	*/
	function SelectTuteur($idg='') {
		global $ClsMembre, $ad_texte ;
		put('<tr align="top" bgcolor="'.CouleurForm().'">');
		put('  <td class="small">&nbsp;'.$ad_texte['seltuteur'].'</td><td>');
		$tuteur = array();
		if ( $idg != '' ) {
			$ClsMembre->InitListTutor($idg);
			while($ret=$ClsMembre->NextItem()) {
				$tuteur[] = $ret['id'];
			}			
		}
		$ltut = $ClsMembre->listTuteur();
		for($i=0;$i<$ltut['cnt'];$i++) {
			if ( $ltut[$i]['id'] > 0 ) {
				$id 	= $ltut[$i]['id'] 	;
				$name 	= CSS($ltut[$i]['name']) ;
				$check	= (in_array($id,$tuteur)?'checked':'');
				put(' &nbsp;<input class="bouton" type="checkbox" '.$check.' name="checkTuteur'.$i.'" value="'.$id.'">  '.$name.' <br>');		
			}
		}
		put('<input type="hidden" name="nbtuteur" value="'.$ltut['cnt'].'">');		
		put('  </td></tr>');		
	}

	/**
	* Affiche une liste pour selectionner les tuteurs
	* @param	integer	$idg	id du groupe
	* @access	public
	*/
	function SelectStagiaire($idg='') {
		global $ClsMembre, $ClsGroupe, $ad_texte, $color1 ;
		put('<tr align="top" bgcolor="'.$color1.'">');
		//put('  <td class="small">&nbsp;'.$ad_texte['seltuteur'].'</td><td>');
		put('  <td class="small">&nbsp;<center>Slectionner les stagiaires <br>du groupe</center></td><td>');
		$stagiaire = array();
		if ( $idg != '' ) {
			$ret = $ClsGroupe->Members($idg);
			for($i=0;$i<$ret['cnt'];$i++) {
				$stagiaire[] = $ret[$i]['id'];
			}
		}

		$liste = $ClsMembre->GetListStagiaire();
		for($i=0;$i<$liste['cnt'];$i++) {
			if ( $liste[$i]['id'] > 0 ) {
				$id 	= $liste[$i]['id'] 	;
				$name 	= CSS($liste[$i]['name']) ;
				$check	= (in_array($id,$stagiaire)?'checked':'');
				put(' &nbsp;<input class="bouton" type="checkbox" '.$check.' name="checkStagiaire'.$i.'" value="'.$id.'">  '.$name.' <br>');		
			}
		}
		put('<input type="hidden" name="nbstagiaire" value="'.$liste['cnt'].'">');		
		put('  </td></tr>');		
	}

	/**
	* Affiche une liste pour ordonner les modules
	* @param	integer	$idg	id du groupe
	* @access	public
	*/
	function SelectSession($idg) {
		global $ClsSession ;
		$ret = $ClsSession->read($idg);
		for($i=0;$i<$ret['cnt'];$i++) {
			$id 	= $ret[$i]['id'] 	;
			$ordre	= $ret[$i]['ordre'] ;
			$name 	= CSS($ret[$i]['name']) ;
			$check	= 'checked';
			put('<tr align="top" bgcolor="'.CouleurForm().'">');			
			put('  <td class="small">&nbsp;'.$name.'</td>');			
			put('  <td><input type="hidden" name="index'.$i.'" value="'.$id.'"><input class="bouton" type="text" maxlength="3" size="3" name="ordre'.$i.'" value="'.$ordre.'"></td>');	
			put('</tr>');
		}
		put('<input type="hidden" name="nbsession" value="'.$ret['cnt'].'">');		
		put('  </td></tr>');		
	}
		
	/**
	* Affiche une liste pour selectionner les modules
	* @param	integer	$idg	id du groupe
	* @access	public
	*/
	function SelectModule($idg='') {
		global $ClsModule, $ClsSession, $ad_texte ;
		put('<tr align="top" bgcolor="'.CouleurForm().'">');
		put('  <td class="small">&nbsp;'.$ad_texte['selmodules'].'</td><td><br>');
		
		$session = array();
		if ( $idg != '' ) {
			$ret = $ClsSession->read($idg);
			for($i=0;$i<$ret['cnt'];$i++) {
				$session[] = $ret[$i]['id'] ;
			}
		}

		$modules = $ClsModule->read();
		//debug($modules);
		for($i=0;$i<$modules['cnt'];$i++) {
			if ( $modules[$i]['id'] > 0 ) {
				$id 	= $modules[$i]['id'] 	;
				$name 	= CSS($modules[$i]['titre']) ;
				$check	= (in_array($id,$session)?'checked':'');
				put(' &nbsp;<input class="bouton" type="checkbox" '.$check.' name="checkModule'.$i.'" value="'.$id.'">  '.$name.' <br>');		
			}
		}
		put('<input type="hidden" name="nbmodule" value="'.$modules['cnt'].'">');
		put('  </td></tr>');		
	}	

	/**
	* Affiche une liste pour selectionner les modules
	* @param	integer	$idg	id du groupe
	* @access	public
	*/
	function SelectGroupeInscription($tabgrp,$tabidgrp) {
		global $ClsInscription, $ClsGroupe, $ad_texte ;
		put('<tr align="top" bgcolor="'.CouleurForm().'">');
		put('  <td class="small">&nbsp;'.$ad_texte['selmodules'].'</td><td><br>');
		
		$lgrp = $ClsGroupe->read();
		if ( ! is_array($tabidgrp) ) {
			$tabidgrp = array() ;
		}
		$nb = $lgrp['cnt'];
		for($i=0;$i<$nb;$i++) {
			$id 	= $lgrp[$i]['id'] ; 
			if ( $id > 0 ) {
				$name 	= CSS($lgrp[$i]['name']) ;
				$check	= (in_array($id,$tabidgrp)?'checked':'');
				put(' &nbsp;<input class="bouton" type="checkbox" '.$check.' name="checkGroupe'.$i.'" value="'.$id.'">  '.$name.' <br>');		
			}
		}

		put('<input type="hidden" name="nbgroupe" value="'.$nb.'">');
		put('  </td></tr>');		
	}	

	/**
	* Affiche une liste pour selectionner les modules pour un user
	* @param	integer	$idu	id du user
	* @access	public
	*/
	function SelectGroupeModule($idu) {
		global $ClsModule, $ClsSession, $ClsGroupe, $ad_texte ;
		put('<tr align="top" bgcolor="'.CouleurForm().'">');
		put('  <td class="small">&nbsp;'.$ad_texte['selmodules'].'</td><td><br>');

		$grp = array();
		$ClsGroupe->InitList($idu);
		while($ret=$ClsGroupe->NextItem()) {
			$grp[] = $ret['id_groupe'];
		}

		$session = array();
		if ( is_array($grp) ) {
			for($i=0;$i<count($grp);$i++) {
				$ret = $ClsSession->read($grp[$i]);
				for($j=0;$j<$ret['cnt'];$j++) {
					if ( ! in_array($ret[$j]['id'],$session) ){
						$session[] = $ret[$j]['id'] ;
					}
				}
			}
		}

		$modules = $ClsModule->read();
		for($i=0;$i<$modules['cnt'];$i++) {
			if ( $modules[$i]['id'] > 0 ) {
				$id 	= $modules[$i]['id'] 	;
				$name 	= CSS($modules[$i]['titre']) ;
				if (in_array($id,$session)){
					put(' &nbsp;[&nbsp;+&nbsp;]&nbsp;&nbsp;'.$name.' <br>');
				} else {
					//put(' &nbsp;<input class="bouton" type="checkbox" name="checkModule[]" value="'.$id.'">  '.$name.' <br>');		
					put(' &nbsp;[&nbsp;&nbsp;&nbsp;&nbsp;]&nbsp;&nbsp;'.$name.' <br>');	
				}
			}
		}
		put('  </td></tr>');		
	}		

	/**
	* Affiche une liste pour selectionner les fichiers d'un module
	* @param	integer	$idm	id du module
	* @access	public
	*/
	function SelectFileModule($dir,$idm) {
		global $ad_texte ;
		put('<tr align="top" bgcolor="'.CouleurForm().'">');
		put('  <td class="small">&nbsp;'.$ad_texte['selfichier'].'</td><td>');
		$directory = readir($dir);
		//debug($directory);
		BeginOption("LFileModule");
		AddOption(' ',-1,true) ;
		for($i=0;$i<$directory['cnt'];$i++) {
			if ( $directory[$i]['type'] == 'file' ) {
				$select = false ;
				$name 	= CSS($directory[$i]['name']) 	;
				AddOption($name,$name,$select) ;				
			}
		}
		EndOption($obligatoire);		
		put('  </td></tr>');		
	}	

	/**
	* Ferme la fenetre et reload de l'opener
	* @access	public
	*/
	function reloadOpenerAndClose() {
		global $color1 ;
		$link  = "window.opener.location.reload();window.close();"	;			
		InitPageHtml("Ganesha",false);
		print("<script>".$link."</script>");
		$texte = $st_titre['fermer'];
		put('	<br>')	;
		put('	<br>')	;
		put('	<table width="100%" border="0" cellspacing="5" cellpadding="5">')	;
		put('	<tr bgColor="'.$color1.'">')										;
		put('	 <td align="center" class="title2"> <a href="#" onclick="'.$link.'" class="student">'.$texte.'</a></td>') ;
		put('	</tr>')		;
		put('	</table>')	;
		ClosePageHtml();
		exit();
	}

?>