% FUNCTION [...] = gf_mesh_fem_set(mesh_fem MF, [operation [, args]])
%
%   General function for modifying mesh_fem objects.
%   
%
%   * gf_mesh_fem_set(mesh_fem MF, 'fem', fem f[, ivec CVids])
%   Set the Finite Element Method.
%   
%   Assign a FEM `f` to all convexes whose #ids are listed in `CVids`.
%   If `CVids` is not given, the integration is assigned to all convexes.
%   
%   See the help of gf_fem to obtain a list of available FEM methods.
%
%   * gf_mesh_fem_set(mesh_fem MF, 'classical fem', int k[, ivec CVids])
%   Assign a classical (Lagrange polynomial) fem of order `k` to the mesh_fem.
%   
%   Uses FEM_PK for simplexes, FEM_QK for parallelepipeds etc.
%
%   * gf_mesh_fem_set(mesh_fem MF, 'classical discontinuous fem', int K[, @tscalar alpha[, ivec CVIDX]])
%   Assigns a classical (Lagrange polynomial) discontinuous fem or order K.
%   
%   Similar to gf_mesh_fem_set(mesh_fem MF, 'classical fem') except that
%   FEM_PK_DISCONTINUOUS is used. Param `alpha` the node inset,
%   0 <= alpha < 1, where 0 implies usual dof nodes, greater values
%   move the nodes toward the center of gravity, and 1 means that all
%   degrees of freedom collapse on the center of gravity.
%
%   * gf_mesh_fem_set(mesh_fem MF, 'qdim', int Q)
%   Change the `Q` dimension of the field that is interpolated by the mesh_fem.
%   
%   `Q = 1` means that the mesh_fem describes a scalar field, `Q = N` means
%   that the mesh_fem describes a vector field of dimension N.
%
%   * gf_mesh_fem_set(mesh_fem MF, 'reduction matrices', mat R, mat E)
%   Set the reduction and extension matrices and valid their use.
%
%   * gf_mesh_fem_set(mesh_fem MF, 'reduction', int s)
%   Set or unset the use of the reduction/extension matrices.
%
%   * gf_mesh_fem_set(mesh_fem MF, 'dof partition', ivec DOFP)
%   Change the 'dof_partition' array.
%   
%   `DOFP` is a vector holding a integer value for each convex of the mesh_fem.
%   See gf_mesh_fem_get(mesh_fem MF, 'dof partition') for a description of "dof partition".
%
%   * gf_mesh_fem_set(mesh_fem MF, 'set partial', ivec DOFs[, ivec RCVs])
%   Can only be applied to a partial mesh_fem. Change the subset of the
%   degrees of freedom of `mf`.
%   
%   If `RCVs` is given, no FEM will be put on the convexes listed
%   in `RCVs`.
%
%
function [varargout]=gf_mesh_fem_set(varargin)
  if (nargout),
    [varargout{1:nargout}]=gf_matlab('mesh_fem_set', varargin{:});
  else
    gf_matlab('mesh_fem_set', varargin{:});
    if (exist('ans', 'var') == 1), varargout{1}=ans; end;
  end;
% autogenerated mfile;
