function [varargout]=subsref(obj, index)
% gfMdBrick/subsref
  nout = max(nargout, 1); cnt=1;
  FGET = @gf_mdbrick_get;
  FSET = @gf_mdbrick_set;
  switch index(1).type
    case '{}'
      error('Cell array indexing not supported by gfMdBrick objects')
    case '()'
      error('array indexing not supported by gfMdBrick objects')
    case '.'
      switch index(1).subs
        case 'id'
          [varargout{1:nout}] = obj.id;
        case 'set_param'
          if (nargout)
            [varargout{1:nargout}] = FSET(obj, 'param', index(2).subs{:});
          else
            FSET(obj, 'param', index(2).subs{:});
            if (exist('ans', 'var') == 1)
              varargout{1}=ans;
            end;
          end;
          return;
        case 'penalization_epsilon'
          if (nargout)
            [varargout{1:nargout}] = FSET(obj, 'penalization_epsilon', index(2).subs{:});
          else
            FSET(obj, 'penalization_epsilon', index(2).subs{:});
            if (exist('ans', 'var') == 1)
              varargout{1}=ans;
            end;
          end;
          return;
        case 'constraints'
          if (nargout)
            [varargout{1:nargout}] = FSET(obj, 'constraints', index(2).subs{:});
          else
            FSET(obj, 'constraints', index(2).subs{:});
            if (exist('ans', 'var') == 1)
              varargout{1}=ans;
            end;
          end;
          return;
        case 'constraints_rhs'
          if (nargout)
            [varargout{1:nargout}] = FSET(obj, 'constraints_rhs', index(2).subs{:});
          else
            FSET(obj, 'constraints_rhs', index(2).subs{:});
            if (exist('ans', 'var') == 1)
              varargout{1}=ans;
            end;
          end;
          return;
        case 'set'
          if (nargout)
            [varargout{1:nargout}] = FSET(obj, index(2).subs{:});
          else
            FSET(obj,index(2).subs{:});
            if (exist('ans', 'var') == 1)
              h=ans;
              if (isstruct(h) & isfield(h,'id') & isfield(h,'cid')), h = gfObject(h); end;
              varargout{1}=h;
            end;
          end;
          return;
        case 'get'
          if (nargout) 
            h = FGET(obj, index(2).subs{:});
            if (isstruct(h) & isfield(h,'id') & isfield(h,'cid')), h = gfObject(h); end;
            [varargout{1:nargout}] = h;
          else
	     FGET(obj,index(2).subs{:});
            if (exist('ans', 'var') == 1)
              h=ans;
              if (isstruct(h) & isfield(h,'id') & isfield(h,'cid')), h = gfObject(h); end;
              varargout{1}=h;
            end;
          end;
          return;
        otherwise
          if ((numel(index) > 1) && (strcmp(index(2).type, '()')))
            h = FGET(obj,index(1).subs, index(2).subs{:});
            if (isstruct(h) & isfield(h,'id') & isfield(h,'cid')), h = gfObject(h); end;
            [varargout{1:nargout}] = h;
            cnt = cnt + 1;
          else
            h = FGET(obj, index(1).subs);
            if (isstruct(h) & isfield(h,'id') & isfield(h,'cid')), h = gfObject(h); end;
            [varargout{1:nargout}] = h;
          end
      end
  end
  % if there are others indexes, let matlab do its work
  if (numel(index) > cnt)
    for i=1:nout,
      varargout{i} = subsref(varargout{i}, index((cnt+1):end));
    end;
  end;
% autogenerated mfile;
