% FUNCTION [...] = gf_precond_get(precond P, [operation [, args]])
%
%   General function for querying information about precond objects.
%   
%
%   * gf_precond_get(precond P, 'mult', vec V)
%   Apply the preconditioner to the supplied vector.
%
%   * gf_precond_get(precond P, 'tmult', vec V)
%   Apply the transposed preconditioner to the supplied vector.
%
%   * gf_precond_get(precond P, 'type')
%   Return a string describing the type of the preconditioner ('ilu', 'ildlt',..).
%
%   * gf_precond_get(precond P, 'size')
%   Return the dimensions of the preconditioner.
%
%   * gf_precond_get(precond P, 'is_complex')
%   Return 1 if the preconditioner stores complex values.
%
%   * s = gf_precond_get(precond P, 'char')
%   Output a (unique) string representation of the precond.
%   
%   This can be used to perform comparisons between two
%   different precond objects.
%   This function is to be completed.
%   
%
%   * gf_precond_get(precond P, 'display')
%   displays a short summary for a precond object.
%
%
function [varargout]=gf_precond_get(varargin)
  if (nargout),
    [varargout{1:nargout}]=gf_matlab('precond_get', varargin{:});
  else
    gf_matlab('precond_get', varargin{:});
    if (exist('ans', 'var') == 1), varargout{1}=ans; end;
  end;
% autogenerated mfile;
