% FUNCTION [...] = gf_mdstate([operation [, args]])
%
%   General constructor for mdstate objects.
%
%   A model state is an object which store the state data for a chain of model
%   bricks. This includes the global tangent matrix, the right hand side and
%   the constraints.
%   
%   This object is now deprecated and replaced by the model object.
%   
%   There are two sorts of model states, the `real` and the `complex` models
%   states.
%   
%
%   * MDS = gf_mdstate('real')
%   Build a model state for real unknowns.
%
%   * MDS = gf_mdstate('complex')
%   Build a model state for complex unknowns.
%
%   * MDS = gf_mdstate(mdbrick B)
%   Build a modelstate for the brick `B`.
%   
%   Selects the real or complex state from the complexity of `B`.
%
%
function [varargout]=gf_mdstate(varargin)
  if (nargout),
    [varargout{1:nargout}]=gf_matlab('mdstate', varargin{:});
  else
    gf_matlab('mdstate', varargin{:});
    if (exist('ans', 'var') == 1), varargout{1}=ans; end;
  end;
% autogenerated mfile;
