#!/bin/bash
# test suite for graph_sampler
# Written by Frederic Bois
# Copyright (c) 2014-2017 Frederic Bois.
# This code is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# See the GNU General Public License at <http://www.gnu.org/licenses/> 

# Node that lines indented by a tab are passed to the calling makefile as is..

cd tests

# set the colors
red='[0;31m';
grn='[0;32m';
std='[m';

echo "===================="

# a thorough test 1

../graph_sampler script_test_1.txt &> /dev/null
if diff graph_samples.out graph_samples_1.ref &> /dev/null;
then TEST=0;  echo "Test 1a     $grn-PASSED-$std"
else TEST=1;  echo "Test 1a     $red-FAILED-$std"
fi;

if diff results_mcmc.bin results_mcmc_1.ref &> /dev/null;
then TEST1=0; echo "Test 1b     $grn-PASSED-$std"
else TEST1=1; echo "Test 1b     $red-FAILED-$std"
fi;

if test $TEST -eq 1 -o $TEST1 -eq 1;
then TEST=1;
else TEST=0;
fi;

if diff edge_p.out edge_p_1.ref &> /dev/null;
then TEST1=0; echo "Test 1c     $grn-PASSED-$std"
else TEST1=1; echo "Test 1c     $red-FAILED-$std"
fi;

if test $TEST -eq 1 -o $TEST1 -eq 1;
then TEST=1;
else TEST=0;
fi;

if diff best_graph.out best_graph_1.ref &> /dev/null;
then TEST1=0; echo "Test 1d     $grn-PASSED-$std"
else TEST1=1; echo "Test 1d     $red-FAILED-$std"
fi;

if test $TEST -eq 1 -o $TEST1 -eq 1;
then TEST=1;
else TEST=0;
fi;

if diff degree_count.out degree_count_1.ref &> /dev/null;
then TEST1=0; echo "Test 1e     $grn-PASSED-$std"
else TEST1=1; echo "Test 1e     $red-FAILED-$std"
fi;

if test $TEST -eq 1 -o $TEST1 -eq 1;
then TEST=1;
else TEST=0;
fi;

if diff motifs_count.out motifs_count_1.ref &> /dev/null;
then TEST1=0; echo "Test 1f     $grn-PASSED-$std"
else TEST1=1; echo "Test 1f     $red-FAILED-$std"
fi;

if test $TEST -eq 1 -o $TEST1 -eq 1;
then TEST=1; echo "Test 1      $red-FAILED-$std"
else TEST=0; echo "Test 1      $grn-PASSED-$std"
fi;


../graph_sampler script_test_2.txt &> /dev/null
if diff graph_samples.out graph_samples_2.ref &> /dev/null;
then TEST1=0; echo "Test 2      $grn-PASSED-$std"
else TEST1=1; echo "Test 2      $red-FAILED-$std"
fi;

if test $TEST -eq 1 -o $TEST1 -eq 1;
then TEST=1;
else TEST=0;
fi;


../graph_sampler script_test_3.txt &> /dev/null
if diff graph_samples.out graph_samples_3.ref &> /dev/null;
then TEST1=0; echo "Test 3      $grn-PASSED-$std"
else TEST1=1; echo "Test 3      $red-FAILED-$std"
fi;

if test $TEST -eq 1 -o $TEST1 -eq 1;
then TEST=1;
else TEST=0;
fi;


../graph_sampler script_test_4.txt &> /dev/null
if diff graph_samples.out graph_samples_4.ref &> /dev/null;
then TEST1=0; echo "Test 4      $grn-PASSED-$std"
else TEST1=1; echo "Test 4      $red-FAILED-$std"
fi;

if test $TEST -eq 1 -o $TEST1 -eq 1;
then TEST=1;
else TEST=0;
fi;


../graph_sampler script_test_5.txt &> /dev/null
if diff graph_samples.out graph_samples_5.ref &> /dev/null;
then TEST1=0; echo "Test 5      $grn-PASSED-$std"
else TEST1=1; echo "Test 5      $red-FAILED-$std"
fi;

if test $TEST -eq 1 -o $TEST1 -eq 1;
then TEST=1;
else TEST=0;
fi;


../graph_sampler script_test_6.txt &> /dev/null
if diff graph_samples.out graph_samples_6.ref &> /dev/null;
then TEST1=0; echo "Test 6      $grn-PASSED-$std"
else TEST1=1; echo "Test 6      $red-FAILED-$std"
fi;

if test $TEST -eq 1 -o $TEST1 -eq 1;
then TEST=1;
else TEST=0;
fi;


../graph_sampler script_test_7.txt &> /dev/null
if diff graph_samples.out graph_samples_7.ref &> /dev/null;
then TEST1=0; echo "Test 7      $grn-PASSED-$std"
else TEST1=1; echo "Test 7      $red-FAILED-$std"
fi;

if test $TEST -eq 1 -o $TEST1 -eq 1;
then TEST=1;
else TEST=0;
fi;


../graph_sampler script_test_8.txt &> /dev/null
if diff graph_samples.out graph_samples_8.ref &> /dev/null;
then TEST1=0; echo "Test 8      $grn-PASSED-$std"
else TEST1=1; echo "Test 8      $red-FAILED-$std"
fi;

if test $TEST -eq 1 -o $TEST1 -eq 1;
then TEST=1;
else TEST=0;
fi;


../graph_sampler script_test_9.txt &> /dev/null
if diff graph_samples.out graph_samples_9.ref &> /dev/null;
then TEST1=0; echo "Test 9      $grn-PASSED-$std"
else TEST1=1; echo "Test 9      $red-FAILED-$std"
fi;

if test $TEST -eq 1 -o $TEST1 -eq 1;
then TEST=1;
else TEST=0;
fi;


../graph_sampler script_test_10.txt &> /dev/null
if diff graph_samples.out graph_samples_10.ref &> /dev/null;
then TEST1=0; echo "Test 10     $grn-PASSED-$std"
else TEST1=1; echo "Test 10     $red-FAILED-$std"
fi;

if test $TEST -eq 1 -o $TEST1 -eq 1;
then TEST=1;
else TEST=0;
fi;


../graph_sampler script_test_11.txt &> /dev/null
if diff graph_samples.out graph_samples_11.ref &> /dev/null;
then TEST1=0; echo "Test 11     $grn-PASSED-$std"
else TEST1=1; echo "Test 11     $red-FAILED-$std"
fi;

if test $TEST -eq 1 -o $TEST1 -eq 1;
then TEST=1;
else TEST=0;
fi;


../graph_sampler script_test_12.txt &> /dev/null
if diff graph_samples.out graph_samples_12.ref &> /dev/null;
then TEST1=0; echo "Test 12     $grn-PASSED-$std"
else TEST1=1; echo "Test 12     $red-FAILED-$std"
fi;

if test $TEST -eq 1 -o $TEST1 -eq 1;
then TEST=1;
else TEST=0;
fi;


../graph_sampler script_test_13.txt &> /dev/null
if diff graph_samples.out graph_samples_13.ref &> /dev/null;
then TEST12=0; echo "Test 13     $grn-PASSED-$std"
else TEST12=1; echo "Test 13     $red-FAILED-$std"
fi;

if test $TEST -eq 1 -o $TEST1 -eq 1;
then TEST=1;
else TEST=0;
fi;


../graph_sampler script_test_14.txt &> /dev/null
if diff graph_samples.out graph_samples_14.ref &> /dev/null;
then TEST1=0; echo "Test 14     $grn-PASSED-$std"
else TEST1=1; echo "Test 14     $red-FAILED-$std"
fi;

if test $TEST -eq 1 -o $TEST1 -eq 1;
then TEST=1;
else TEST=0;
fi;


../graph_sampler script_test_15.txt &> /dev/null
if diff graph_samples.out graph_samples_15.ref &> /dev/null;
then TEST1=0; echo "Test 15     $grn-PASSED-$std"
else TEST1=1; echo "Test 15     $red-FAILED-$std"
fi;

if test $TEST -eq 1 -o $TEST1 -eq 1;
then TEST=1;
else TEST=0;
fi;


../graph_sampler script_test_16.txt &> /dev/null
if diff graph_samples.out graph_samples_16.ref &> /dev/null;
then TEST1=0; echo "Test 16     $grn-PASSED-$std"
else TEST1=1; echo "Test 16     $red-FAILED-$std"
fi;

if test $TEST -eq 1 -o $TEST1 -eq 1;
then TEST=1;
else TEST=0;
fi;


../graph_sampler script_test_BN_1.txt &> /dev/null
if diff graph_samples.out graph_samples_BN_1.ref &> /dev/null;
then TEST1=0; echo "Test BN1    $grn-PASSED-$std"
else TEST1=1; echo "Test BN1    $red-FAILED-$std"
fi;

if test $TEST -eq 1 -o $TEST1 -eq 1;
then TEST=1;
else TEST=0;
fi;


../graph_sampler script_test_BN_2.txt &> /dev/null
if diff graph_samples.out graph_samples_BN_2.ref &> /dev/null;
then TEST1=0; echo "Test BN2    $grn-PASSED-$std"
else TEST1=1; echo "Test BN2    $red-FAILED-$std"
fi;

if test $TEST -eq 1 -o $TEST1 -eq 1;
then TEST=1;
else TEST=0;
fi;


../graph_sampler script_test_BN_3.txt &> /dev/null
if diff graph_samples.out graph_samples_BN_3.ref &> /dev/null;
then TEST1=0; echo "Test BN3    $grn-PASSED-$std"
else TEST1=1; echo "Test BN3    $red-FAILED-$std"
fi;

if test $TEST -eq 1 -o $TEST1 -eq 1;
then TEST=1;
else TEST=0;
fi;


../graph_sampler script_test_BN_4.txt &> /dev/null
if diff graph_samples.out graph_samples_BN_4.ref &> /dev/null;
then TEST1=0; echo "Test BN4    $grn-PASSED-$std"
else TEST1=1; echo "Test BN4    $red-FAILED-$std"
fi;

if test $TEST -eq 1 -o $TEST1 -eq 1;
then TEST=1;
else TEST=0;
fi;


../graph_sampler script_test_BN_5.txt &> /dev/null
if diff graph_samples.out graph_samples_BN_5.ref &> /dev/null;
then TEST1=0; echo "Test BN5    $grn-PASSED-$std"
else TEST1=1; echo "Test BN5    $red-FAILED-$std"
fi;

if test $TEST -eq 1 -o $TEST1 -eq 1;
then TEST=1;
else TEST=0;
fi;


../graph_sampler script_test_BN_6.txt &> /dev/null
if diff graph_samples.out graph_samples_BN_6.ref &> /dev/null;
then TEST1=0; echo "Test BN6    $grn-PASSED-$std"
else TEST1=1; echo "Test BN6    $red-FAILED-$std"
fi;

if test $TEST -eq 1 -o $TEST1 -eq 1;
then TEST=1;
else TEST=0;
fi;


../graph_sampler script_test_BN_7.txt &> /dev/null
if diff graph_samples.out graph_samples_BN_7.ref &> /dev/null;
then TEST1=0; echo "Test BN7    $grn-PASSED-$std"
else TEST1=1; echo "Test BN7    $red-FAILED-$std"
fi;

if test $TEST -eq 1 -o $TEST1 -eq 1;
then TEST=1;
else TEST=0;
fi;


../graph_sampler script_test_DBN_1.txt &> /dev/null
if diff graph_samples.out graph_samples_DBN_1.ref &> /dev/null;
then TEST1=0; echo "Test DBN1   $grn-PASSED-$std"
else TEST1=1; echo "Test DBN1   $red-FAILED-$std"
fi;

if test $TEST -eq 1 -o $TEST1 -eq 1;
then TEST=1;
else TEST=0;
fi;


../graph_sampler script_test_DBN_2.txt &> /dev/null
if diff graph_samples.out graph_samples_DBN_2.ref &> /dev/null;
then TEST1=0; echo "Test DBN2   $grn-PASSED-$std"
else TEST1=1; echo "Test DBN2   $red-FAILED-$std"
fi;

if test $TEST -eq 1 -o $TEST1 -eq 1;
then TEST=1;
else TEST=0;
fi;


../graph_sampler script_test_DBN_3.txt &> /dev/null
if diff graph_samples.out graph_samples_DBN_3.ref &> /dev/null;
then TEST1=0; echo "Test DBN3   $grn-PASSED-$std"
else TEST1=1; echo "Test DBN3   $red-FAILED-$std"
fi;

if test $TEST -eq 1 -o $TEST1 -eq 1;
then TEST=1;
else TEST=0;
fi;


../graph_sampler script_test_hyper_1.txt &> /dev/null
if diff graph_samples.out graph_samples_hyper_1.ref &> /dev/null;
then TEST1=0; echo "Test HYPER1 $grn-PASSED-$std"
else TEST1=1; echo "Test HYPER1 $red-FAILED-$std"
fi;

if test $TEST -eq 1 -o $TEST1 -eq 1;
then TEST=1;
else TEST=0;
fi;


../graph_sampler script_test_hyper_2.txt &> /dev/null
if diff graph_samples.out graph_samples_hyper_2.ref &> /dev/null;
then TEST1=0; echo "Test HYPER2 $grn-PASSED-$std"
else TEST1=1; echo "Test HYPER2 $red-FAILED-$std"
fi;

if test $TEST -eq 1 -o $TEST1 -eq 1;
then TEST=1;
else TEST=0;
fi;


../graph_sampler script_test_hyper_3.txt &> /dev/null
if diff graph_samples.out graph_samples_hyper_3.ref &> /dev/null;
then TEST1=0; echo "Test HYPER3 $grn-PASSED-$std"
else TEST1=1; echo "Test HYPER3 $red-FAILED-$std"
fi;

if test $TEST -eq 1 -o $TEST1 -eq 1;
then TEST=1;
else TEST=0;
fi;


../graph_sampler script_test_hyper_4.txt &> /dev/null
if diff graph_samples.out graph_samples_hyper_4.ref &> /dev/null;
then TEST1=0; echo "Test HYPER4 $grn-PASSED-$std"
else TEST1=1; echo "Test HYPER4 $red-FAILED-$std"
fi;

if test $TEST -eq 1 -o $TEST1 -eq 1;
then TEST=1;
else TEST=0;
fi;


../graph_sampler script_test_hyper_5.txt &> /dev/null
if diff graph_samples.out graph_samples_hyper_5.ref &> /dev/null;
then TEST1=0; echo "Test HYPER5 $grn-PASSED-$std"
else TEST1=1; echo "Test HYPER5 $red-FAILED-$std"
fi;

if test $TEST -eq 1 -o $TEST1 -eq 1;
then TEST=1;
else TEST=0;
fi;


../graph_sampler script_test_hyper_6.txt &> /dev/null
if diff graph_samples.out graph_samples_hyper_6.ref &> /dev/null;
then TEST1=0; echo "Test HYPER6 $grn-PASSED-$std"
else TEST1=1; echo "Test HYPER6 $red-FAILED-$std"
fi;

if test $TEST -eq 1 -o $TEST1 -eq 1;
then TEST=1;
else TEST=0;
fi;


../graph_sampler script_test_hyper_7.txt &> /dev/null
if diff graph_samples.out graph_samples_hyper_7.ref &> /dev/null;
then TEST1=0; echo "Test HYPER7 $grn-PASSED-$std"
else TEST1=1; echo "Test HYPER7 $red-FAILED-$std"
fi;

if test $TEST -eq 1 -o $TEST1 -eq 1;
then TEST=1;
else TEST=0;
fi;


../graph_sampler script_test_convergence_1.txt &> /dev/null
if diff convergence.out convergence_1.ref &> /dev/null;
then TEST1=0; echo "Test CONV1  $grn-PASSED-$std"
else TEST1=1; echo "Test CONV1  $red-FAILED-$std"
fi;

if test $TEST -eq 1 -o $TEST1 -eq 1;
then TEST=1;
else TEST=0;
fi;


../graph_sampler script_test_convergence_2.txt &> /dev/null
if diff convergence.out convergence_2.ref &> /dev/null;
then TEST1=0; echo "Test CONV2  $grn-PASSED-$std"
else TEST1=1; echo "Test CONV2  $red-FAILED-$std"
fi;

if test $TEST -eq 1 -o $TEST1 -eq 1;
then TEST=1;
else TEST=0;
fi;


../graph_sampler script_test_convergence_3.txt &> /dev/null
if diff convergence.out convergence_3.ref &> /dev/null;
then TEST1=0; echo "Test CONV3  $grn-PASSED-$std"
else TEST1=1; echo "Test CONV3  $red-FAILED-$std"
fi;

if test $TEST -eq 1 -o $TEST1 -eq 1;
then TEST=1;
else TEST=0;
fi;


echo "====================";

rm [b-m]*.out r*.bin &> /dev/null

if test $TEST -eq 1;
then message='Problems found...'; echo "$red$message$std"; echo
else message='All tests PASSED';  echo "$grn$message$std"; echo
fi;

# exit $TEST
exit 0


   

