<?php

// -----------------------------------------------------------------------
// This file is part of Igloo
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------
$menu_section = "structure";
include "inc/header.inc.php";

//ACS check
if (!$user_acs->checkPermission($c_acs['arr_acs']['resource']['administration'], $c_acs['arr_acs']['privilege']['allow_membership'])) { //resourece_id, Priv_id
	header("Location: " . $_SESSION['user_homepage'] . "?" . strip_tags(SID));
	exit;
}


//append language setup
require_once($languageArrayPath . 'arr_language_name.lang.php');
require_once($languageArrayPath . 'arr_user.lang.php');


//setup useradmin (extends user)
require_once($c_node['dir']['class_path'] . 'User.class.php');
require_once($c_node['dir']['class_path'] . 'UserAdmin.class.php');
$user = new UserAdmin($db, $date);
$user->language_dir = $c_node['node']['template_default_name'];


//form actions
if (isset($_POST['preview'])) {
	$lang['txt_invite'] = $frmdata['subject'];
	$lang['txt_invite_message_txt'] = $frmdata['message'];
	
	$display = "preview";
}
elseif (isset($_POST['edit_again'])) {
	$lang['txt_invite'] = $frmdata['subject'];
	$lang['txt_invite_message_txt'] = $frmdata['message'];
	
}
elseif (isset($_POST['register'])) {
	// Checks the email and the password
	

	if (isset($_POST['language_ids'])) {
	    $frmdata['language_ids'] = $_POST['language_ids'];
	}
	
	$frmdata['user_dob'] = $_REQUEST['year']."-".$_REQUEST['month']."-".$_REQUEST['day'];
	
	$user->checkRegister($frmdata);

	if (empty($GLOBALS['igloo_error_log'])) {

		//setup email
		require_once($c_node['dir']['class_path'] . '/Mail/class.phpmailer.php');
		$mail = new PHPMailer();
		$mail->Host = 		$c_node['mail']['host'];
		$mail->Mailer = 	$c_node['mail']['mailer'];
		
		if (isset($c_node['mail']['smtp']['username'])) {
			$mail->SMTPAuth = true;
			$mail->Username = $c_node['mail']['smtp']['username'];
			$mail->Password = $c_node['mail']['smtp']['password'];
		}
				
		$mail->From = 		$c_node['mail']['no_reply_address'];
		$mail->FromName = 	$c_node['mail']['from_name'];
		$mail->WordWrap = 	$c_node['mail']['wordwrap'];
		$mail->Subject = 	$frmdata['subject'];
		$mail->AddReplyTo($c_node['mail']['no_reply_address'], $lang['subject_noreply']);
		$mail->language = 	"en";
		$user->mail = $mail;


		if (isset($frmdata['invitee_id'])) {
			$user->invitee_id = $frmdata['invitee_id'];
		}
		$user->txt_message = $frmdata['message'];
		$user->user_image_allocation = $c_node['file']['default_max_user_space'];
		$user->template_id = $c_node['node']['template_default_id'];
		$frmdata['user_dob'] = $_REQUEST['year']."-".$_REQUEST['month']."-".$_REQUEST['day'];
		$user->txt_default_profile_name = $lang['txt_default_profile_name'];
		$user->txt_default_profile_hometown = $lang['txt_default_profile_hometown'];
		$user->status_id = $c_node['user']['status']['pending'];
		$user->template_id = $c_node['node']['template_default_id'];
		$user->page_default = $c_node['node']['page_default'];
		$user->igloo_dir = "";
		$user->role_default = $c_acs['arr_acs']['user_join_role_default'];
		$user->registerUser($frmdata);

		//check if we need to add invitee into social network
		if (isset($frmdata) && !empty($frmdata['invitee_id'])) {
			require_once($c_node['dir']['Igloo'] . $c_node['dir']['class_path'] . 'User/SocialNetwork.class.php');
			$sn = new SocialNetwork($user->user_id, $db);
			$relation = $sn->insertRelation($frmdata['invitee_id'], $c_node['relation_type']['approved']);
		}

		$display = "registration_complete";
	}

}


//if someone has invited someone here
if ((isset($_REQUEST['invitee']) && $_REQUEST['invitee'] > 0) || isset($frmdata['invitee_id'])) {
	if (isset($_REQUEST['invitee'])) {
	    $invitee = $_REQUEST['invitee'];
	}
	else {
	    $invitee = $frmdata['invitee_id'];
	}

	if ($invitee > 0) {
		$_SESSION['s_user_id'] = "x";
	    $output_invite = $user->getUser($invitee);
		
		require_once($c_node['dir']['Igloo'] . $c_node['dir']['class_path'] . 'File.class.php');
		$file = new File($db, $c_node['file'], $c_node['dir']);
		$file->module = "user";
		$file->noimage = $c_node['file']['image']['thumb'][1]['noimage'];
		$file->thumb = $c_node['file']['image']['thumb'][1]['name'];
		
		if (isset($output_invite['profile_image_id'])) {
			$file->file_id = $output_invite['profile_image_id'];
			$output_invite['image'] = $file->getFileRecord();
		}
		else {
			$output_invite['image']['file_title'] = "";
			$output_invite['image']['file'] = $file->noimage;
		}
	}
}
	
	
//TEMPLATE
if (isset($c_node['node']['language_available'])) {
    $body->set('language_available', $c_node['node']['language_available']);
}

if (isset($c_node['node']['language_default'])) {
    $body->set('language_default', $c_node['node']['language_default']);
}

if (!empty($output_invite)) {
    $body->set('invite', $output_invite);
}

if (isset($display)) {
    $body->set('display', $display);
}

if (isset($_REQUEST['year'])) {
	$user_dob = $_REQUEST['year']."-".$_REQUEST['month']."-".$_REQUEST['day'];
	$body->set('year', $_REQUEST['year']);
	$body->set('month', $_REQUEST['month']);
	$body->set('day', $_REQUEST['day']);
}
else {
	$user_dob = null;
}

$body->set('datedropdown', $date->dateDropdown($user_dob));
$body->set('display_dob', $user_dob);

if (!empty($frmdata)) {
    $body->set('data', $frmdata);
}
else {
	$frmdata = array("language_id" => $me['language_id']);

	if (isset($_REQUEST['email'])) {
	    $frmdata['user_email'] = $_REQUEST['email'];
	}

	$body->set('data', $frmdata);
}

include "inc/footer.inc.php";
?>
