<?php

// -----------------------------------------------------------------------
// This file is part of Igloo
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

$core = "user";
include "inc/header.inc.php";

if (empty($_SESSION['report_abuse_url'])) {
    //we error and go back a page
	return header("Location: " . $me['user_homepage'] . "?" . strip_tags(SID));
	exit;
}


//format report abuse url
$report_abuse_url = $_SESSION['report_abuse_url'];
$report_abuse_url = str_replace('abuse_report=1', '', $report_abuse_url);

//format report abuse body
$report_abuse_body = $_SESSION['report_abuse_body'];
//remove href's
$report_abuse_body = preg_replace("/href=\"(.*)\"/", "href=\"#\"", $report_abuse_body);
//remove form
$report_abuse_body = preg_replace("/action=\"(.*)\"/", "action=\"#\"", $report_abuse_body);
$report_abuse_body_stripped = htmlspecialchars($report_abuse_body);
$report_abuse_body_stripped = str_replace("'", "\"", $report_abuse_body_stripped);


if (isset($_POST['send_report'])) {
	$frmdata['user_id'] = $me['user_id'];
	$frmdata['language_id'] = $me['language_id'];
	
	//setup email
	require_once($c_node['dir']['class_path'] . '/Mail/class.phpmailer.php');
	$mail = new PHPMailer();
	$mail->Host = 				$c_node['mail']['host'];
	$mail->Port = 		$c_node['mail']['port'];
	$mail->Mailer = 			$c_node['mail']['mailer'];
	
	if (isset($c_node['mail']['smtp']['username'])) {
		$mail->SMTPAuth = true;
		$mail->Username = $c_node['mail']['smtp']['username'];
		$mail->Password = $c_node['mail']['smtp']['password'];
	}
				
	$mail->From = 				$c_node['mail']['default_address'];
	$mail->FromName = 			$c_node['mail']['from_name'];
	$mail->WordWrap = 			$c_node['mail']['wordwrap'];
	$mail->AddReplyTo($c_node['mail']['default_address'], $c_node['mail']['from_name']);
	
	unset ($_SESSION['report_abuse_url'], $_SESSION['report_abuse_body']);
	
	insertReport($frmdata);
}





//move to template
$body->set('report_abuse_url', $report_abuse_url);
$body->set('report_abuse_body', $report_abuse_body);

include "inc/footer.inc.php";




/*
* sendInvite
* Tom Calthrop 8th November 2004
*/
function insertReport($frmdata) {

	global $db, $mail, $im, $languageTextPath, $me, $c_node, $lang, 
	$report_abuse_url, $report_abuse_body, 
	$report_abuse_body_stripped, $c_acs;
	
	$rec = array();
	$rec['abuse_url'] = $report_abuse_url;
	$rec['abuse_source'] = $report_abuse_body_stripped;
	$rec['reportee_user_id'] = $frmdata['user_id'];
	$rec['abuse_note'] = $frmdata['message'];
	$rec['reportee_language_id'] = $frmdata['language_id'];
	$rec['report_datetime'] = time();
	$rec['report_status_id'] = $c_node['rsp']['abuse_status']['unallocated'];
	
	$table = $db->prefix . "_abuse";
	
	$query = $db->GetInsertSQL($table, $rec, get_magic_quotes_gpc());
	$result = $db->Execute($query);
	
	
	if (isset($result)) {
		
		$abuse_id = $db->Insert_ID();
		
		$reference_id = "REF-" . $abuse_id;
		
		//prepare content to send
		$im_admin_file_txt = readTxtFile($languageTextPath . "im_abuse_reported.txt.php");
		$im_admin_file_txt = str_replace("\\\"", "\"", $im_admin_file_txt);
		$im_admin_file_txt = str_replace("ID_OF_REPORT", $reference_id, $im_admin_file_txt);
		$im_admin_file_txt = str_replace("NOTE", $frmdata['message'], $im_admin_file_txt);
		
		$mail_admin_file_txt = readTxtFile($languageTextPath . "mail_abuse_reported.txt.php");
		$mail_admin_file_txt = str_replace("\\\"", "\"", $mail_admin_file_txt);
		$mail_admin_file_txt = str_replace("ID_OF_REPORT", $reference_id, $mail_admin_file_txt);
		$mail_admin_file_txt = str_replace("NOTE", $frmdata['message'], $mail_admin_file_txt);
		$url = "http://" . $_SERVER['HTTP_HOST'];
		
		if (dirname ($_SERVER['PHP_SELF']) != "/") {
			$url .= dirname ($_SERVER['PHP_SELF']);
		}
		$mail_admin_file_txt = str_replace("URL", $url, $mail_admin_file_txt);
		
		$im_reportee_file_txt = readTxtFile($languageTextPath . "im_abuse_reported_thanks.txt.php");
		$im_reportee_file_txt = str_replace("\\\"", "\"", $im_reportee_file_txt);
		$im_reportee_file_txt = str_replace("NAME", $me['user_firstname'], $im_reportee_file_txt);
		$im_reportee_file_txt = str_replace("REF_NUMBER", $reference_id, $im_reportee_file_txt);
		
		//get node admins and send message and EMAIL.
		 $query = "
			SELECT user_id, user_email 
			FROM " . $db->prefix . "_user
			WHERE
			role_id=" . $c_acs['arr_acs']['resource']['administration']
		;
		
		$result = $db->Execute($query);
		
		if (isset($result->fields)) {
			while (!$result->EOF) {
				//send instant message to node admins
				$im->sendMessage($result->fields['user_id'], $lang['mail_subject_abuse_txt'], $im_admin_file_txt);
				
				//send email to email address
				$mail->Subject = $lang['mail_subject_abuse_txt'];
				$mail->Body = $mail_admin_file_txt;
				$mail->ClearAddresses();
				$mail->AddAddress($result->fields['user_email'], '');
				
				if(!$mail->Send()) {
					$log[] = array('error', 18, $mail->ErrorInfo); //Mailer Error
				}
				
				$result->MoveNext();
			}
			
			$result->Close();
		}
		
		//SEND THANK YOU MESSAGE TO REPORTER
		$im->sendMessage($me['user_id'], $lang['mail_subject_thanks_txt'], $im_reportee_file_txt);
	}
	
	//CLEAN UP
	header("Location: http://" . $report_abuse_url . "&" . strip_tags(SID));
	exit;

}//EO insertReport();

?>
