<?php

// -----------------------------------------------------------------------
// This file is part of Igloo
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------
?>


<?php
if (isset($display) && $display == "edit_report") {
?>
<form action="node_abuse_reports.php" method="post">
<input type="hidden" name="abuse_id" value="<?php if (isset($report['abuse_id'])) {echo $report['abuse_id'];}?>" />

<div class="box">
	<div class="box_top">
		<?php echo $lang['hdr_report'];?><br />
	</div>
	
	<div class="box_mid">
		<div class="content">
			<table border="0" cellspacing="0" cellpadding="2" width="100%">
				<tr>
					<td colspan="2">
						<?php echo $lang['txt_report_txt'];?><br />
					</td>
				</tr>
				<tr>
					<td>
						<?php echo $lang['txt_from'];?><br />
					</td>
					<td>
						<?php echo $report['user_firstname'] . " " . $report['user_surname'];?><br />
					</td>
				</tr>
				<tr>
					<td>
						<?php echo $lang['txt_language'];?><br />
					</td>
					<td>
						<?php echo $lang['arr_lang_name'][$report['reportee_language_id']];?><br />
					</td>
				</tr>
				<tr>
					<td>
						<?php echo $lang['txt_status'];?><br />
					</td>
					<td>
						<select name="report_status_id" class="formInput">
							<?php foreach($lang['arr_abuse_status'] as $key => $r):
							?>
							<option value="<?php echo $key;?>" <? if($report['report_status_id'] == $key) echo "selected";?>><?php echo $r;?></option>
							<?php
							endforeach;
							?>
						</select>
						<br />
					</td>
				</tr>
				<tr>
					<td>
						<?php echo $lang['txt_datetime'];?><br />
					</td>
					<td>
						<?php echo $report['report_datetime'];?><br />
					</td>
				</tr>
				<tr>
					<td>
						<?php echo $lang['txt_abuse_note'];?><br />
					</td>
					<td>
						<?php echo $report['abuse_note'];?><br />
					</td>
				</tr>
				
				<tr>
					<td>
						<?php echo $lang['txt_assigned'];?><br />
					</td>
					<td>
						<?php
						if (isset($report['assigned_firstname'])) {
							echo $report['assigned_firstname'] . " " . $report['assigned_surname'];
						}
						?><br />
					</td>
				</tr>
				<tr>
					<td align="right" colspan="3">
						<input type="submit" name="update_report" class="button_urgent" value="<?php echo $lang['sub_update_report'];?>" /><br />
					</td>
				</tr>
			</table>
		</div>
	</div>
</div>
	
<div class="box_bottom">
	<span class="box_bottom_right"></span>
	<span class="box_bottom_left"></span>
</div>

<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="10" alt="" /><br />

<div class="picture">
	<?php 
	$string = $report['abuse_source'];
	$string = str_replace ( '&amp;', '&', $string );
	$string = str_replace ( '&#039;', '"', $string );
	$string = str_replace ( '&quot;', '"', $string );
	$string = str_replace ( '&lt;', '<', $string );
	$string = str_replace ( '&gt;', '>', $string );
	$string = str_replace ( '&gt;', '>', $string );
	echo $string;
	?><br />
</div>

<p>
	<?php echo $lang['txt_from'];?>: <?php echo $report['abuse_url'];?><br />
</p>

<?php
}
else {
?>
<div class="box">
	<div class="box_top">
		<?php echo $lang['hdr_report_list'];?><br />
	</div>
	
	<div class="box_mid">
		<div class="content">
			<?php
			if (isset($reports)) {
			?>
			<table border="0" cellspacing="0" cellpadding="4" width="100%">
				<tr>
					<td>
						&nbsp;<br />
					</td>
					<td valign="top">
						<b><?php echo $lang['txt_datetime'];?></b><br />
					</td>
					<td valign="top">
						<b><?php echo $lang['txt_status'];?></b><br />
					</td>
					<td valign="top">
						<b><?php echo $lang['txt_reportee'];?></b><br />
					</td>
					<td valign="top">
						<b><?php echo $lang['txt_language'];?></b><br />
					</td>
				</tr>
				<?php
				$display_items = trimArray($reports);
				foreach($display_items as $key => $i):
				?>
				<tr>
					<td valign="top">
						<a href="node_abuse_reports.php?abuse_id=<?php echo $i['abuse_id'];?>"><?php echo $i['abuse_id'];?></a><br />
					</td>
					<td valign="top">
						<?php echo $i['report_datetime'];?><br />
					</td>
					<td valign="top">
						<?php echo $lang['arr_abuse_status'][$i['report_status_id']];?><br />
					</td>
					<td valign="top">
						<?php echo $i['user_firstname'] . " " . $i['user_surname'];?><br />
					</td>
					<td valign="top">
						<?php echo $lang['arr_lang_name'][$i['reportee_language_id']];?><br />
					</td>
				</tr>
				<?php
				endforeach;
				?>
			</table>
			<?php
			echo createArrayList($reports);
			?>
			<?php
			}
			else {
			?>
			<p>
				<?php echo $lang['err_no_reports'];?><br />
			</p>
			<?php }?>
		</div>
	</div>
</div>
	
<div class="box_bottom">
	<span class="box_bottom_right"></span>
	<span class="box_bottom_left"></span>
</div>
<?php }?>
</form>
