<?php

// -----------------------------------------------------------------------
// This file is part of Igloo
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------
$menu_section = "magazine";
include "inc/header.inc.php";


//setup RSS parser (gathers and parses RSS feeds or channels)
require_once('class/LastRss.class.php');
$rss = new lastRSS($db);
$rss->cache_dir = 'cache/feed'; 
$rss->cache_time = 3600; // one hour


// SETUP CHANNEL --------------------------------------------------------
require_once('class/Channel.class.php');
$channel = new Channel($db);


//get my channels
if (isset($me['user_id'])) {
	$channel->user_id = $me['user_id'];
	$output_my_channels = $channel->selChannels();
}


//get the node channels
unset($channel->user_id);
$channel->rsp_item_type_id = $c_node['rsp']['item_type']['channel'];
$channel->rsp_level_id = $rsp_level_id;
$channel->rsp_status_id = $c_node['rsp']['status']['live'];
$channel->language_ids = $me['language_ids'];
$output_channels = $channel->selChannels();


//if we get a channel ID get the channel list else get the newests my channel
if (isset($_REQUEST['channel_id'])) {
	$output_channel = $channel->selChannel($_REQUEST['channel_id']);
}
elseif (empty($output_channel)) {
	$key = count($output_channels);
	
	if ($key>=1) {
		$output_channel = $output_channels[$key-1];
	}
}

//get the channel links
if (!empty($output_channel)) {
	$output_channel['feed'] = $rss->get($output_channel['channel_url']);
}


//move vars to template
if (!empty($output_channels)) {
	$body->set('channels', $output_channels);
}

if (!empty($output_my_channels)) {
	$body->set('my_channels', $output_my_channels);
}

if (!empty($output_channel)) {
	$body->set('channel', $output_channel);
}

$template_pageLink = $lang['txt_channels'];

include "inc/footer.inc.php";

?>