<?xml version="1.0" encoding="ISO-8859-15"?>
<!-- 
 *   Copyright (C) 2002, 2003, 2004 Jatec AG, Switzerland
 *
 * This file is part of IronMailer.
 *
 * IronMailer is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:template name="flagbox">
 <!-- index is a counter for the form variables, so this sheet can be
      used several times within the same form -->
 <xsl:param name="index"/>

   <!-- Stuff to change flag settings on selected messages -->
   <td class="field_light_bg" align="center" width="45%" colspan="4">
      <!-- parameter "value" (value to set the flag to) -->
      <select class="simpletext">
        <xsl:attribute name="name">
	   <xsl:value-of select="concat('value',$index)"/>
	</xsl:attribute>
       	<option value="true"><xsl:value-of select="normalize-space(flag/actionchoice1)" /></option>
        <option value="false"><xsl:value-of select="normalize-space(flag/actionchoice2)" /></option>
      </select>
      <span class="simpletext">
         &#160;<xsl:value-of select="normalize-space(flag/actiontext1)" />&#160;
      </span>

      <!-- parameter "flag" (flag to set) -->
      <select class="simpletext">
        <xsl:attribute name="name">
	   <xsl:value-of select="concat('flag',$index)"/>
	</xsl:attribute>
	<option value="deleted"><xsl:value-of select="normalize-space(flag/flagtext1)" /></option>
	<option value="seen"><xsl:value-of select="normalize-space(flag/flagtext2)" /></option>
	<option value="answered"><xsl:value-of select="normalize-space(flag/flagtext3)" /></option>
	<option value="recent"><xsl:value-of select="normalize-space(flag/flagtext4)" /></option>
	<option value="draft"><xsl:value-of select="normalize-space(flag/flagtext5)" /></option>
      </select>
      <!-- First submit action -->
      <input class="simpletext" type="submit">
        <xsl:attribute name="name">
	   <xsl:value-of select="concat('flagmsgs',$index)"/>
	</xsl:attribute>
	<xsl:attribute name="value">
		<xsl:value-of select="normalize-space(flag/flagbuttontext)" />
	</xsl:attribute>
      </input>
   </td>


</xsl:template>

</xsl:stylesheet>
