/*
 * Decompiled with CFR 0.152.
 */
package net.jatec.ironmailer.controller;

import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Store;
import net.jatec.ironmailer.controller.ControllerException;
import net.jatec.ironmailer.controller.FolderSetupException;
import org.apache.log4j.Logger;

public class FolderManager {
    private final Logger log = Logger.getLogger((Class)(class$net$jatec$ironmailer$controller$FolderManager == null ? (class$net$jatec$ironmailer$controller$FolderManager = FolderManager.class$((String)"net.jatec.ironmailer.controller.FolderManager")) : class$net$jatec$ironmailer$controller$FolderManager));
    private Store store;
    static /* synthetic */ Class class$net$jatec$ironmailer$controller$FolderManager;

    public FolderManager(Store store) {
        this.store = store;
    }

    public Folder addFolder(String string, boolean bl) throws IllegalArgumentException, FolderSetupException {
        if (string == null || string.equals("")) {
            throw new IllegalArgumentException("parameter folderName must contain a value");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("addFolder() called for name " + string + "isMessageFolder=" + bl));
        }
        int n = bl ? 1 : 2;
        Folder folder = null;
        try {
            folder = this.store.getFolder(string);
            if (folder.exists()) {
                throw new FolderSetupException(string, "folder already exists", null);
            }
            if (!folder.create(n)) {
                throw new FolderSetupException(string, "create failed", null);
            }
            folder.setSubscribed(true);
        }
        catch (MessagingException messagingException) {
            throw new FolderSetupException(string, "unexpected error", (Throwable)messagingException);
        }
        return folder;
    }

    public void deleteFolder(Folder folder) throws IllegalArgumentException, FolderSetupException {
        if (folder == null) {
            throw new IllegalArgumentException("parameter folder may not be null");
        }
        String string = folder.getName();
        this.log.debug((Object)("deleteFolder() called for folder named " + string));
        try {
            folder.setSubscribed(false);
            if (folder.isOpen()) {
                folder.close(false);
            }
            if (!folder.delete(true)) {
                throw new FolderSetupException(string, "delete folder failed for an unknown reason", null);
            }
        }
        catch (MessagingException messagingException) {
            throw new FolderSetupException(string, "unexpected error in delete folder", (Throwable)messagingException);
        }
    }

    public static void moveMessages(Folder folder, Folder folder2, Message[] messageArray) throws IllegalArgumentException, ControllerException {
        if (folder == null || folder2 == null) {
            throw new IllegalArgumentException("parameters fromFolder and toFolder may not be null");
        }
        try {
            folder.copyMessages(messageArray, folder2);
            for (int i = 0; i < messageArray.length; ++i) {
                Message message = messageArray[i];
                message.setFlag(Flags.Flag.DELETED, true);
            }
            if (!folder.isOpen()) {
                folder.open(2);
            }
            folder.expunge();
        }
        catch (MessagingException messagingException) {
            throw new ControllerException("error in moveMessages", (Throwable)messagingException);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

