/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor.sitemap;

import java.util.Map;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.logger.Logger;
import org.apache.cocoon.components.treeprocessor.InvokeContext;
import org.apache.cocoon.components.treeprocessor.ProcessingNode;
import org.apache.cocoon.components.treeprocessor.SimpleParentProcessingNode;
import org.apache.cocoon.components.treeprocessor.sitemap.ErrorHandlerHelper;
import org.apache.cocoon.components.treeprocessor.sitemap.PipelineNode;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.environment.ForwardRedirector;
import org.apache.cocoon.environment.Redirector;

public final class PipelinesNode
extends SimpleParentProcessingNode
implements Composable,
Disposable {
    private static final String REDIRECTOR_ATTR = "sitemap:redirector";
    private ComponentManager manager;
    private ErrorHandlerHelper errorHandlerHelper = new ErrorHandlerHelper();
    private ProcessingNode errorHandler;

    public void compose(ComponentManager manager) {
        this.manager = manager;
        this.errorHandlerHelper.compose(manager);
    }

    public void enableLogging(Logger logger) {
        super.enableLogging(logger);
        this.errorHandlerHelper.enableLogging(logger);
    }

    public void setErrorHandler(ProcessingNode node) {
        this.errorHandler = node;
    }

    public void setChildren(ProcessingNode[] nodes) {
        ((PipelineNode)nodes[nodes.length - 1]).setLast(true);
        super.setChildren(nodes);
    }

    public static Redirector getRedirector(Environment env) {
        return (Redirector)env.getAttribute(REDIRECTOR_ATTR);
    }

    public final boolean invoke(Environment env, InvokeContext context) throws Exception {
        super.invoke(env, context);
        context.recompose(this.manager);
        ForwardRedirector redirector = new ForwardRedirector(env);
        this.setupLogger(redirector);
        Map objectModel = env.getObjectModel();
        Object oldResolver = objectModel.get("source-resolver");
        Object oldRedirector = env.getAttribute(REDIRECTOR_ATTR);
        objectModel.put("source-resolver", env);
        env.setAttribute(REDIRECTOR_ATTR, redirector);
        try {
            boolean bl = this.invokeNodes(this.children, env, context);
            return bl;
        }
        catch (Exception ex) {
            if (this.errorHandler != null) {
                boolean bl = this.errorHandlerHelper.invokeErrorHandler(this.errorHandler, ex, env);
                return bl;
            }
            throw ex;
        }
        finally {
            env.setAttribute(REDIRECTOR_ATTR, oldRedirector);
            objectModel.put("source-resolver", oldResolver);
        }
    }

    public void dispose() {
        if (this.manager instanceof Disposable) {
            ((Disposable)this.manager).dispose();
        }
        this.manager = null;
    }
}

