/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.component.servlet;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.GenericServlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import org.apache.avalon.excalibur.component.ExcaliburComponentManagerCreator;
import org.apache.avalon.excalibur.component.servlet.AbstractReferenceProxyLatch;
import org.apache.avalon.excalibur.component.servlet.ReferenceProxy;
import org.apache.avalon.excalibur.logger.LoggerManager;
import org.apache.avalon.framework.container.ContainerUtil;

public class ExcaliburComponentManagerServlet
extends GenericServlet {
    private ExcaliburComponentManagerCreator m_componentManagerCreator;
    private Latch m_latch;
    static /* synthetic */ Class class$org$apache$avalon$excalibur$logger$LoggerManager;
    static /* synthetic */ Class class$org$apache$avalon$framework$service$ServiceManager;
    static /* synthetic */ Class class$org$apache$avalon$framework$component$ComponentManager;
    static /* synthetic */ Class class$org$apache$excalibur$instrument$InstrumentManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        ServletContext servletContext = this.getServletContext();
        InputStream loggerManagerConfigStream = null;
        InputStream roleManagerConfigStream = null;
        InputStream componentManagerConfigStream = null;
        InputStream instrumentManagerConfigStream = null;
        try {
            loggerManagerConfigStream = this.getStreamFromParameter(servletConfig, "logkit", true);
            roleManagerConfigStream = this.getStreamFromParameter(servletConfig, "roles", true);
            componentManagerConfigStream = this.getStreamFromParameter(servletConfig, "components", true);
            instrumentManagerConfigStream = this.getStreamFromParameter(servletConfig, "instrument", false);
            try {
                this.m_componentManagerCreator = new ExcaliburComponentManagerCreator(null, loggerManagerConfigStream, roleManagerConfigStream, componentManagerConfigStream, instrumentManagerConfigStream);
            }
            catch (Exception e) {
                String msg = "Unable to create the ComponentManagerCreator.  Most likely a comfiguration problem.";
                throw new ServletException(msg, (Throwable)e);
            }
        }
        finally {
            try {
                if (loggerManagerConfigStream != null) {
                    loggerManagerConfigStream.close();
                }
                if (roleManagerConfigStream != null) {
                    roleManagerConfigStream.close();
                }
                if (componentManagerConfigStream != null) {
                    componentManagerConfigStream.close();
                }
                if (instrumentManagerConfigStream != null) {
                    instrumentManagerConfigStream.close();
                }
            }
            catch (IOException e) {
                throw new ServletException("Encountered an error closing resource streams.", (Throwable)e);
            }
        }
        LoggerManager loggerManager = this.m_componentManagerCreator.getLoggerManager();
        this.m_latch = new Latch(this.m_componentManagerCreator);
        this.m_latch.enableLogging(loggerManager.getLoggerForCategory("system.ecmservlet"));
        ReferenceProxy loggerManagerProxy = this.m_latch.createProxy(loggerManager, "LoggerManager");
        ReferenceProxy serviceManagerProxy = this.m_latch.createProxy(this.m_componentManagerCreator.getServiceManager(), "ServiceManager");
        ReferenceProxy componentManagerProxy = this.m_latch.createProxy(this.m_componentManagerCreator.getComponentManager(), "ComponentManager");
        ReferenceProxy instrumentManagerProxy = this.m_latch.createProxy(this.m_componentManagerCreator.getInstrumentManager(), "InstrumentManager");
        servletContext.setAttribute((class$org$apache$avalon$excalibur$logger$LoggerManager == null ? (class$org$apache$avalon$excalibur$logger$LoggerManager = ExcaliburComponentManagerServlet.class$("org.apache.avalon.excalibur.logger.LoggerManager")) : class$org$apache$avalon$excalibur$logger$LoggerManager).getName(), (Object)loggerManagerProxy);
        servletContext.setAttribute((class$org$apache$avalon$framework$service$ServiceManager == null ? (class$org$apache$avalon$framework$service$ServiceManager = ExcaliburComponentManagerServlet.class$("org.apache.avalon.framework.service.ServiceManager")) : class$org$apache$avalon$framework$service$ServiceManager).getName(), (Object)serviceManagerProxy);
        servletContext.setAttribute((class$org$apache$avalon$framework$component$ComponentManager == null ? (class$org$apache$avalon$framework$component$ComponentManager = ExcaliburComponentManagerServlet.class$("org.apache.avalon.framework.component.ComponentManager")) : class$org$apache$avalon$framework$component$ComponentManager).getName(), (Object)componentManagerProxy);
        servletContext.setAttribute((class$org$apache$excalibur$instrument$InstrumentManager == null ? (class$org$apache$excalibur$instrument$InstrumentManager = ExcaliburComponentManagerServlet.class$("org.apache.excalibur.instrument.InstrumentManager")) : class$org$apache$excalibur$instrument$InstrumentManager).getName(), (Object)instrumentManagerProxy);
    }

    public void destroy() {
        ServletContext servletContext = this.getServletContext();
        servletContext.removeAttribute((class$org$apache$avalon$excalibur$logger$LoggerManager == null ? (class$org$apache$avalon$excalibur$logger$LoggerManager = ExcaliburComponentManagerServlet.class$("org.apache.avalon.excalibur.logger.LoggerManager")) : class$org$apache$avalon$excalibur$logger$LoggerManager).getName());
        servletContext.removeAttribute((class$org$apache$avalon$framework$service$ServiceManager == null ? (class$org$apache$avalon$framework$service$ServiceManager = ExcaliburComponentManagerServlet.class$("org.apache.avalon.framework.service.ServiceManager")) : class$org$apache$avalon$framework$service$ServiceManager).getName());
        servletContext.removeAttribute((class$org$apache$avalon$framework$component$ComponentManager == null ? (class$org$apache$avalon$framework$component$ComponentManager = ExcaliburComponentManagerServlet.class$("org.apache.avalon.framework.component.ComponentManager")) : class$org$apache$avalon$framework$component$ComponentManager).getName());
        servletContext.removeAttribute((class$org$apache$excalibur$instrument$InstrumentManager == null ? (class$org$apache$excalibur$instrument$InstrumentManager = ExcaliburComponentManagerServlet.class$("org.apache.excalibur.instrument.InstrumentManager")) : class$org$apache$excalibur$instrument$InstrumentManager).getName());
        this.m_latch.requestTrigger();
    }

    public void service(ServletRequest servletRequest, ServletResponse servletResponse) throws UnavailableException {
        throw new UnavailableException(((Object)((Object)this)).getClass().getName() + " does not except service requests.");
    }

    private InputStream getStreamFromParameter(ServletConfig servletConfig, String resourceName, boolean required) throws ServletException {
        String configFileName = servletConfig.getInitParameter(resourceName);
        if (configFileName == null) {
            if (required) {
                throw new ServletException(resourceName + " parameter must be provided in servlet configuration.");
            }
            return null;
        }
        ServletContext servletContext = servletConfig.getServletContext();
        this.log("Attempting to access resource: " + configFileName);
        InputStream is = servletContext.getResourceAsStream(configFileName);
        if (is == null) {
            throw new ServletException("Resource '" + configFileName + "' is not available.");
        }
        return is;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Latch
    extends AbstractReferenceProxyLatch {
        ExcaliburComponentManagerCreator m_componentManagerCreator;

        Latch(ExcaliburComponentManagerCreator componentManagerCreator) {
            this.m_componentManagerCreator = componentManagerCreator;
        }

        public void triggered() throws Exception {
            ContainerUtil.shutdown((Object)this.m_componentManagerCreator);
        }
    }
}

