/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.PrimitiveType;

public class ArrayCreation
extends Expression {
    private ArrayType arrayType = null;
    private ASTNode.NodeList dimensions;
    private ArrayInitializer optionalInitializer;
    static /* synthetic */ Class class$0;

    ArrayCreation(AST ast) {
        super(ast);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.dom.Expression");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.dimensions = new ASTNode.NodeList(true, clazz);
        this.optionalInitializer = null;
    }

    public int getNodeType() {
        return 3;
    }

    ASTNode clone(AST target) {
        ArrayCreation result = new ArrayCreation(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.setType((ArrayType)this.getType().clone(target));
        result.dimensions().addAll(ASTNode.copySubtrees(target, this.dimensions()));
        result.setInitializer((ArrayInitializer)ASTNode.copySubtree(target, this.getInitializer()));
        return result;
    }

    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.acceptChild(visitor, this.getType());
            this.acceptChildren(visitor, this.dimensions);
            this.acceptChild(visitor, this.getInitializer());
        }
        visitor.endVisit(this);
    }

    public ArrayType getType() {
        if (this.arrayType == null) {
            long count = this.getAST().modificationCount();
            this.setType(this.getAST().newArrayType(this.getAST().newPrimitiveType(PrimitiveType.INT)));
            this.getAST().setModificationCount(count);
        }
        return this.arrayType;
    }

    public void setType(ArrayType type) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        this.replaceChild(this.arrayType, type, false);
        this.arrayType = type;
    }

    public List dimensions() {
        return this.dimensions;
    }

    public ArrayInitializer getInitializer() {
        return this.optionalInitializer;
    }

    public void setInitializer(ArrayInitializer initializer) {
        this.replaceChild(this.optionalInitializer, initializer, true);
        this.optionalInitializer = initializer;
    }

    int memSize() {
        return 48;
    }

    int treeSize() {
        int size = this.memSize() + (this.arrayType == null ? 0 : this.getType().treeSize()) + (this.optionalInitializer == null ? 0 : this.getInitializer().treeSize()) + this.dimensions.listSize();
        return size;
    }
}

