/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.SimpleName;

public class Assignment
extends Expression {
    private Operator assignmentOperator = Operator.ASSIGN;
    private Expression leftHandSide = null;
    private Expression rightHandSide = null;

    Assignment(AST ast) {
        super(ast);
    }

    public int getNodeType() {
        return 7;
    }

    ASTNode clone(AST target) {
        Assignment result = new Assignment(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.setOperator(this.getOperator());
        result.setLeftHandSide((Expression)this.getLeftHandSide().clone(target));
        result.setRightHandSide((Expression)this.getRightHandSide().clone(target));
        return result;
    }

    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.acceptChild(visitor, this.getLeftHandSide());
            this.acceptChild(visitor, this.getRightHandSide());
        }
        visitor.endVisit(this);
    }

    public Operator getOperator() {
        return this.assignmentOperator;
    }

    public void setOperator(Operator assignmentOperator) {
        if (assignmentOperator == null) {
            throw new IllegalArgumentException();
        }
        this.modifying();
        this.assignmentOperator = assignmentOperator;
    }

    public Expression getLeftHandSide() {
        if (this.leftHandSide == null) {
            long count = this.getAST().modificationCount();
            this.setLeftHandSide(new SimpleName(this.getAST()));
            this.getAST().setModificationCount(count);
        }
        return this.leftHandSide;
    }

    public void setLeftHandSide(Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException();
        }
        this.replaceChild(this.leftHandSide, expression, true);
        this.leftHandSide = expression;
    }

    public Expression getRightHandSide() {
        if (this.rightHandSide == null) {
            long count = this.getAST().modificationCount();
            this.setRightHandSide(new SimpleName(this.getAST()));
            this.getAST().setModificationCount(count);
        }
        return this.rightHandSide;
    }

    public void setRightHandSide(Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException();
        }
        this.replaceChild(this.rightHandSide, expression, true);
        this.rightHandSide = expression;
    }

    int memSize() {
        return 48;
    }

    int treeSize() {
        return this.memSize() + (this.leftHandSide == null ? 0 : this.getLeftHandSide().treeSize()) + (this.rightHandSide == null ? 0 : this.getRightHandSide().treeSize());
    }

    public static class Operator {
        private String op;
        public static final Operator ASSIGN = new Operator("=");
        public static final Operator PLUS_ASSIGN = new Operator("+=");
        public static final Operator MINUS_ASSIGN = new Operator("-=");
        public static final Operator TIMES_ASSIGN = new Operator("*=");
        public static final Operator DIVIDE_ASSIGN = new Operator("/=");
        public static final Operator BIT_AND_ASSIGN = new Operator("&=");
        public static final Operator BIT_OR_ASSIGN = new Operator("|=");
        public static final Operator BIT_XOR_ASSIGN = new Operator("^=");
        public static final Operator REMAINDER_ASSIGN = new Operator("%=");
        public static final Operator LEFT_SHIFT_ASSIGN = new Operator("<<=");
        public static final Operator RIGHT_SHIFT_SIGNED_ASSIGN = new Operator(">>=");
        public static final Operator RIGHT_SHIFT_UNSIGNED_ASSIGN = new Operator(">>>=");
        private static final Map CODES = new HashMap(20);

        static {
            Operator[] ops = new Operator[]{ASSIGN, PLUS_ASSIGN, MINUS_ASSIGN, TIMES_ASSIGN, DIVIDE_ASSIGN, BIT_AND_ASSIGN, BIT_OR_ASSIGN, BIT_XOR_ASSIGN, REMAINDER_ASSIGN, LEFT_SHIFT_ASSIGN, RIGHT_SHIFT_SIGNED_ASSIGN, RIGHT_SHIFT_UNSIGNED_ASSIGN};
            int i = 0;
            while (i < ops.length) {
                CODES.put(ops[i].toString(), ops[i]);
                ++i;
            }
        }

        private Operator(String op) {
            this.op = op;
        }

        public String toString() {
            return this.op;
        }

        public static Operator toOperator(String token) {
            return (Operator)CODES.get(token);
        }
    }
}

