/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.codeassist.complete;

import org.eclipse.jdt.internal.codeassist.complete.CompletionNodeFound;
import org.eclipse.jdt.internal.compiler.ast.AstNode;
import org.eclipse.jdt.internal.compiler.ast.ExplicitConstructorCall;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;

public class CompletionOnExplicitConstructorCall
extends ExplicitConstructorCall {
    public CompletionOnExplicitConstructorCall(int accessMode) {
        super(accessMode);
    }

    public void resolve(BlockScope scope) {
        ReferenceBinding receiverType = scope.enclosingSourceType();
        if (this.arguments != null) {
            int argsLength;
            int a = argsLength = this.arguments.length;
            while (--a >= 0) {
                this.arguments[a].resolveType(scope);
            }
        }
        if (this.accessMode != 3 && receiverType != null) {
            if (receiverType.isHierarchyInconsistent()) {
                throw new CompletionNodeFound();
            }
            receiverType = ((ReferenceBinding)receiverType).superclass();
        }
        if (receiverType == null) {
            throw new CompletionNodeFound();
        }
        throw new CompletionNodeFound(this, receiverType, scope);
    }

    public String toString(int tab) {
        String s = AstNode.tabString(tab);
        s = String.valueOf(s) + "<CompleteOnExplicitConstructorCall:";
        if (this.qualification != null) {
            s = String.valueOf(s) + this.qualification.toStringExpression() + ".";
        }
        s = this.accessMode == 3 ? String.valueOf(s) + "this(" : String.valueOf(s) + "super(";
        if (this.arguments != null) {
            int i = 0;
            while (i < this.arguments.length) {
                s = String.valueOf(s) + this.arguments[i].toStringExpression();
                if (i != this.arguments.length - 1) {
                    s = String.valueOf(s) + ", ";
                }
                ++i;
            }
        }
        s = String.valueOf(s) + ")>";
        return s;
    }
}

