/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.IAbstractSyntaxTreeVisitor;
import org.eclipse.jdt.internal.compiler.ast.AbstractVariableDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.jdt.internal.compiler.ast.AstNode;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class FieldDeclaration
extends AbstractVariableDeclaration {
    public FieldBinding binding;
    boolean hasBeenResolved = false;
    public int endPart1Position;
    public int endPart2Position;

    public FieldDeclaration() {
    }

    public FieldDeclaration(Expression initialization, char[] name, int sourceStart, int sourceEnd) {
        this.initialization = initialization;
        this.name = name;
        this.sourceStart = sourceStart;
        this.sourceEnd = sourceEnd;
    }

    public FlowInfo analyseCode(MethodScope initializationScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.binding != null && this.binding.isPrivate() && !this.binding.isPrivateUsed() && !initializationScope.referenceCompilationUnit().compilationResult.hasSyntaxError()) {
            initializationScope.problemReporter().unusedPrivateField(this);
        }
        if (this.binding != null && this.binding.isValidBinding() && this.binding.isStatic() && this.binding.constant == AstNode.NotAConstant && this.binding.declaringClass.isNestedType() && this.binding.declaringClass.isClass() && !this.binding.declaringClass.isStatic()) {
            initializationScope.problemReporter().unexpectedStaticModifierForField((SourceTypeBinding)this.binding.declaringClass, this);
        }
        if (this.initialization != null) {
            flowInfo = this.initialization.analyseCode(initializationScope, flowContext, flowInfo).unconditionalInits();
            flowInfo.markAsDefinitelyAssigned(this.binding);
        }
        return flowInfo;
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream) {
        boolean isStatic;
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        int pc = codeStream.position;
        if (!(this.initialization == null || (isStatic = this.binding.isStatic()) && this.binding.constant != AstNode.NotAConstant)) {
            if (!isStatic) {
                codeStream.aload_0();
            }
            this.initialization.generateCode(currentScope, codeStream, true);
            if (isStatic) {
                codeStream.putstatic(this.binding);
            } else {
                codeStream.putfield(this.binding);
            }
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    public TypeBinding getTypeBinding(Scope scope) {
        return this.type.getTypeBinding(scope);
    }

    public boolean isField() {
        return true;
    }

    public boolean isStatic() {
        if (this.binding != null) {
            return this.binding.isStatic();
        }
        return (this.modifiers & 8) != 0;
    }

    public String name() {
        return String.valueOf(this.name);
    }

    public void resolve(MethodScope initializationScope) {
        block14: {
            block15: {
                if (this.hasBeenResolved || this.binding == null || !this.binding.isValidBinding()) break block14;
                this.hasBeenResolved = true;
                if (this.isTypeUseDeprecated(this.binding.type, initializationScope)) {
                    initializationScope.problemReporter().deprecatedType(this.binding.type, this.type);
                }
                this.type.resolvedType = this.binding.type;
                if (this.initialization != null) break block15;
                this.binding.constant = Constant.NotAConstant;
                break block14;
            }
            int previous = initializationScope.fieldDeclarationIndex;
            try {
                initializationScope.fieldDeclarationIndex = this.binding.id;
                this.binding.constant = Constant.NotAConstant;
                TypeBinding typeBinding = this.binding.type;
                if (this.initialization instanceof ArrayInitializer) {
                    TypeBinding initializationTypeBinding = this.initialization.resolveTypeExpecting(initializationScope, typeBinding);
                    if (initializationTypeBinding != null) {
                        ((ArrayInitializer)this.initialization).binding = (ArrayBinding)initializationTypeBinding;
                        this.initialization.implicitWidening(typeBinding, initializationTypeBinding);
                    }
                } else {
                    TypeBinding initializationTypeBinding = this.initialization.resolveType(initializationScope);
                    if (initializationTypeBinding != null) {
                        if (this.initialization.isConstantValueOfTypeAssignableToType(initializationTypeBinding, typeBinding) || typeBinding.isBaseType() && BaseTypeBinding.isWidening(typeBinding.id, initializationTypeBinding.id)) {
                            this.initialization.implicitWidening(typeBinding, initializationTypeBinding);
                        } else if (initializationTypeBinding.isCompatibleWith(typeBinding)) {
                            this.initialization.implicitWidening(typeBinding, initializationTypeBinding);
                        } else {
                            initializationScope.problemReporter().typeMismatchError(initializationTypeBinding, typeBinding, this);
                        }
                        if (this.binding.isFinal()) {
                            this.binding.constant = this.initialization.constant.castTo((this.binding.type.id << 4) + this.initialization.constant.typeID());
                        }
                    } else {
                        this.binding.constant = AstNode.NotAConstant;
                    }
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                initializationScope.fieldDeclarationIndex = previous;
                if (this.binding.constant == null) {
                    this.binding.constant = Constant.NotAConstant;
                }
                throw throwable;
            }
            Object var5_8 = null;
            initializationScope.fieldDeclarationIndex = previous;
            if (this.binding.constant != null) break block14;
            this.binding.constant = Constant.NotAConstant;
        }
    }

    public void traverse(IAbstractSyntaxTreeVisitor visitor, MethodScope scope) {
        if (visitor.visit(this, scope)) {
            this.type.traverse(visitor, scope);
            if (this.initialization != null) {
                this.initialization.traverse(visitor, scope);
            }
        }
        visitor.endVisit(this, scope);
    }
}

