/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.parser;

import org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.jdt.internal.compiler.ast.AstNode;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.parser.RecoveredElement;
import org.eclipse.jdt.internal.compiler.parser.RecoveredStatement;

public class RecoveredLocalVariable
extends RecoveredStatement {
    public LocalDeclaration localDeclaration;
    boolean alreadyCompletedLocalInitialization;

    public RecoveredLocalVariable(LocalDeclaration localDeclaration, RecoveredElement parent, int bracketBalance) {
        super(localDeclaration, parent, bracketBalance);
        this.localDeclaration = localDeclaration;
        this.alreadyCompletedLocalInitialization = localDeclaration.initialization != null;
    }

    public RecoveredElement add(Statement statement, int bracketBalance) {
        if (this.alreadyCompletedLocalInitialization || !(statement instanceof Expression)) {
            return super.add(statement, bracketBalance);
        }
        this.alreadyCompletedLocalInitialization = true;
        this.localDeclaration.initialization = (Expression)statement;
        this.localDeclaration.declarationSourceEnd = statement.sourceEnd;
        this.localDeclaration.declarationEnd = statement.sourceEnd;
        return this;
    }

    public AstNode parseTree() {
        return this.localDeclaration;
    }

    public int sourceEnd() {
        return this.localDeclaration.declarationSourceEnd;
    }

    public String toString(int tab) {
        return String.valueOf(this.tabString(tab)) + "Recovered local variable:\n" + this.localDeclaration.toString(tab + 1);
    }

    public Statement updatedStatement() {
        return this.localDeclaration;
    }

    public RecoveredElement updateOnClosingBrace(int braceStart, int braceEnd) {
        if (this.bracketBalance > 0) {
            --this.bracketBalance;
            if (this.bracketBalance == 0) {
                this.alreadyCompletedLocalInitialization = true;
            }
            return this;
        }
        if (this.parent != null) {
            return this.parent.updateOnClosingBrace(braceStart, braceEnd);
        }
        return this;
    }

    public RecoveredElement updateOnOpeningBrace(int currentPosition) {
        if (this.localDeclaration.declarationSourceEnd == 0 && this.localDeclaration.type instanceof ArrayTypeReference && !this.alreadyCompletedLocalInitialization) {
            ++this.bracketBalance;
            return null;
        }
        this.updateSourceEndIfNecessary(currentPosition - 1);
        return this.parent.updateOnOpeningBrace(currentPosition);
    }

    public void updateParseTree() {
        this.updatedStatement();
    }

    public void updateSourceEndIfNecessary(int sourceEnd) {
        if (this.localDeclaration.declarationSourceEnd == 0) {
            this.localDeclaration.declarationSourceEnd = sourceEnd;
            this.localDeclaration.declarationEnd = sourceEnd;
        }
    }
}

