/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.util.Map;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.JavaElementDelta;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaModelOperation;
import org.eclipse.jdt.internal.core.WorkingCopy;

public class DestroyWorkingCopyOperation
extends JavaModelOperation {
    public DestroyWorkingCopyOperation(IJavaElement workingCopy) {
        super(new IJavaElement[]{workingCopy});
    }

    protected void executeOperation() throws JavaModelException {
        WorkingCopy workingCopy = this.getWorkingCopy();
        workingCopy.close();
        IJavaElement originalElement = workingCopy.getOriginalElement();
        if (!workingCopy.getParent().exists()) {
            ((CompilationUnit)originalElement).close();
        }
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        Map sharedWorkingCopies = manager.sharedWorkingCopies;
        Map perFactoryWorkingCopies = (Map)sharedWorkingCopies.get(workingCopy.bufferFactory);
        if (perFactoryWorkingCopies != null && perFactoryWorkingCopies.remove(originalElement) != null && CompilationUnit.SHARED_WC_VERBOSE) {
            System.out.println("Destroying shared working copy " + workingCopy.toStringWithAncestors());
        }
        JavaElementDelta delta = new JavaElementDelta(this.getJavaModel());
        delta.removed(workingCopy);
        this.addDelta(delta);
        this.removeReconcileDelta(workingCopy);
    }

    protected WorkingCopy getWorkingCopy() {
        return (WorkingCopy)this.getElementToProcess();
    }

    public boolean isReadOnly() {
        return true;
    }
}

