/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.internal.compiler.util.HashtableOfObject;
import org.eclipse.jdt.internal.compiler.util.ObjectVector;
import org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.eclipse.jdt.internal.core.search.matching.MatchingOpenable;

public class MatchingOpenableSet {
    private HashtableOfObject rootsToOpenable = new HashtableOfObject(5);
    private int elementCount = 0;

    public void add(MatchingOpenable matchingOpenable) {
        PackageFragmentRoot root = matchingOpenable.openable.getPackageFragmentRoot();
        char[] path = root.getPath().toString().toCharArray();
        ObjectVector openables = (ObjectVector)this.rootsToOpenable.get(path);
        if (openables == null) {
            openables = new ObjectVector();
            this.rootsToOpenable.put(path, openables);
            openables.add(matchingOpenable);
            ++this.elementCount;
        } else if (!openables.contains(matchingOpenable)) {
            openables.add(matchingOpenable);
            ++this.elementCount;
        }
    }

    public MatchingOpenable[] getMatchingOpenables(IPackageFragmentRoot[] roots) {
        Object[] result = new MatchingOpenable[this.elementCount];
        int index = 0;
        int i = 0;
        int length = roots.length;
        while (i < length) {
            IPackageFragmentRoot root = roots[i];
            char[] path = root.getPath().toString().toCharArray();
            ObjectVector openables = (ObjectVector)this.rootsToOpenable.get(path);
            if (openables != null) {
                openables.copyInto(result, index);
                index += openables.size();
            }
            ++i;
        }
        if (index < this.elementCount) {
            Object[] objectArray = result;
            result = new MatchingOpenable[index];
            System.arraycopy(objectArray, 0, result, 0, index);
        }
        return result;
    }
}

