/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import org.apache.batik.dom.svg.SVGOMElement;
import org.apache.batik.dom.svg.SVGTextContent;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGMatrix;
import org.w3c.dom.svg.SVGPoint;
import org.w3c.dom.svg.SVGRect;

public class SVGTextContentSupport {
    public static int getNumberOfChars(Element element) {
        SVGOMElement sVGOMElement = (SVGOMElement)element;
        return ((SVGTextContent)((Object)sVGOMElement.getSVGContext())).getNumberOfChars();
    }

    public static SVGRect getExtentOfChar(Element element, final int n) {
        final SVGOMElement sVGOMElement = (SVGOMElement)element;
        if (n < 0 || n >= SVGTextContentSupport.getNumberOfChars(element)) {
            throw sVGOMElement.createDOMException((short)1, "", null);
        }
        final SVGTextContent sVGTextContent = (SVGTextContent)((Object)sVGOMElement.getSVGContext());
        return new SVGRect(){

            public float getX() {
                return (float)sVGTextContent.getExtentOfChar(n).getX();
            }

            public void setX(float f) throws DOMException {
                throw sVGOMElement.createDOMException((short)7, "readonly.rect", null);
            }

            public float getY() {
                return (float)sVGTextContent.getExtentOfChar(n).getY();
            }

            public void setY(float f) throws DOMException {
                throw sVGOMElement.createDOMException((short)7, "readonly.rect", null);
            }

            public float getWidth() {
                return (float)sVGTextContent.getExtentOfChar(n).getWidth();
            }

            public void setWidth(float f) throws DOMException {
                throw sVGOMElement.createDOMException((short)7, "readonly.rect", null);
            }

            public float getHeight() {
                return (float)sVGTextContent.getExtentOfChar(n).getHeight();
            }

            public void setHeight(float f) throws DOMException {
                throw sVGOMElement.createDOMException((short)7, "readonly.rect", null);
            }
        };
    }

    public static SVGPoint getStartPositionOfChar(Element element, final int n) throws DOMException {
        final SVGOMElement sVGOMElement = (SVGOMElement)element;
        if (n < 0 || n >= SVGTextContentSupport.getNumberOfChars(element)) {
            throw sVGOMElement.createDOMException((short)1, "", null);
        }
        final SVGTextContent sVGTextContent = (SVGTextContent)((Object)sVGOMElement.getSVGContext());
        return new SVGPoint(){

            public float getX() {
                return (float)sVGTextContent.getStartPositionOfChar(n).getX();
            }

            public float getY() {
                return (float)sVGTextContent.getStartPositionOfChar(n).getY();
            }

            public void setX(float f) throws DOMException {
                throw sVGOMElement.createDOMException((short)7, "readonly.point", null);
            }

            public void setY(float f) throws DOMException {
                throw sVGOMElement.createDOMException((short)7, "readonly.point", null);
            }

            public SVGPoint matrixTransform(SVGMatrix sVGMatrix) {
                throw new RuntimeException("!!! TODO: matrixTransform()");
            }
        };
    }

    public static SVGPoint getEndPositionOfChar(Element element, final int n) throws DOMException {
        final SVGOMElement sVGOMElement = (SVGOMElement)element;
        if (n < 0 || n >= SVGTextContentSupport.getNumberOfChars(element)) {
            throw sVGOMElement.createDOMException((short)1, "", null);
        }
        final SVGTextContent sVGTextContent = (SVGTextContent)((Object)sVGOMElement.getSVGContext());
        return new SVGPoint(){

            public float getX() {
                return (float)sVGTextContent.getEndPositionOfChar(n).getX();
            }

            public float getY() {
                return (float)sVGTextContent.getEndPositionOfChar(n).getY();
            }

            public void setX(float f) throws DOMException {
                throw sVGOMElement.createDOMException((short)7, "readonly.point", null);
            }

            public void setY(float f) throws DOMException {
                throw sVGOMElement.createDOMException((short)7, "readonly.point", null);
            }

            public SVGPoint matrixTransform(SVGMatrix sVGMatrix) {
                throw new RuntimeException("!!! TODO: matrixTransform()");
            }
        };
    }

    public static void selectSubString(Element element, int n, int n2) {
        SVGOMElement sVGOMElement = (SVGOMElement)element;
        if (n < 0 || n >= SVGTextContentSupport.getNumberOfChars(element)) {
            throw sVGOMElement.createDOMException((short)1, "", null);
        }
        SVGTextContent sVGTextContent = (SVGTextContent)((Object)sVGOMElement.getSVGContext());
        sVGTextContent.selectSubString(n, n2);
    }

    public static float getRotationOfChar(Element element, int n) {
        SVGOMElement sVGOMElement = (SVGOMElement)element;
        if (n < 0 || n >= SVGTextContentSupport.getNumberOfChars(element)) {
            throw sVGOMElement.createDOMException((short)1, "", null);
        }
        SVGTextContent sVGTextContent = (SVGTextContent)((Object)sVGOMElement.getSVGContext());
        return sVGTextContent.getRotationOfChar(n);
    }

    public static float getComputedTextLength(Element element) {
        SVGOMElement sVGOMElement = (SVGOMElement)element;
        SVGTextContent sVGTextContent = (SVGTextContent)((Object)sVGOMElement.getSVGContext());
        return sVGTextContent.getComputedTextLength();
    }

    public static float getSubStringLength(Element element, int n, int n2) {
        SVGOMElement sVGOMElement = (SVGOMElement)element;
        if (n < 0 || n >= SVGTextContentSupport.getNumberOfChars(element)) {
            throw sVGOMElement.createDOMException((short)1, "", null);
        }
        SVGTextContent sVGTextContent = (SVGTextContent)((Object)sVGOMElement.getSVGContext());
        return sVGTextContent.getSubStringLength(n, n2);
    }

    public static int getCharNumAtPosition(Element element, float f, float f2) throws DOMException {
        SVGOMElement sVGOMElement = (SVGOMElement)element;
        SVGTextContent sVGTextContent = (SVGTextContent)((Object)sVGOMElement.getSVGContext());
        return sVGTextContent.getCharNumAtPosition(f, f2);
    }
}

