/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.rendered;

import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.BandCombineOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import org.apache.batik.ext.awt.ColorSpaceHintKey;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.rendered.AbstractRed;
import org.apache.batik.ext.awt.image.rendered.CachableRed;

public class Any2LumRed
extends AbstractRed {
    public Any2LumRed(CachableRed cachableRed) {
        super(cachableRed, cachableRed.getBounds(), Any2LumRed.fixColorModel(cachableRed), Any2LumRed.fixSampleModel(cachableRed), cachableRed.getTileGridXOffset(), cachableRed.getTileGridYOffset(), null);
        this.props.put("org.apache.batik.gvt.filter.Colorspace", ColorSpaceHintKey.VALUE_COLORSPACE_GREY);
    }

    public WritableRaster copyData(WritableRaster writableRaster) {
        CachableRed cachableRed = (CachableRed)this.getSources().get(0);
        SampleModel sampleModel = cachableRed.getSampleModel();
        ColorModel colorModel = cachableRed.getColorModel();
        if (colorModel == null) {
            float[][] fArray = null;
            if (sampleModel.getNumBands() == 2) {
                fArray = new float[2][2];
                fArray[0][0] = 1.0f;
                fArray[1][1] = 1.0f;
            } else {
                fArray = new float[sampleModel.getNumBands()][1];
                fArray[0][0] = 1.0f;
            }
            Raster raster = cachableRed.getData(writableRaster.getBounds());
            BandCombineOp bandCombineOp = new BandCombineOp(fArray, null);
            bandCombineOp.filter(raster, writableRaster);
        } else {
            Object object;
            BufferedImage bufferedImage;
            Raster raster = cachableRed.getData(writableRaster.getBounds());
            WritableRaster writableRaster2 = (WritableRaster)raster;
            ColorModel colorModel2 = colorModel;
            if (colorModel.hasAlpha()) {
                colorModel2 = GraphicsUtil.coerceData(writableRaster2, colorModel, false);
            }
            BufferedImage bufferedImage2 = new BufferedImage(colorModel, writableRaster2.createWritableTranslatedChild(0, 0), false, null);
            ColorModel colorModel3 = this.getColorModel();
            if (!colorModel3.hasAlpha()) {
                bufferedImage = new BufferedImage(colorModel3, writableRaster.createWritableTranslatedChild(0, 0), colorModel3.isAlphaPremultiplied(), null);
            } else {
                object = (PixelInterleavedSampleModel)writableRaster.getSampleModel();
                PixelInterleavedSampleModel pixelInterleavedSampleModel = new PixelInterleavedSampleModel(((SampleModel)object).getDataType(), ((SampleModel)object).getWidth(), ((SampleModel)object).getHeight(), ((ComponentSampleModel)object).getPixelStride(), ((ComponentSampleModel)object).getScanlineStride(), new int[]{0});
                WritableRaster writableRaster3 = Raster.createWritableRaster(pixelInterleavedSampleModel, writableRaster.getDataBuffer(), new Point(0, 0));
                writableRaster3 = writableRaster3.createWritableChild(writableRaster.getMinX() - writableRaster.getSampleModelTranslateX(), writableRaster.getMinY() - writableRaster.getSampleModelTranslateY(), writableRaster.getWidth(), writableRaster.getHeight(), 0, 0, null);
                ComponentColorModel componentColorModel = new ComponentColorModel(ColorSpace.getInstance(1003), new int[]{8}, false, false, 1, 0);
                bufferedImage = new BufferedImage(componentColorModel, writableRaster3, false, null);
            }
            object = new ColorConvertOp(null);
            ((ColorConvertOp)object).filter(bufferedImage2, bufferedImage);
            if (colorModel3.hasAlpha()) {
                Any2LumRed.copyBand(writableRaster2, sampleModel.getNumBands() - 1, writableRaster, this.getSampleModel().getNumBands() - 1);
            }
        }
        return writableRaster;
    }

    protected static ColorModel fixColorModel(CachableRed cachableRed) {
        ColorModel colorModel = cachableRed.getColorModel();
        if (colorModel != null) {
            if (colorModel.hasAlpha()) {
                return new ComponentColorModel(ColorSpace.getInstance(1003), new int[]{8, 8}, true, colorModel.isAlphaPremultiplied(), 3, 0);
            }
            return new ComponentColorModel(ColorSpace.getInstance(1003), new int[]{8}, false, false, 1, 0);
        }
        SampleModel sampleModel = cachableRed.getSampleModel();
        if (sampleModel.getNumBands() == 2) {
            return new ComponentColorModel(ColorSpace.getInstance(1003), new int[]{8, 8}, true, true, 3, 0);
        }
        return new ComponentColorModel(ColorSpace.getInstance(1003), new int[]{8}, false, false, 1, 0);
    }

    protected static SampleModel fixSampleModel(CachableRed cachableRed) {
        SampleModel sampleModel = cachableRed.getSampleModel();
        int n = sampleModel.getWidth();
        int n2 = sampleModel.getHeight();
        ColorModel colorModel = cachableRed.getColorModel();
        if (colorModel != null) {
            if (colorModel.hasAlpha()) {
                return new PixelInterleavedSampleModel(0, n, n2, 2, 2 * n, new int[]{0, 1});
            }
            return new PixelInterleavedSampleModel(0, n, n2, 1, n, new int[]{0});
        }
        if (sampleModel.getNumBands() == 2) {
            return new PixelInterleavedSampleModel(0, n, n2, 2, 2 * n, new int[]{0, 1});
        }
        return new PixelInterleavedSampleModel(0, n, n2, 1, n, new int[]{0});
    }
}

