/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.text;

import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.HashMap;
import java.util.Map;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;

public class ArabicTextHandler {
    private static final int arabicStart = 1536;
    private static final int arabicEnd = 1791;
    private static final Map charMap = new HashMap(54);

    /*
     * WARNING - void declaration
     */
    public static AttributedString assignArabicForms(AttributedString attributedString) {
        boolean bl;
        void var6_11;
        char c;
        char c2;
        char c4;
        if (!ArabicTextHandler.containsArabic(attributedString)) {
            return attributedString;
        }
        AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
        boolean bl2 = false;
        char c5 = attributedCharacterIterator.getEndIndex() - attributedCharacterIterator.getBeginIndex();
        int[] nArray = new int[c5];
        for (c4 = '\u0000'; c4 < c5; ++c4) {
            nArray[c4] = c4 + attributedCharacterIterator.getBeginIndex();
        }
        for (c4 = '\u0001'; c4 < c5 - 1; ++c4) {
            char c3 = attributedCharacterIterator.setIndex(attributedCharacterIterator.getBeginIndex() + c4);
            if (!ArabicTextHandler.arabicCharTransparent(c3)) continue;
            c2 = attributedCharacterIterator.setIndex(attributedCharacterIterator.getBeginIndex() + c4 - 1);
            c = attributedCharacterIterator.setIndex(attributedCharacterIterator.getBeginIndex() + c4 + 1);
            if (charMap.get("" + c2 + c) == null) continue;
            bl2 = true;
            int n = nArray[c4];
            nArray[c4] = nArray[c4 - '\u0001'];
            nArray[c4 - '\u0001'] = n;
        }
        if (bl2) {
            String string = "";
            for (c2 = '\u0000'; c2 < c5; ++c2) {
                char c3 = attributedCharacterIterator.setIndex(nArray[c2]);
                string = string + c3;
            }
            AttributedString attributedString2 = new AttributedString(string);
            for (c = '\u0000'; c < c5; ++c) {
                attributedCharacterIterator.setIndex(nArray[c]);
                Map<AttributedCharacterIterator.Attribute, Object> map = attributedCharacterIterator.getAttributes();
                attributedString2.addAttributes(map, c, c + 1);
            }
            if (nArray[0] == attributedCharacterIterator.getBeginIndex() + 1 && nArray[1] == attributedCharacterIterator.getBeginIndex()) {
                attributedCharacterIterator.first();
                Float f = (Float)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.X);
                Float f2 = (Float)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.Y);
                if (f != null && !f.isNaN()) {
                    attributedString2.addAttribute(GVTAttributedCharacterIterator.TextAttribute.X, new Float(Float.NaN), 1, 2);
                    attributedString2.addAttribute(GVTAttributedCharacterIterator.TextAttribute.X, f, 0, 1);
                }
                if (f2 != null && !f2.isNaN()) {
                    attributedString2.addAttribute(GVTAttributedCharacterIterator.TextAttribute.Y, new Float(Float.NaN), 1, 2);
                    attributedString2.addAttribute(GVTAttributedCharacterIterator.TextAttribute.Y, f2, 0, 1);
                }
            }
            attributedString = attributedString2;
        }
        attributedCharacterIterator = attributedString.getIterator();
        int n = attributedCharacterIterator.getBeginIndex();
        while (var6_11 < attributedCharacterIterator.getEndIndex()) {
            char c6 = attributedCharacterIterator.setIndex((int)var6_11);
            if (c6 >= '\u0600' && c6 <= '\u06ff') {
                attributedString.addAttribute(GVTAttributedCharacterIterator.TextAttribute.ARABIC_FORM, GVTAttributedCharacterIterator.TextAttribute.ARABIC_NONE, (int)var6_11, (int)(var6_11 + true));
            }
            ++var6_11;
        }
        attributedCharacterIterator.first();
        boolean bl3 = true;
        while (bl) {
            int n2 = attributedCharacterIterator.getRunStart(GVTAttributedCharacterIterator.TextAttribute.ARABIC_FORM);
            int n3 = attributedCharacterIterator.getRunLimit(GVTAttributedCharacterIterator.TextAttribute.ARABIC_FORM);
            attributedCharacterIterator.setIndex(n2);
            if (attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.ARABIC_FORM) != null) {
                for (int i = n2; i < n3; ++i) {
                    char c6;
                    char c7 = c6 = attributedCharacterIterator.setIndex(i);
                    int n4 = i - 1;
                    if (i > n2) {
                        c7 = attributedCharacterIterator.setIndex(n4);
                    }
                    while (ArabicTextHandler.arabicCharTransparent(c6) && i < n3) {
                        c6 = attributedCharacterIterator.setIndex(++i);
                    }
                    if (i >= n3) break;
                    if (ArabicTextHandler.arabicCharTransparent(c6)) continue;
                    if (n4 >= n2) {
                        if (ArabicTextHandler.arabicCharShapesRight(c7) && ArabicTextHandler.arabicCharShapesLeft(c6)) {
                            attributedCharacterIterator.setIndex(n4);
                            Integer n5 = (Integer)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.ARABIC_FORM);
                            n5 = new Integer(n5 + 1);
                            attributedString.addAttribute(GVTAttributedCharacterIterator.TextAttribute.ARABIC_FORM, n5, n4, n4 + 1);
                            attributedString.addAttribute(GVTAttributedCharacterIterator.TextAttribute.ARABIC_FORM, GVTAttributedCharacterIterator.TextAttribute.ARABIC_INITIAL, i, i + 1);
                        }
                        if (ArabicTextHandler.arabicCharShapesRight(c7) && ArabicTextHandler.arabicCharShapesLeft(c6) || !ArabicTextHandler.arabicCharShaped(c6)) continue;
                        attributedString.addAttribute(GVTAttributedCharacterIterator.TextAttribute.ARABIC_FORM, GVTAttributedCharacterIterator.TextAttribute.ARABIC_ISOLATED, i, i + 1);
                        continue;
                    }
                    if (!ArabicTextHandler.arabicCharShaped(c6)) continue;
                    attributedString.addAttribute(GVTAttributedCharacterIterator.TextAttribute.ARABIC_FORM, GVTAttributedCharacterIterator.TextAttribute.ARABIC_ISOLATED, i, i + 1);
                }
            }
            if (attributedCharacterIterator.setIndex(n3) != '\uffff') continue;
            bl = false;
        }
        return attributedString;
    }

    public static boolean arabicChar(char c) {
        char c2 = c;
        return c >= '\u0600' && c <= '\u06ff';
    }

    public static boolean containsArabic(AttributedString attributedString) {
        return ArabicTextHandler.containsArabic(attributedString.getIterator());
    }

    public static boolean containsArabic(AttributedCharacterIterator attributedCharacterIterator) {
        for (int i = attributedCharacterIterator.getBeginIndex(); i < attributedCharacterIterator.getEndIndex(); ++i) {
            char c = attributedCharacterIterator.setIndex(i);
            if (!ArabicTextHandler.arabicChar(c)) continue;
            return true;
        }
        return false;
    }

    public static boolean arabicCharTransparent(char c) {
        char c2 = c;
        return c2 >= '\u064b' && c2 <= '\u0655' || c2 == '\u0670' || c2 >= '\u06d6' && c2 <= '\u06e4' || c2 >= '\u06e7' && c2 <= '\u06e8' || c2 >= '\u06ea' && c2 <= '\u06ed';
    }

    private static boolean arabicCharShapesRight(char c) {
        char c2 = c;
        return c2 >= '\u0622' && c2 <= '\u0625' || c2 == '\u0627' || c2 == '\u0629' || c2 >= '\u062f' && c2 <= '\u0632' || c2 == '\u0648' || c2 >= '\u0671' && c2 <= '\u0673' || c2 >= '\u0675' && c2 <= '\u0677' || c2 >= '\u0688' && c2 <= '\u0699' || c2 == '\u06c0' || c2 >= '\u06c2' && c2 <= '\u06cb' || c2 == '\u06cd' || c2 == '\u06cf' || c2 >= '\u06d2' && c2 <= '\u06d3' || ArabicTextHandler.arabicCharShapesDuel(c);
    }

    private static boolean arabicCharShapesDuel(char c) {
        char c2 = c;
        return c2 == '\u0626' || c2 == '\u0628' || c2 >= '\u062a' && c2 <= '\u062e' || c2 >= '\u0633' && c2 <= '\u063a' || c2 >= '\u0641' && c2 <= '\u0647' || c2 >= '\u0649' && c2 <= '\u064a' || c2 >= '\u0678' && c2 <= '\u0687' || c2 >= '\u069a' && c2 <= '\u06bf' || c2 == '\u06c1' || c2 == '\u06cc' || c2 == '\u06ce' || c2 >= '\u06d0' && c2 <= '\u06d1' || c2 >= '\u06fa' && c2 <= '\u06fc';
    }

    private static boolean arabicCharShapesLeft(char c) {
        return ArabicTextHandler.arabicCharShapesDuel(c);
    }

    private static boolean arabicCharShaped(char c) {
        return ArabicTextHandler.arabicCharShapesRight(c);
    }

    public static int getSubstituteChar(String string, int n) {
        int[] nArray;
        if (charMap.containsKey(string) && n > 0 && (nArray = (int[])charMap.get(string))[n - 1] > 0) {
            return nArray[n - 1];
        }
        return -1;
    }

    public static String createSubstituteString(AttributedCharacterIterator attributedCharacterIterator) {
        String string = "";
        for (int i = attributedCharacterIterator.getBeginIndex(); i < attributedCharacterIterator.getEndIndex(); ++i) {
            char c = attributedCharacterIterator.setIndex(i);
            if (ArabicTextHandler.arabicChar(c)) {
                int n;
                Integer n2 = (Integer)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.ARABIC_FORM);
                if (ArabicTextHandler.charStartsLigature(c) && i < attributedCharacterIterator.getEndIndex()) {
                    n = attributedCharacterIterator.setIndex(i + 1);
                    Integer n3 = (Integer)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.ARABIC_FORM);
                    if (n2 != null && n3 != null) {
                        int n4;
                        if (n2.equals(GVTAttributedCharacterIterator.TextAttribute.ARABIC_TERMINAL) && n3.equals(GVTAttributedCharacterIterator.TextAttribute.ARABIC_INITIAL)) {
                            n4 = ArabicTextHandler.getSubstituteChar("" + c + (char)n, GVTAttributedCharacterIterator.TextAttribute.ARABIC_ISOLATED);
                            if (n4 > -1) {
                                string = string + (char)n4;
                                ++i;
                                continue;
                            }
                        } else if (n2.equals(GVTAttributedCharacterIterator.TextAttribute.ARABIC_TERMINAL)) {
                            n4 = ArabicTextHandler.getSubstituteChar("" + c + (char)n, GVTAttributedCharacterIterator.TextAttribute.ARABIC_TERMINAL);
                            if (n4 > -1) {
                                string = string + (char)n4;
                                ++i;
                                continue;
                            }
                        } else if (n2.equals(GVTAttributedCharacterIterator.TextAttribute.ARABIC_MEDIAL) && n3.equals(GVTAttributedCharacterIterator.TextAttribute.ARABIC_MEDIAL) && (n4 = ArabicTextHandler.getSubstituteChar("" + c + (char)n, GVTAttributedCharacterIterator.TextAttribute.ARABIC_MEDIAL)) > -1) {
                            string = string + (char)n4;
                            ++i;
                            continue;
                        }
                    }
                }
                if (n2 != null && n2 > 0) {
                    n = ArabicTextHandler.getSubstituteChar("" + c, n2);
                    if (n > -1) {
                        string = string + (char)n;
                        continue;
                    }
                    string = string + c;
                    continue;
                }
                string = string + c;
                continue;
            }
            string = string + c;
        }
        return string;
    }

    public static boolean charStartsLigature(char c) {
        char c2 = c;
        return c2 == '\u064b' || c2 == '\u064c' || c2 == '\u064d' || c2 == '\u064e' || c2 == '\u064f' || c2 == '\u0650' || c2 == '\u0651' || c2 == '\u0652' || c2 == '\u0622' || c2 == '\u0623' || c2 == '\u0625' || c2 == '\u0627';
    }

    public static int getNumChars(char c) {
        if (ArabicTextHandler.isLigature(c)) {
            return 2;
        }
        return 1;
    }

    public static boolean isLigature(char c) {
        char c2 = c;
        return c2 >= '\ufe70' && c2 <= '\ufe72' || c2 == '\ufe74' || c2 >= '\ufe76' && c2 <= '\ufe7f' || c2 >= '\ufef5' && c2 <= '\ufefc';
    }

    static {
        int[] nArray = new int[]{65136, -1, -1, -1};
        charMap.put(new String("\u064b "), nArray);
        int[] nArray2 = new int[]{-1, -1, -1, 65137};
        charMap.put(new String("\u064b\u0640"), nArray2);
        int[] nArray3 = new int[]{65138, -1, -1, -1};
        charMap.put(new String("\u064c "), nArray3);
        int[] nArray4 = new int[]{65140, -1, -1, -1};
        charMap.put(new String("\u064d "), nArray4);
        int[] nArray5 = new int[]{65142, -1, -1, -1};
        charMap.put(new String("\u064e "), nArray5);
        int[] nArray6 = new int[]{-1, -1, -1, 65143};
        charMap.put(new String("\u064e\u0640"), nArray6);
        int[] nArray7 = new int[]{65144, -1, -1, -1};
        charMap.put(new String("\u064f "), nArray7);
        int[] nArray8 = new int[]{-1, -1, -1, 65145};
        charMap.put(new String("\u064f\u0640"), nArray8);
        int[] nArray9 = new int[]{65146, -1, -1, -1};
        charMap.put(new String("\u0650 "), nArray9);
        int[] nArray10 = new int[]{-1, -1, -1, 65147};
        charMap.put(new String("\u0650\u0640"), nArray10);
        int[] nArray11 = new int[]{65148, -1, -1, -1};
        charMap.put(new String("\u0651 "), nArray11);
        int[] nArray12 = new int[]{-1, -1, -1, 65149};
        charMap.put(new String("\u0651\u0640"), nArray12);
        int[] nArray13 = new int[]{65150, -1, -1, -1};
        charMap.put(new String("\u0652 "), nArray13);
        int[] nArray14 = new int[]{-1, -1, -1, 65151};
        charMap.put(new String("\u0652\u0640"), nArray14);
        int[] nArray15 = new int[]{65152, -1, -1, -1};
        charMap.put(new String("\u0621"), nArray15);
        int[] nArray16 = new int[]{65153, 65154, -1, -1};
        charMap.put(new String("\u0622"), nArray16);
        int[] nArray17 = new int[]{65155, 65156, -1, -1};
        charMap.put(new String("\u0623"), nArray17);
        int[] nArray18 = new int[]{65157, 65158, -1, -1};
        charMap.put(new String("\u0624"), nArray18);
        int[] nArray19 = new int[]{65159, 65160, -1, -1};
        charMap.put(new String("\u0625"), nArray19);
        int[] nArray20 = new int[]{65161, 65162, 65163, 65164};
        charMap.put(new String("\u0626"), nArray20);
        int[] nArray21 = new int[]{65165, 65166, -1, -1};
        charMap.put(new String("\u0627"), nArray21);
        int[] nArray22 = new int[]{65167, 65168, 65169, 65170};
        charMap.put(new String("\u0628"), nArray22);
        int[] nArray23 = new int[]{65171, 65172, -1, -1};
        charMap.put(new String("\u0629"), nArray23);
        int[] nArray24 = new int[]{65173, 65174, 65175, 65176};
        charMap.put(new String("\u062a"), nArray24);
        int[] nArray25 = new int[]{65177, 65178, 65179, 65180};
        charMap.put(new String("\u062b"), nArray25);
        int[] nArray26 = new int[]{65181, 65182, 65183, 65184};
        charMap.put(new String("\u062c"), nArray26);
        int[] nArray27 = new int[]{65185, 65186, 65187, 65188};
        charMap.put(new String("\u062d"), nArray27);
        int[] nArray28 = new int[]{65189, 65190, 65191, 65192};
        charMap.put(new String("\u062e"), nArray28);
        int[] nArray29 = new int[]{65193, 65194, -1, -1};
        charMap.put(new String("\u062f"), nArray29);
        int[] nArray30 = new int[]{65195, 65196, -1, -1};
        charMap.put(new String("\u0630"), nArray30);
        int[] nArray31 = new int[]{65197, 65198, -1, -1};
        charMap.put(new String("\u0631"), nArray31);
        int[] nArray32 = new int[]{65199, 65200, -1, -1};
        charMap.put(new String("\u0632"), nArray32);
        int[] nArray33 = new int[]{65201, 65202, 65203, 65204};
        charMap.put(new String("\u0633"), nArray33);
        int[] nArray34 = new int[]{65205, 65206, 65207, 65208};
        charMap.put(new String("\u0634"), nArray34);
        int[] nArray35 = new int[]{65209, 65210, 65211, 65212};
        charMap.put(new String("\u0635"), nArray35);
        int[] nArray36 = new int[]{65213, 65214, 65215, 65216};
        charMap.put(new String("\u0636"), nArray36);
        int[] nArray37 = new int[]{65217, 65218, 65219, 65220};
        charMap.put(new String("\u0637"), nArray37);
        int[] nArray38 = new int[]{65221, 65222, 65223, 65224};
        charMap.put(new String("\u0638"), nArray38);
        int[] nArray39 = new int[]{65225, 65226, 65227, 65228};
        charMap.put(new String("\u0639"), nArray39);
        int[] nArray40 = new int[]{65229, 65230, 65231, 65232};
        charMap.put(new String("\u063a"), nArray40);
        int[] nArray41 = new int[]{65233, 65234, 65235, 65236};
        charMap.put(new String("\u0641"), nArray41);
        int[] nArray42 = new int[]{65237, 65238, 65239, 65240};
        charMap.put(new String("\u0642"), nArray42);
        int[] nArray43 = new int[]{65241, 65242, 65243, 65244};
        charMap.put(new String("\u0643"), nArray43);
        int[] nArray44 = new int[]{65245, 65246, 65247, 65248};
        charMap.put(new String("\u0644"), nArray44);
        int[] nArray45 = new int[]{65249, 65250, 65251, 65252};
        charMap.put(new String("\u0645"), nArray45);
        int[] nArray46 = new int[]{65253, 65254, 65255, 65256};
        charMap.put(new String("\u0646"), nArray46);
        int[] nArray47 = new int[]{65257, 65258, 65259, 65260};
        charMap.put(new String("\u0647"), nArray47);
        int[] nArray48 = new int[]{65261, 65262, -1, -1};
        charMap.put(new String("\u0648"), nArray48);
        int[] nArray49 = new int[]{65263, 65264, -1, -1};
        charMap.put(new String("\u0649"), nArray49);
        int[] nArray50 = new int[]{65265, 65266, 65267, 65268};
        charMap.put(new String("\u064a"), nArray50);
        int[] nArray51 = new int[]{65269, 65270, -1, -1};
        charMap.put(new String("\u0622\u0644"), nArray51);
        int[] nArray52 = new int[]{65271, 65272, -1, -1};
        charMap.put(new String("\u0623\u0644"), nArray52);
        int[] nArray53 = new int[]{65273, 65274, -1, -1};
        charMap.put(new String("\u0625\u0644"), nArray53);
        int[] nArray54 = new int[]{65275, 65276, -1, -1};
        charMap.put(new String("\u0627\u0644"), nArray54);
    }
}

